/*
 * FC_MediaPlayer_AudioDbusHandlingProxy.h
 *
 *  Created on: Oct 14, 2017
 *  Author: Preethika Sureshbabu
 *
 */

#ifndef GENERICMEDIAPLAYER_CCASERVICE_SRC_AUDIODBUSHANDLINGPROXY_H_ 
#define GENERICMEDIAPLAYER_CCASERVICE_SRC_AUDIODBUSHANDLINGPROXY_H_

#include <map>
#include<sstream>
#include<iostream>
#include "IPCProvider.h"


class fc_mediaplayer_tclApp;

class AudioDbusHandlingProxy : public IPCListener
{
public:
    /*
     * returns singleton instance of PAudioDbusHandlingProxy class
     **/
    static AudioDbusHandlingProxy &GetInstance();

    /*
     * constructor
     */
    AudioDbusHandlingProxy(void);

    /*
     * Destructer
     */
    virtual ~AudioDbusHandlingProxy();

    /*
     * To check for signalname in message
     */
    bool belongs(const char* messageName, const char* params) ;

    /*
     * Overridden to avoid pure virtual function
     */
    bool belongs(tU32 serial) ;

    /*
     * receives the dbus signal from the Audio and taken necessary action
     */
    void RouteSignal(const char* name, const char* params) ;

    /*
     * Overridden to avoid pure virtual function
     */
    void RouteMethodAnswer(tU32 serial, const char* params) ;

    /*
     * Overridden to avoid pure virtual function
     */
    void RouteMethodRequest(tU32 serial, const char* name, const char* params) ;

    /*
     * Overridden to avoid pure virtual function
     */
    void RouteError(tU32 serial, const char* error) ;

    void MainSinkSoundPropertyChanged(const char* params);

    void UpdateVolume(int Volume);

    int getCurrentVolumeinAudio();

    void setCurrentVolumeinAudio(int currentVolumeinAudio);

    void GetCurrentVolumeFromAudio();


private:


    fc_mediaplayer_tclApp* m_poMainAppInstance;

    /*Signal handlers*/
    typedef void (AudioDbusHandlingProxy::*MessageHandler)(const char* params,bool isError); /**< signature of generic message/error handler function */
    typedef void (AudioDbusHandlingProxy::*SignalHandler)(const char* params); /**< signature of generic message handler function */

    map<tU32, MessageHandler> mMessageHandlers; /**< map of DBus serial and specific message handler function */
    map<string, SignalHandler> mSignalHandlers; /**< map of signal name and specific signal handler function */

    vector<string> mInterfacenames;    /* Names of the Interface name for this component*/
    static int mCurrentVolumeinAudio;
    Lock m_MutexForVolume;
};

#endif /* GENERICMEDIAPLAYER_CCASERVICE_SRC_AUDIODBUSHANDLINGPROXY_H_ */
