/**
 * @author Stefan Scherber
 *
 * Implentation of CCAOutputWrapper
 *
 */

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_INTERFACE
#ifdef TARGET_BUILD
#include "trcGenProj/Header/CCAGenOutputWrapper.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_INTERFACE
#endif
#endif



#include "FC_MediaPlayer_main.h"
#include "FC_MediaPlayer_clienthandler_DeviceManager.h"
#include "FC_MediaPlayer_service_GenMediaPlayer.h"

#include "FC_MediaPlayer_service_AppControl.h"
#include "FC_MediaPlayer_clienthandler_IpodAuth.h"
#ifdef VARIANT_S_FTR_ENABLE_MP_AVMAN
#include "FC_MediaPlayer_clienthandler_AVManager.h"
#endif
#if defined (VARIANT_S_FTR_ENABLE_MP_SPI)
#include "FC_MediaPlayer_clienthandler_GenSPI.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_VIDEOMANAGER
#include "FC_MediaPlayer_clienthandler_Videomanager.h"
#endif
#if defined (VARIANT_S_FTR_ENABLE_CONN_MOST_FI)
#include "FC_MediaPlayer_clienthandler_GenBTSettings.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_ABSOLUTE_VOLUME_SUPPORT
#include "FC_MediaPlayer_AudioDbusHandlingProxy.h"
#endif
#include "ipodcommon.h"     //defines: IPOD_OK, IPOD_ERROR, etc.
#include "CCAGenOutputWrapper.h"
#include "VarTrace.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"



#define ARL_S_IMPORT_INTERFACE_GENERIC
#include "audio_routing_lib.h"
#include "FC_MediaPlayer_AudioRoutingHandler.h"

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/



CCAOutputWrapper::CCAOutputWrapper(tComponentID componentId, fc_mediaplayer_tclApp* poMainAppl):OutputWrapper(componentId) //finished 100%
{
    ENTRY
    mListSize = 0;
    mListID = 0;
    mListChangeType = LCH_CONTENT_CHANGED;
    mFavID = 0;
    mFavListChangeType = LCH_CONTENT_CHANGED;
    mFavListSize = 0;
    mStartStopLocationInfo = FALSE;
    mLocationInfoType.GPGGA =  0;
    mLocationInfoType.GPRMC =  0;
    mLocationInfoType.GPGSV =  0;
    mLocationInfoType.GPHDT =  0;
    mLocationInfoType.PASCD =  0;
    mLocationInfoType.PAGCD =  0;
    mLocationInfoType.PAACD =  0;
    ClearAppControlConnect();
    ClearAppControlCommand();
    ClearAppControlClose();
    ClearNativeTransportStart();
    ClearNativeTransportStop();
    mpApp = poMainAppl;
}


tResult CCAOutputWrapper::RequestAVActivation(const tSourceNr sourceNr, const tLogicalAVChannel logicalAVChannel, const tSource source, const tDeviceID deviceID)//finished: 100%
{
    ENTRY
    VARTRACE(sourceNr)
    VARTRACE(logicalAVChannel)
    VARTRACE(source)
    VARTRACE(deviceID)
    tResult result = 0;
    tDeviceInfo deviceInfo;

    result = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    VARTRACE(deviceInfo.connectionType);

    if((logicalAVChannel == LC_BT_AUDIO) || (LocalSPM::GetDataProvider().UseArlSrcBtAudio() && (deviceInfo.connectionType == DCT_BLUETOOTH)))
    {
        /* Request to activate static source Bluetooth Audio with Subsource 0*/
        if(LocalSPM::GetDataProvider().BTAudioSourceAsStatic() )
        {
        mpApp->GetAudioRoutingHandler().bSetAudioRouteRequest(SourceID(ARL_SRC_BTAUDIO,0),ARL_EN_ISRC_ACT_ON);
        }
        else
        {
            mpApp->GetAudioRoutingHandler().bSetAudioRouteRequest(SourceID(ARL_SRC_BTAUDIO, deviceID),ARL_EN_ISRC_ACT_ON);
        }
    }
    else
    {
        SourceID sourceID(ARL_SRC_CPRA2, deviceID);
        mpApp->GetAudioRoutingHandler().bSetAudioRouteRequest(sourceID, ARL_EN_ISRC_ACT_ON, ARL_EN_ROUTEREQ_REASON_OTHER);
    }

    return result;
}

tResult CCAOutputWrapper::UpdatePlaytime()  //finished: 100 %
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_PLAYTIME);
        //mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOPLAYTIME);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateNowPlaying() //finished: 100 %
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_NOWPLAYING);
        //mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOMETADATA);
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_CURRENTFOLDERPATH);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateActiveMediaDevice() //finished: 100 %
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_ACTIVEMEDIADEVICE);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdatePlaybackState() //finished: 100%
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKSTATE);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateMediaPlayerDeviceConnections() //finished: 100 %
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYERDEVICECONNECTIONS);
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPODEVICECONNECTIONS);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDeviceConnection(const tDeviceID _deviceID, const tConnectionReason connectionReason)
{
    ENTRY
    VARTRACE(_deviceID);
    VARTRACE(connectionReason);

    tResult result;
    tDeviceInfo deviceInfo;

    tU16 deviceID = (tU16)_deviceID;
    result = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN _deviceID);
    ETG_TRACE_USR1(("UpdateDeviceConnection: Connection reason: %d", connectionReason));

    tMediaContext mediacontext;
    if( LocalSPM::GetDataProvider().SeparateMediaContent())
   {
      LocalSPM::GetDBManager().GetMediaContext( OUT mediacontext);
    }

    arl_tenAvailabilityReason availabilityReason;
    switch(connectionReason)
    {
        case CR_SAME_MEDIA:
            availabilityReason = ARL_EN_REASON_SAMEMEDIA;
            break;
        case CR_ERROR:
            availabilityReason = ARL_EN_REASON_ERROR;
            break;
        default:
            availabilityReason = ARL_EN_REASON_NEWMEDIA;//CR_NEW_MEDIA
    }

    if(deviceInfo.deviceType == DTY_MUSICBOX)
    {
        availabilityReason = ARL_EN_REASON_SAMEMEDIA;
        if((deviceInfo.numberOfAudioFiles == NUMBER_OF_FILES_NONE) || (deviceInfo.numberOfAudioFiles == 0))
        {
            deviceInfo.numberOfAudioFiles = 1;
        }
         ETG_TRACE_USR1(("UpdateDeviceConnection: Connection reason: %d , files = %d",availabilityReason,deviceInfo.numberOfAudioFiles));
    }
    if (MP_NO_ERROR == result)
    {
        VARTRACE(deviceInfo.connectionState);
        VARTRACE(deviceInfo.numberOfAudioFiles);
        VARTRACE(deviceInfo.numberOfVideoFiles);

        // if state is connected the audio manager is informed about device state
        if (deviceInfo.connectionState == CS_CONNECTED)
        {
            if(ARL_EN_REASON_ERROR == availabilityReason)
            {
                if((deviceInfo.deviceID != DEVICE_ID_NOT_SET) && strlen(deviceInfo.mountPoint))
                {
                    if(IsMassStorageDevice(IN deviceInfo.deviceType))
                    {
                        /*check if read request on device related to this mount point is possible*/
                        if(!LocalSPM::GetDataProvider().checkIfDeviceConnected(deviceInfo.mountPoint))
                        {
                            VARTRACE(deviceInfo.connectionCount);
                            /*passing the connectioncount to avoid disconnecting, if Attached notification comes during this time*/
                            result = LocalSPM::GetDBManager().MarkDeviceCommunicationError(IN deviceInfo.deviceID,IN deviceInfo.connectionCount,IN deviceInfo.deviceType);
                            if(MP_NO_ERROR == result)
                            {
                                /*passing the connection count is not needed here since device state is checked here, which is marked to communication error
                                in the above call*/
                                result = LocalSPM::GetDBManager().DisconnectDeviceOnCommunicationError(IN deviceInfo.deviceID);
                                if(result)
                                {
                                    ETG_TRACE_ERR(("Error disconnecting Device with Communication Error %d/%s", result, errorString(result)));
                                    result = MP_NO_ERROR;
                                }
                            }
                            else
                            {
                                ETG_TRACE_ERR(("UpdateDeviceConnection:Error Marking DEVICE_COMMUNICATION_ERROR Error=%d/%s", result, errorString(result)));
                                result = MP_NO_ERROR;
                            }

                            unsigned int source = 0;
                            GetSource(OUT source,IN deviceInfo.deviceType,IN deviceInfo.connectionType);
                            ETG_TRACE_USR4(("UpdateDeviceConnection:device Not Accessible.Announcing not-playable."));
                            mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_PLAYABLE, availabilityReason, (arl_tenSource)source , deviceInfo.deviceID);
                        }
                        else
                        {
                            ETG_TRACE_USR4(("UpdateDeviceConnection:Mountpoint is accessible!.Discarded ARL_EN_REASON_ERROR"));
                        }
                    }
                    else
                    {
                        ETG_TRACE_FATAL(("Missing Handling of ARL_EN_REASON_ERROR for NON-MassStorage Devices"));
                    }
                }

            }
            else
            {
                if ((LocalSPM::GetDataProvider().UseArlSrcBtAudio() && (deviceInfo.deviceType == DTY_BLUETOOTH)) ||
                      ((LocalSPM::GetDataProvider().UseArlSrcBtAudioForIAPBT()) && ((deviceInfo.deviceType == DTY_IPOD) || (deviceInfo.deviceType == DTY_IPHONE)) && (deviceInfo.connectionType == DCT_BLUETOOTH)))
                {
                    // files available
                    ETG_TRACE_USR1(("UpdateDeviceConnection: playable content "));
                    mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_PLAYABLE, availabilityReason, ARL_SRC_BTAUDIO, deviceID);
                }
                else if (deviceInfo.deviceType == DTY_CDDA)
                {
                    // files available
                    ETG_TRACE_USR1(("UpdateDeviceConnection CDDA: playable content "));
                    mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_PLAYABLE, availabilityReason, ARL_SRC_CDDA, deviceID);
                }
                else if (deviceInfo.deviceType == DTY_DVD_DRIVE)
                {
                    // files available
                    ETG_TRACE_USR1(("UpdateDeviceConnection DVD: playable content "));
                    mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_PLAYABLE, availabilityReason, ARL_SRC_BLU_RAY, deviceID);
                }
                else if (((LocalSPM::GetDataProvider().SeparateMediaContent() && deviceInfo.numberOfAudioFiles == NUMBER_OF_FILES_NONE)
                        || (!LocalSPM::GetDataProvider().SeparateMediaContent() && ((deviceInfo.numberOfAudioFiles == NUMBER_OF_FILES_NONE && deviceInfo.numberOfVideoFiles==0 ) || (deviceInfo.numberOfVideoFiles==NUMBER_OF_FILES_NONE && deviceInfo.numberOfAudioFiles==0) || (deviceInfo.numberOfAudioFiles == NUMBER_OF_FILES_NONE && deviceInfo.numberOfVideoFiles == NUMBER_OF_FILES_NONE))))////RTC-341485
                        && (deviceInfo.deviceType != DTY_BLUETOOTH)
                        && (deviceInfo.deviceType != DTY_IPOD) && (deviceInfo.deviceType != DTY_IPHONE)) //CheryM31T 75744
                {
                    // number of files not known
                    ETG_TRACE_USR1(("UpdateDeviceConnection: playable content unknown"));
                    mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_PLAYABLE_UNKNOWN, availabilityReason, ARL_SRC_CPRA2, deviceID);
                }
                else if (((LocalSPM::GetDataProvider().SeparateMediaContent() && deviceInfo.numberOfAudioFiles==0)
                        ||(!LocalSPM::GetDataProvider().SeparateMediaContent() && deviceInfo.numberOfAudioFiles==0 && deviceInfo.numberOfVideoFiles==0))////RTC-341485
                        && (deviceInfo.deviceType != DTY_BLUETOOTH)
                        && (deviceInfo.deviceType != DTY_IPOD) && (deviceInfo.deviceType != DTY_IPHONE)) //CheryM31T 75744
                {
                    // no files available
                    ETG_TRACE_USR1(("UpdateDeviceConnection: no playable content "));
                    mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_PLAYABLE, ARL_EN_REASON_NO_CONTENT, ARL_SRC_CPRA2, deviceID);
                }
                else
                {
                    // files available
                    ETG_TRACE_USR1(("UpdateDeviceConnection: playable content "));
                    mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_PLAYABLE, availabilityReason, ARL_SRC_CPRA2, deviceID);
                }

        /* Inform Audio about Video source Availability */
        if (((IsMassStorageDevice( IN deviceInfo.deviceType)) || ((LocalSPM::GetDataProvider().MTPVideoSupport()) && (DTY_MTP == deviceInfo.deviceType))) && (LocalSPM::GetDataProvider().SeparateMediaContent()))
        {
                   #ifdef VARIANT_S_FTR_ENABLE_MP_AUTOPLAY
            if ((deviceInfo.numberOfVideoFiles == NUMBER_OF_FILES_NONE))
            {
                // number of video files not known
                ETG_TRACE_USR1(("UpdateDeviceConnection: playable content unknown for Video Source"));
                      mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_PLAYABLE_UNKNOWN, ARL_EN_REASON_SAMEMEDIA, ARL_SRC_USB_VIDEO, deviceID);
            }

            else if ((deviceInfo.numberOfVideoFiles == 0))
            {
                // no video files available
                ETG_TRACE_USR1(("UpdateDeviceConnection: no playable content for Video Source "));

                      mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_PLAYABLE, ARL_EN_REASON_NO_CONTENT, ARL_SRC_USB_VIDEO, deviceID);

            }
            else
            {
                // Video files available
                ETG_TRACE_USR1(("UpdateDeviceConnection: playable content for Video Source "));
                      mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_PLAYABLE, ARL_EN_REASON_SAMEMEDIA, ARL_SRC_USB_VIDEO, deviceID);
            }
                 #endif
        }
        /*trigger property updated for "MediaplayerDeviceConnections"*/
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYERDEVICECONNECTIONS);
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPODEVICECONNECTIONS);
       }
        }
        else if (CS_OVERTEMP == deviceInfo.connectionState) //Roadmap-13035 Overtemp
        {
            ETG_TRACE_USR1(("UpdateDeviceConnection: over temperature"));
            if (DTY_CDDA == deviceInfo.deviceType)
            {
                //fix for NCG3D-51734
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_TEMPERATURE, ARL_SRC_CDDA, deviceID);
            }
            else
            {
            mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_TEMPERATURE, ARL_SRC_CPRA2, deviceID);
            }
        if ( deviceInfo.numberOfVideoFiles > 0)
        {
           #ifdef VARIANT_S_FTR_ENABLE_MP_AUTOPLAY
           mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_TEMPERATURE, ARL_SRC_USB_VIDEO, deviceID);
          #endif
        }
        }
        else if (CS_UNDERVOLTAGE == deviceInfo.connectionState)
        {
            ETG_TRACE_USR1(("UpdateDeviceConnection: under voltage"));
            mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_VOLTAGE, ARL_SRC_CPRA2, deviceID);
        if ( deviceInfo.numberOfVideoFiles > 0)
        {
           #ifdef VARIANT_S_FTR_ENABLE_MP_AUTOPLAY
           mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_VOLTAGE, ARL_SRC_USB_VIDEO, deviceID);
           #endif
        }
        }
        else if ((CS_DISCONNECTED == deviceInfo.connectionState) && (DR_HW_MALFUNC == deviceInfo.disconnectReason))
        {
            if (DTY_CDDA == deviceInfo.deviceType)
            {
                //fix for NCG3D-23434
                ETG_TRACE_USR1(("UpdateDeviceConnection: ARL_SRC_CDDA hardware malfunction"));
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_VOLTAGE, ARL_SRC_CDDA, deviceID);
            }
            else
            {
                ETG_TRACE_USR1(("UpdateDeviceConnection: ARL_SRC_CPRA2 hardware malfunction"));
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_VOLTAGE, ARL_SRC_CPRA2, deviceID);
            if ( deviceInfo.numberOfVideoFiles > 0)
            {
               #ifdef VARIANT_S_FTR_ENABLE_MP_AUTOPLAY
               mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_VOLTAGE, ARL_SRC_USB_VIDEO, deviceID);
              #endif
             }
            }
        }
        else if ((CS_DISCONNECTED == deviceInfo.connectionState) && (DR_INTERNALDISCONNECT == deviceInfo.disconnectReason))
        {
            if ( (LocalSPM::GetDataProvider().UseArlSrcBtAudio() && (deviceInfo.deviceType == DTY_BLUETOOTH)) ||
                    (((deviceInfo.deviceType == DTY_IPOD) || (deviceInfo.deviceType == DTY_IPHONE)) && (deviceInfo.connectionType == DCT_BLUETOOTH)) )
            {
                #if defined VARIANT_S_FTR_ENABLE_INF4CV || defined VARIANT_S_FTR_ENABLE_SMART
                    mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_VOLTAGE, ARL_SRC_BTAUDIO, deviceID);
                #else
                    mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_NOMEDIA, ARL_SRC_BTAUDIO, deviceID);
                #endif
            }
            //For DVD Drive, drive moved to disconnect when disc is ejected and it is internal disconnection
            else if (deviceInfo.deviceType == DTY_DVD_DRIVE )
            {
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_NOMEDIA, ARL_SRC_BLU_RAY, deviceID);
            }
            else
            {
                ETG_TRACE_USR1(("UpdateDeviceConnection: internal disconnect"));
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_VOLTAGE, ARL_SRC_CPRA2, deviceID);
                if ( deviceInfo.numberOfVideoFiles > 0)
                {
                    #ifdef VARIANT_S_FTR_ENABLE_MP_AUTOPLAY
                    mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_VOLTAGE, ARL_SRC_USB_VIDEO, deviceID);
                    #endif
                }
            }
        }
        else if ((CS_DISCONNECTED == deviceInfo.connectionState) && (DR_HW_MALFUNC_PERMANENT == deviceInfo.disconnectReason))
        {
            if (DTY_CDDA == deviceInfo.deviceType)
            {
                //fix for NCG3D-23434
                ETG_TRACE_USR1(("UpdateDeviceConnection: ARL_SRC_CDDA hardware malfunction permanent"));
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_NOMEDIA, ARL_SRC_CDDA, deviceID);
            }
            else
            {
                ETG_TRACE_USR1(("UpdateDeviceConnection: ARL_SRC_CPRA2 hardware malfunction permanent"));
                //Changes done for NCG3D-14402. These changes are done after a discussion with Audio team.
                //On hardware malfunction permanent scenario, the mediaplayer sends the source as not avaiable. As a result the source will be removed by audio and this will cause a source switch
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_NOMEDIA, ARL_SRC_CPRA2, deviceID);
            if ( deviceInfo.numberOfVideoFiles > 0)
            {
              #ifdef VARIANT_S_FTR_ENABLE_MP_AUTOPLAY
              mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_SAMEMEDIA, ARL_SRC_USB_VIDEO, deviceID);
             #endif
            }
            }
        }
        else
        {
            ETG_TRACE_USR1(("UpdateDeviceConnection: device removed "));
            if ((LocalSPM::GetDataProvider().UseArlSrcBtAudio() && (deviceInfo.deviceType == DTY_BLUETOOTH)) ||
                     ((deviceInfo.deviceType == DTY_IPOD) || (deviceInfo.deviceType == DTY_IPHONE)) && (deviceInfo.connectionType == DCT_BLUETOOTH))
            {
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_NOMEDIA, ARL_SRC_BTAUDIO, deviceID);
            }
            else if (deviceInfo.deviceType == DTY_CDDA )
            {
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_NOMEDIA, ARL_SRC_CDDA, deviceID);
            }
            else if (deviceInfo.deviceType == DTY_DVD_DRIVE )
            {
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_NOMEDIA, ARL_SRC_BLU_RAY, deviceID);
            }
            else
            {
                mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_NOMEDIA, ARL_SRC_CPRA2, deviceID);
            if ( deviceInfo.numberOfVideoFiles > 0 )
            {
              #ifdef VARIANT_S_FTR_ENABLE_MP_AUTOPLAY
              mpApp->GetAudioRoutingHandler().bSetSourceAvailability(ARL_EN_SRC_NOT_AVAILABLE, ARL_EN_REASON_SAMEMEDIA, ARL_SRC_USB_VIDEO, deviceID);
             #endif
            }
            }
        }
    }
    return 0;
}


tResult CCAOutputWrapper::UpdateIndexingState() //finished: 100 %
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_INDEXINGSTATE);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdatePlaybackMode() //finished: 100 %
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKMODE);
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKREPEATMODE);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateRepeatMode() //finished: 100 %
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_REPEATMODE);
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_PLAYBACKREPEATMODE);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdatePhoneInfo()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOPHONEDATA);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateBTProfileInfo()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_CONNECTEDBLUETOOTHPROFILES);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPONowPlaying()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPONOWPLAYING);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPOMetaData()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOMETADATA);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPOPlaytime()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOPLAYTIME);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPOPlaybackStatus()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOPLAYBACKSTATUS);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPOPlaybackShuffleMode()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOPLAYBACKSHUFFLEMODE);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPOPlaybackRepeatMode()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOPLAYBACKREPEATMODE);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPOCallState()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOCALLSTATE);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPOCallDuration()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOCALLDURATION);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPOCommunications()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOCOMMUNICATIONS);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateSlideshowState()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_SLIDESHOWSTATE);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateNowShowing()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_NOWSHOWING);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateSlideshowTime()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_SLIDESHOWTIME);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPOLocationInfo()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOLOCATIONINFO);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateDiPOGPRMCDataStatusValues()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOGPRMCDATASTATUSVALUES);
    }
    return 0;
}

tResult CCAOutputWrapper::DIPORoleSwitchRequired(const tDeviceID deviceID,const tMountPoint USBSerialNumber,const tBool DeviceCarplayCapability)
{
    ENTRY
    VARTRACE(deviceID)
    VARTRACE(USBSerialNumber)
    tResult result = -1;
    #if defined (VARIANT_S_FTR_ENABLE_MP_SPI)
    if (mpApp)
    {
        result = mpApp->GetCCAClientHandlerSPI().SendDIPORoleSwitchRequired(deviceID, USBSerialNumber,DeviceCarplayCapability);
    }
    #endif
    return result;
}

tResult CCAOutputWrapper::GetBTLimitationModeFromBTClient(const tDeviceSerialNumber serialNumber, tBTLimitationActionState& btLimitation)
{
    ENTRY
    VARTRACE(serialNumber);
    tResult result = -1;
#if defined (VARIANT_S_FTR_ENABLE_CONN_MOST_FI)
    if(mpApp)
    {
        result = mpApp->GetCCAClientHandlerGenBTSettings().GetBTLimitationModeForMountPoint(serialNumber,btLimitation);
    }
#endif
    return result;
}

tResult CCAOutputWrapper::SendFavoritesChanged(tListChangeType listChangeType, tListSize listSize, tFavoriteID favID) //finished: 100 %
{
    ENTRY
    VARTRACE(listChangeType)
    VARTRACE(listSize)
    VARTRACE(favID)
    // function not available in G3G
    return 0;
}


tResult CCAOutputWrapper::SendMediaPlayerListChanged(tListID listID, tListChangeType listChangeType, tListSize listSize, vector<tPosition> changedItems) //finished: 100%
{
    ENTRY
    VARTRACE(listID)
    VARTRACE(listChangeType)
    VARTRACE(listSize)
    VARTRACE(changedItems)
    // lock to avoid parallel access
    mSendMediaPlayerListChangedLock.lock();
    SetMediaPlayerListChanged(listID, listChangeType, listSize, changedItems);
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYERLISTCHANGE);
    }
    mSendMediaPlayerListChangedLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::SetFavoriteChanged(tListChangeType listChangeType, tListSize listSize, tFavoriteID favID) //finished: 100%
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    mFavID = favID;
    mFavListSize = listSize;
    mFavListChangeType = listChangeType;
    mAccessLock.unlock();
    return 0;
}


tResult CCAOutputWrapper::SetMediaPlayerListChanged(tListID listID, tListChangeType listChangeType, tListSize listSize, vector<tPosition> changedItems) //finished: 100%
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    mListID = listID;
    mListChangeType = listChangeType;
    mListSize = listSize;
    mChangedItems = changedItems;
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::GetMediaPlayerListChanged(tListID &listID, tListChangeType &listChangeType, tListSize &listSize, vector<tPosition> &changedItems) //finished: 100%
{
    ENTRY
    mAccessLock.lock();
    listID = mListID;
    listChangeType = mListChangeType;
    listSize = mListSize;
    changedItems = mChangedItems;
    mAccessLock.unlock();
    VARTRACE(listID)
    VARTRACE(listChangeType)
    VARTRACE(listSize)
    VARTRACE(changedItems)
    return 0;
}

tResult CCAOutputWrapper::GetFavoriteChanged(tListChangeType &listChangeType, tListSize &listSize, tFavoriteID &favID) //finished: 100%
{
    ENTRY
    mAccessLock.lock();
    favID = mFavID;
    listSize = mFavListSize;
    listChangeType = mFavListChangeType;
    mAccessLock.unlock();
    VARTRACE(favID)
    VARTRACE(listSize)
    VARTRACE(listChangeType)
    return 0;
}

tResult CCAOutputWrapper::SetAppControlConnect(const tMountPoint deviceID, const tAppName appName, const tSessionID sessionID,const tProtocolName protocolName)
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    memcpy(mDeviceIDConnect,deviceID, sizeof mDeviceIDConnect);
    memcpy(mAppNameConnect,appName, sizeof mAppNameConnect);
    mSessionIDConnect = sessionID;
    memcpy(mProtocolNameConnect,protocolName, sizeof mProtocolNameConnect);
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::SetAppControlCommand(const tMountPoint deviceID, const tAppName appName, const tSessionID sessionID, const tSize sizeOfBuffer, const tCommandBufferPtr commandBuffer)
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    memcpy(mDeviceIDCommand, deviceID, sizeof mDeviceIDCommand);
    memcpy(mAppNameCommand, appName, sizeof mAppNameCommand);
    mSessionIDCommand = sessionID;
    mSizeOfBufferCommand = sizeOfBuffer;
    mCommandBufferCommand = commandBuffer;
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::SetAppControlClose(const tMountPoint deviceID, const tAppName appName, const tSessionID sessionID)
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    memcpy(mDeviceIDClose,deviceID, sizeof mDeviceIDClose);
    memcpy(mAppNameClose,appName, sizeof mAppNameClose);
    mSessionIDClose = sessionID;
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::SetNativeTransportStart(const tDeviceID deviceId, const tU8 iAP2iOSAppIdentifier, const tU8 sinkEndpoint, const tU8 sourceEndpoint )
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    mDeviceIdStart             = deviceId;
    mIAP2iOSAppIdentifierStart = iAP2iOSAppIdentifier;
    mSinkEndpointStart         = sinkEndpoint;
    mSourceEndpointStart       = sourceEndpoint;
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::SetNativeTransportStop(const tDeviceID deviceId, const tU8 iAP2iOSAppIdentifier, const tU8 sinkEndpoint, const tU8 sourceEndpoint )
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    mDeviceIdStop             = deviceId;
    mIAP2iOSAppIdentifierStop = iAP2iOSAppIdentifier;
    mSinkEndpointStop         = sinkEndpoint;
    mSourceEndpointStop       = sourceEndpoint;
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::GetAppControlConnect(tMountPoint &deviceID, tAppName &appName, tSessionID &sessionID,tProtocolName &protocolName)
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    memcpy(deviceID, mDeviceIDConnect, sizeof mDeviceIDConnect);
    memcpy(appName, mAppNameConnect, sizeof mAppNameConnect);
    sessionID = mSessionIDConnect;
    memcpy(protocolName,mProtocolNameConnect, sizeof mProtocolNameConnect);
    mAccessLock.unlock();
    VARTRACE(deviceID)
    VARTRACE(appName)
    VARTRACE(sessionID)
    VARTRACE(mProtocolNameConnect);
    return 0;
}

tResult CCAOutputWrapper::GetAppControlCommand(tMountPoint &deviceID,  tAppName &appName, tSessionID &sessionID, tSize &sizeOfBuffer,  tCommandBufferPtr &commandBuffer)
{
    ENTRY
    mAccessLock.lock();
    memcpy(deviceID, mDeviceIDCommand, sizeof deviceID);
    memcpy(appName, mAppNameCommand, sizeof appName);
    sessionID = mSessionIDCommand;
    sizeOfBuffer = mSizeOfBufferCommand;
    commandBuffer = mCommandBufferCommand;
    mAccessLock.unlock();
    VARTRACE(deviceID)
    VARTRACE(appName)
    VARTRACE(sessionID)
    VARTRACE(sizeOfBuffer)
    return 0;
}

tResult CCAOutputWrapper::GetAppControlClose(tMountPoint &deviceID, tAppName &appName, tSessionID &sessionID)
{
    ENTRY
    mAccessLock.lock();
    memcpy(deviceID, mDeviceIDClose, sizeof mDeviceIDClose);
    memcpy(appName, mAppNameClose, sizeof mAppNameClose);
    sessionID = mSessionIDClose;
    mAccessLock.unlock();
    VARTRACE(deviceID);
    VARTRACE(appName)
    VARTRACE(sessionID)
    return 0;
}

tResult CCAOutputWrapper::GetNativeTransportStart(tDeviceID &deviceId,tU8 &iAP2iOSAppIdentifier, tU8 &sinkEndpoint, tU8 &sourceEndpoint )
{
   ENTRY
   mAccessLock.lock();
   deviceId             = mDeviceIdStart;
   iAP2iOSAppIdentifier = mIAP2iOSAppIdentifierStart;
   sinkEndpoint         = mSinkEndpointStart;
   sourceEndpoint       = mSourceEndpointStart;
   mAccessLock.unlock();
   VARTRACE(deviceId);
   VARTRACE(iAP2iOSAppIdentifier);
   VARTRACE(sinkEndpoint)
   VARTRACE(sourceEndpoint)
   return 0;
}

tResult CCAOutputWrapper::GetNativeTransportStop(tDeviceID &deviceId,tU8 &iAP2iOSAppIdentifier, tU8 &sinkEndpoint, tU8 &sourceEndpoint )
{
   ENTRY
   mAccessLock.lock();
   deviceId             = mDeviceIdStop;
   iAP2iOSAppIdentifier = mIAP2iOSAppIdentifierStop;
   sinkEndpoint         = mSinkEndpointStop;
   sourceEndpoint       = mSourceEndpointStop;
   mAccessLock.unlock();
   VARTRACE(deviceId);
   VARTRACE(iAP2iOSAppIdentifier);
   VARTRACE(sinkEndpoint)
   VARTRACE(sourceEndpoint)
   return 0;
}

tResult CCAOutputWrapper::ClearAppControlConnect()
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    memset(mDeviceIDConnect,0, sizeof mDeviceIDConnect);
    memset(mAppNameConnect,0, sizeof mAppNameConnect);
    memset(mProtocolNameConnect,0, sizeof mProtocolNameConnect);
    mSessionIDConnect = 0;
    mAccessLock.unlock();
    return 0;
}


tResult CCAOutputWrapper::ClearAppControlCommand()
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    memset(mDeviceIDCommand, 0, sizeof mDeviceIDCommand);
    memset(mAppNameCommand, 0, sizeof mAppNameCommand);
    memset(mDeviceIDCommand, 0, sizeof mDeviceIDCommand);
    mSessionIDCommand = 0;
    mSizeOfBufferCommand = 0;
    mCommandBufferCommand = NULL;
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::ClearAppControlClose()
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    memset(mDeviceIDClose,0, sizeof mDeviceIDClose);
    memset(mAppNameClose,0, sizeof mAppNameClose);
    mSessionIDClose = 0;
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::ClearNativeTransportStart()
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    mDeviceIdStart = 0;
    mIAP2iOSAppIdentifierStart = 0;
    mSinkEndpointStart = 0;
    mSourceEndpointStart = 0;
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::ClearNativeTransportStop()
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    mDeviceIdStop = 0;
    mIAP2iOSAppIdentifierStop = 0;
    mSinkEndpointStop = 0;
    mSourceEndpointStop = 0;
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::SendGetMediaObjectAlbumArtInfoAnswer(tMimeType mimeType, tImageSize size, tUserContext userContext) //finished: 100%
{
    ENTRY
    VARTRACE(mimeType)
    VARTRACE(size)
    VARTRACE(userContext)
    if (mpApp)
    {
        if (MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_ID == userContext.serviceID)
            mpApp->GetCCACCAServiceMediaPlayer().SendGetMediaObjectAlbumArtInfoAnswer(mimeType, size, userContext);
        else if (MPLAY_APPCONTROLFI_C_U16_SERVICE_ID == userContext.serviceID)
            mpApp->GetCCACCAServiceAppControl().SendGetMediaObjectAlbumArtInfoAnswer(mimeType, size, userContext);
        else
            ETG_TRACE_FATAL(("SendGetMediaObjectAlbumArtInfoAnswer: unknown service"));
    }
    return 0;
}

tResult CCAOutputWrapper::SendGetMediaObjectAlbumArtInfoError(tErrorCode errorCode, tUserContext userContext) //finished: 100%
{
    ENTRY
    VARTRACE(errorCode)
    VARTRACE(userContext)
    if (mpApp)
    {
        if (MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_ID == userContext.serviceID)
            mpApp->GetCCACCAServiceMediaPlayer().SendError(errorCode, userContext);
        else if (MPLAY_APPCONTROLFI_C_U16_SERVICE_ID == userContext.serviceID)
            mpApp->GetCCACCAServiceAppControl().SendError(errorCode, userContext);
        else
            ETG_TRACE_FATAL(("SendGetMediaObjectAlbumArtError: unknown service"));
    }
    return 0;
}

tResult CCAOutputWrapper::SendGetMediaObjectAlbumArtAnswer(tImageData imageData,  tImageSize imageSize, tUserContext userContext) //finished: 100%
{
    ENTRY
    VARTRACE(imageSize)
    VARTRACE(userContext)
    if (mpApp)
    {
        if (MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_ID == userContext.serviceID)
            mpApp->GetCCACCAServiceMediaPlayer().SendGetMediaObjectAlbumArtAnswer(imageData, imageSize, userContext);
        else if (MPLAY_APPCONTROLFI_C_U16_SERVICE_ID == userContext.serviceID)
           mpApp->GetCCACCAServiceAppControl().SendGetMediaObjectAlbumArtAnswer(imageData, imageSize, userContext);
        else
            ETG_TRACE_FATAL(("SendGetMediaObjectAlbumArtAnswer: unknown service"));
    }
    return 0;
}

tResult CCAOutputWrapper::SendGetMediaObjectAlbumArtError(tErrorCode errorCode, tUserContext userContext) //finished: 100%
{
    ENTRY
    VARTRACE(errorCode)
    VARTRACE(userContext)
    if (mpApp)
    {
        if (MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_ID == userContext.serviceID)
            mpApp->GetCCACCAServiceMediaPlayer().SendError(errorCode, userContext);
        else if (MPLAY_APPCONTROLFI_C_U16_SERVICE_ID == userContext.serviceID)
            mpApp->GetCCACCAServiceAppControl().SendError(errorCode, userContext);
        else
            ETG_TRACE_FATAL(("SendGetMediaObjectAlbumArtInfoError: unknown service"));
    }
    return 0;
}

tResult CCAOutputWrapper::SendCommandAnswer(const tMountPoint mountPoint, const tAppName appName, const tSessionID sessionID, const tUserContext userContext)
{
    ENTRY
    VARTRACE(mountPoint)
    VARTRACE(appName)
    VARTRACE(sessionID)
    VARTRACE(userContext)
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().SendCommandAnswer(mountPoint, appName, sessionID,  userContext);
    }
    return 0;
}

tResult CCAOutputWrapper::SendDiPOActiveDeviceAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext)
{
    ENTRY
    VARTRACE(diPOResponse)
    VARTRACE(userContext)
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().SendDiPOActiveDeviceAnswer(diPOResponse, userContext);
    }
    return 0;
}

tResult CCAOutputWrapper::SendDiPORoleSwitchRequestAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext)
{
    ENTRY
    VARTRACE(diPOResponse)
    VARTRACE(userContext)
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().SendDiPORoleSwitchRequestAnswer(diPOResponse, userContext);
    }
    return 0;
}


tResult CCAOutputWrapper::GetWiFiCredentials(const tDeviceID deviceId, const tMACAddress appleDeviceMACAddress)
{
    ENTRY
    VARTRACE(deviceId)
    VARTRACE(appleDeviceMACAddress)
    tResult result = -1;
    #if defined (VARIANT_S_FTR_ENABLE_MP_SPI)
    if (mpApp)
    {
        result = mpApp->GetCCAClientHandlerSPI().SendGetWiFiCredentials(deviceId,appleDeviceMACAddress);
    }
    #endif
    return result;
}


tResult CCAOutputWrapper::SendDiPOTransferGPSDataAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext)
{
    ENTRY
    VARTRACE(diPOResponse)
    VARTRACE(userContext)
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().SendDiPOTransferGPSDataAnswer(diPOResponse, userContext);
    }
    return 0;
}

tResult CCAOutputWrapper::SendDiPOTransferDRDataAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext)
{
    ENTRY
    VARTRACE(diPOResponse)
    VARTRACE(userContext)
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().SendDiPOTransferDRDataAnswer(diPOResponse, userContext);
    }
    return 0;
}

tS32 CCAOutputWrapper::AuthenticationInit(tBool bInit) //finished: 100%
{
    ENTRY
    if (mpApp)
        return mpApp->GetCCAClientHandlerIPodAuthentication().AuthenticationInit(bInit);
    else
        return IPOD_ERROR;
}

tS32 CCAOutputWrapper::AccessoryCertificate(tU16 *certLength, tU8 *certData)//finished: 100%
{
    ENTRY
    if (mpApp)
        return mpApp->GetCCAClientHandlerIPodAuthentication().AccessoryCertificate(certLength, certData);
    else
        return IPOD_ERROR;
}

tS32 CCAOutputWrapper::IPodCertificate(tU16 certLength, tU8 *certData)//finished: 100%
{
    ENTRY
    if (mpApp)
        return mpApp->GetCCAClientHandlerIPodAuthentication().IPodCertificate(certLength, certData);
    else
        return IPOD_ERROR;
}

tS32 CCAOutputWrapper::SetSignature(tU16 sigDataLen, tU8 *sigData)//finished: 100%
{
    ENTRY
    if (mpApp)
        return mpApp->GetCCAClientHandlerIPodAuthentication().SetSignature(sigDataLen, sigData);
    else
        return IPOD_ERROR;
}

tS32 CCAOutputWrapper::GenSignature(const tU8  *ResponseBuffer, tU16 *SignatureDataLength, tU8 *SignatureData)//finished: 100%
{
    ENTRY
    if (mpApp)
        return mpApp->GetCCAClientHandlerIPodAuthentication().GenSignature(ResponseBuffer, SignatureDataLength, SignatureData);
    else
        return IPOD_ERROR;
}

tS32 CCAOutputWrapper::GetChallenge(tU16 *ChallengeDataLength, tU8 *ChallengeData)//finished: 100%
{
    ENTRY
    if (mpApp)
        return mpApp->GetCCAClientHandlerIPodAuthentication().GetChallenge(ChallengeDataLength, ChallengeData);
    else
        return IPOD_ERROR;
}

tS32 CCAOutputWrapper::DeviceID (tU32 *DeviceID)//finished: 100%
{
    ENTRY
    if (mpApp)
        return mpApp->GetCCAClientHandlerIPodAuthentication().DeviceID(DeviceID);
    else
        return IPOD_ERROR;
}

tS32 CCAOutputWrapper::FirmwareVersion (tU8 *majorVer, tU8 *minorVer)//finished: 100%
{
    ENTRY
    if (mpApp)
        return mpApp->GetCCAClientHandlerIPodAuthentication().FirmwareVersion(majorVer, minorVer);
    else
        return IPOD_ERROR;
}

tS32 CCAOutputWrapper::AuthenticationProtocolVersion (tU8 *majorVer, tU8 *minorVer)//finished: 100%
{
    ENTRY
    if (mpApp)
        return mpApp->GetCCAClientHandlerIPodAuthentication().AuthenticationProtocolVersion(majorVer, minorVer);
    else
        return IPOD_ERROR;
}

tS32 CCAOutputWrapper::IPodAuthenticationSelftest (tU8 *certificate, tU8 *private_key, tU8 *ram_check, tU8 *checksum)//finished: 100%
{
    ENTRY
    if (mpApp)
        return mpApp->GetCCAClientHandlerIPodAuthentication().IPodAuthenticationSelftest(certificate, private_key, ram_check, checksum);
    else
        return IPOD_ERROR;
}


tResult CCAOutputWrapper::AppControlConnect(const tMountPoint deviceID, const tAppName appName, const tSessionID sessionID,const tProtocolName protocolName)
{
    ENTRY
    mSendAppControlConnectLock.lock();
    SetAppControlConnect(deviceID,appName,sessionID,protocolName);
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_SESSIONOPENED);
    }
    mSendAppControlConnectLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::AppControlCommand(const tMountPoint deviceID, const tAppName appName, const tSessionID sessionID, const tSize sizeOfBuffer, const tCommandBufferPtr commandBuffer)
{
    ENTRY
    mSendAppControlCommandLock.lock();
    SetAppControlCommand(deviceID,appName,sessionID,sizeOfBuffer,commandBuffer);
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DATARESPONSE);
    }
    ClearAppControlCommand();
    mSendAppControlCommandLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::AppControlClose(const tMountPoint deviceID, const tAppName appName, const tSessionID sessionID)
{
    ENTRY
    mSendAppControlCloseLock.lock();
    SetAppControlClose(deviceID,appName,sessionID);
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_SESSIONCLOSED);
    }
    ClearAppControlConnect(); // set Connect sessionID to 0; Close sessionID is not set to 0!
    mSendAppControlCloseLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::NativeTransportStart(const tDeviceID deviceId, const tU8 iAP2iOSAppIdentifier, const tU8 sinkEndpoint, const tU8 sourceEndpoint )
{
    ENTRY
    mSendNativeTransportStartLock.lock();
    SetNativeTransportStart(deviceId, iAP2iOSAppIdentifier,sinkEndpoint,sourceEndpoint);
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_NATIVETRANSPORTSTART);
    }
    mSendNativeTransportStartLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::NativeTransportStop(const tDeviceID deviceId, const tU8 iAP2iOSAppIdentifier, const tU8 sinkEndpoint, const tU8 sourceEndpoint )
{
    ENTRY
    mSendNativeTransportStopLock.lock();
    SetNativeTransportStop(deviceId, iAP2iOSAppIdentifier,sinkEndpoint,sourceEndpoint);
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_NATIVETRANSPORTSTOP);
    }
    //ClearNativeTransportStart(); //reset start parameters
    mSendNativeTransportStopLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::RequestConnectedDevices()
{
    ENTRY
    if(mpApp)
    {
        mpApp->GetCCAClientHandlerDeviceManager().vRequestConnectedDevices();
    }
    return 0;
}


tResult CCAOutputWrapper::RequestMuteState(const tMuteState muteState, const tRampType rampType)  //Roadmap 13018
{
    ENTRY
    VARTRACE(muteState)
    VARTRACE(rampType)

    if (MUS_MUTED == muteState)
        mpApp->GetAudioRoutingHandler().bSetMuteState(ARL_SRC_CPRA2, ARL_EN_MUTEACTION_MUTE, ARL_EN_MUTE_REASON_OTHER);
    else if(MUS_DEMUTED == muteState)
    {
        if(FAST_RAMP == rampType)
        {   // NCG3D-84092 Audio ramp should be given as fast ramp on starting of the track
            mpApp->GetAudioRoutingHandler().bSetMuteState(ARL_SRC_CPRA2, ARL_EN_MUTEACTION_DEMUTE, ARL_EN_MUTE_REASON_TRACK_START);
        }
        else
        {
            mpApp->GetAudioRoutingHandler().bSetMuteState(ARL_SRC_CPRA2, ARL_EN_MUTEACTION_DEMUTE, ARL_EN_MUTE_REASON_OTHER);
        }
    }
    else
    {
        ETG_TRACE_USR1(("Out of MUTE / DEMUTE Case"));
    }
    return MP_NO_ERROR;
}

tResult CCAOutputWrapper::RequestVolumeChange(const tVolumeState volumeState)
{
    ENTRY
    VARTRACE(volumeState)

    tDeviceInfo deviceInfo;
    tResult result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceGet(deviceInfo);

    if (MP_NO_ERROR != result) return result;

    //NCG3D-18265
    arl_tenSource arlSource;
    if (LocalSPM::GetDataProvider().UseArlSrcBtAudio() && (DTY_BLUETOOTH == deviceInfo.deviceType))
    {
        ETG_TRACE_USR1(("RequestVolumeChange: BT AUDIO "));
        arlSource = ARL_SRC_BTAUDIO;
    }
    else if ((DTY_CDDA == deviceInfo.deviceType))
    {
        ETG_TRACE_USR1(("RequestVolumeChange: CDDA "));
        arlSource = ARL_SRC_CDDA;
    }
    else if ((DTY_DVD_DRIVE == deviceInfo.deviceType))
    {
        ETG_TRACE_USR1(("RequestVolumeChange: DVD DRIVE "));
        arlSource = ARL_SRC_BLU_RAY;
    }
    else
    {
        ETG_TRACE_USR1(("RequestVolumeChange: CPRA2 for Other sources like IPOD, MTP, USB."));
        arlSource = ARL_SRC_CPRA2;
    }

    if (VOS_REDUCED == volumeState)
    {
        mpApp->GetAudioRoutingHandler().bSetAudioProperty(arlSource, ARL_SRC_INPUT_GAIN, LocalSPM::GetDataProvider().FFVolumeReductionDB(), deviceInfo.deviceID);
    }
    else
    {
        mpApp->GetAudioRoutingHandler().bSetAudioProperty(arlSource, ARL_SRC_INPUT_GAIN, 0, deviceInfo.deviceID);
    }

    return MP_NO_ERROR;
}

//HMI sends to VD_DVM
tResult CCAOutputWrapper::SendEjectOpticalDisc(tDMOpticalDiscEjectCmd enOpticalDiscEjectCmd) //Roadmap 15002_CDAudio_DetectionAndDiagnosis
{
    ENTRY
    if(mpApp)
    {
        mpApp->GetCCAClientHandlerDeviceManager().SendEjectOpticalDisc(enOpticalDiscEjectCmd);
    }
    return 0;
}

//VD_DVM sends to HMI
tResult CCAOutputWrapper::SendOpticalDiscEjectMethodResult(tDMOpticalDiscEjectMethodResult entOpticalDiscEjectMethodResult)//Roadmap 15002_CDAudio_DetectionAndDiagnosis
{
    ENTRY
    if(mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().SendOpticalDiscEjectMethodResult(entOpticalDiscEjectMethodResult);
    }
    return 0;
}


//VD_DVM sends to HMI
tResult CCAOutputWrapper::UpdateOpticalDiscSlotState() //Roadmap 15002_CDAudio_DetectionAndDiagnosis
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYEROPTICALDISCSLOTSTATE);
    }
    return 0;
}

//VD_DVM sends to HMI
tResult CCAOutputWrapper::UpdateCDInfo() //Update CD-Info
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYEROPTICALDISCCDINFO);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateScanMode() //Roadmap 15008
{
    ENTRY
    if(mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_SCANMODE);
    }

    return MP_NO_ERROR;
}

//Roadmap 16014 'full text search'
tResult CCAOutputWrapper::Send_onCreateMediaPlayerListSearchString_MethodReturnFirst(IN tListID listIDParent, IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY
    if(mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().Send_onCreateMediaPlayerListSearchString_MethodReturnFirst(IN listIDParent,IN listID, IN listSize, IN deviceID);
    }

    return MP_NO_ERROR;
}

//Roadmap 16014 'full text search'
tResult CCAOutputWrapper::Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle(IN tListID listIDParent,IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY
    if(mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle(IN listIDParent, IN listID, IN listSize, IN deviceID);
    }

    return MP_NO_ERROR;
}

//Roadmap 16014 'full text search'
tResult CCAOutputWrapper::Send_onCreateMediaPlayerListSearchString_MethodReturnLast(IN tListID listIDParent, IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY
    if(mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().Send_onCreateMediaPlayerListSearchString_MethodReturnLast(IN listIDParent,IN listID, IN listSize, IN deviceID);
    }

    return MP_NO_ERROR;

}

//Roadmap 16014 'full text search'
tResult CCAOutputWrapper::Send_onCreateMediaPlayerListSearchString_MethodReturnAbort(IN tListID listIDParent, IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY
    if(mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().Send_onCreateMediaPlayerListSearchString_MethodReturnAbort(IN listIDParent,IN listID, IN listSize, IN deviceID);
    }

    return MP_NO_ERROR;

}



tResult CCAOutputWrapper::UpdateIpodCommunicationError(const tDeviceID deviceID, tIpodCommError iPodCommError) //CMG3G-8083
{
    ENTRY
    VARTRACE(deviceID);
    VARTRACE(iPodCommError);
    SetIpodCommunicationError(deviceID, iPodCommError);
    if(mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_IPODCOMMUNICATIONERROR);
    }

    return MP_NO_ERROR;
}

tResult CCAOutputWrapper::SetIpodCommunicationError(const tDeviceID deviceID, const tIpodCommError iPodCommError)
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    mDeviceIdComm = deviceID;
    mIpodCommError = iPodCommError;
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::GetIpodCommunicationError(tDeviceID &deviceID, tIpodCommError &iPodCommError)
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    deviceID = mDeviceIdComm;
    iPodCommError = mIpodCommError;
    mAccessLock.unlock();
    VARTRACE(deviceID)
    VARTRACE(iPodCommError)
    return 0;
}

tResult CCAOutputWrapper::UpdateDipoCommunicationError(const tDeviceID deviceID, tIpodCommError iPodCommError, const tMountPoint USBSerialNumber) //CMG3G-8083
{
    ENTRY
    VARTRACE(deviceID);
    VARTRACE(iPodCommError);
    VARTRACE(USBSerialNumber);
    SetDipoCommunicationError(deviceID, iPodCommError, USBSerialNumber);
    if(mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOCOMMUNICATIONERROR);
    }

    return MP_NO_ERROR;
}

tResult CCAOutputWrapper::SetDipoCommunicationError(const tDeviceID deviceID, const tIpodCommError iPodCommError, const tMountPoint USBSerialNumber)
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    mDeviceIdComm = deviceID;
    mIpodCommError = iPodCommError;
    memcpy(mUSBSerialNumberComm, USBSerialNumber, sizeof mUSBSerialNumberComm);
    mAccessLock.unlock();
    return 0;
}

tResult CCAOutputWrapper::GetDipoCommunicationError(tDeviceID &deviceID, tIpodCommError &iPodCommError, tMountPoint &USBSerialNumber)
{
    ENTRY_INTERNAL
    mAccessLock.lock();
    deviceID = mDeviceIdComm;
    iPodCommError = mIpodCommError;
    memcpy(USBSerialNumber, mUSBSerialNumberComm, sizeof USBSerialNumber);
    mAccessLock.unlock();
    VARTRACE(deviceID)
    VARTRACE(iPodCommError)
    VARTRACE(USBSerialNumber)
    return 0;
}

tResult CCAOutputWrapper::UpdateVideoProperty(IN const tVideoProperty videoProperty) //finished: 100 %
{
    ENTRY
    if (mpApp)
    {
        switch(videoProperty)
        {
            case VP_BRIGHTNESS:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_VIDEOBRIGHTNESS);
                break;
            }
            case VP_HUE:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_VIDEOHUE);
                break;
            }
            case VP_SATURATION:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_VIDEOSATURATION);
                break;
            }
            case VP_CONTRAST:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_VIDEOCONTRAST);
                break;
            }
            case VP_BRIGHTNESS_OFFSET:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_VIDEOBRIGHTNESSOFFSET);
                break;
            }
            case VP_HUE_OFFSET:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_VIDEOHUEOFFSET);
                break;
            }
            case VP_SATURATION_OFFSET:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_VIDEOSATURATIONOFFSET);
                break;
            }
            default:
            {
                ETG_TRACE_ERR(("Invalid video property type: %u",videoProperty));
                break;
            }
        }
    }
    return MP_NO_ERROR;
}

tResult CCAOutputWrapper::UpdateDiPOPower()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOPOWER);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateRippingStatus()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_RIPPINGSTATE);
    }
    return 0;
}

tResult CCAOutputWrapper::UpdateAutoRipping()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_AUTORIPPING);
    }
    return 0;
}
tResult CCAOutputWrapper::UpdateRippingErrors()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_RIPPINGERRORS);
    }
    return 0;
}
tResult CCAOutputWrapper::UpdateGracenoteLookupMode()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_GRACENOTELOOKUPMODE);
    }
    return 0;
}
tResult CCAOutputWrapper::UpdateRippingEncodingQuality()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_RIPPINGENCODINGQUALITY);
    }
    return 0;
}
tResult CCAOutputWrapper::UpdateGNdataforAlbumOnUserDemand()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_GNMETADATAEXTRACTIONSTATUS);
    }
    return 0;
}
tResult CCAOutputWrapper::UpdateGraceNoteResolveAmbiguity()
{
    ENTRY
    if(mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_RESOLVEGRACENOTEAMBUIGUITIES);
    }
    return 0;
}
tResult CCAOutputWrapper::UpdateGracenoteVersion()
{
    ENTRY
    if(mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_GRACENOTEVERSION);
    }
    return 0;
}
tResult CCAOutputWrapper::UpdateDVDProperty(const tDvdProperty dvdProperty)
{
    ENTRY
    if (mpApp)
    {
        switch(dvdProperty)
        {
            case DISCERROR:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DISCERROR);
                break;
            }
            case DIRECTSELECTAVAILABLE:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DIRECTSELECTAVAILABLE);
                break;
            }
            case CMSKIPAVAILABLE:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_CMSKIPAVAILABLE);
                break;
            }
            case DVDMENUPLAYBACKONGOING:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DVDMENUPLAYBACKONGOING);
                break;
            }
            case DISCMECHANICALINFO:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DISCMECHANICALINFO);
                break;
            }
            case DVDDRIVEINFO:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DVDDRIVEINFO);
                mpApp->GetCCAClientHandlerDeviceManager().vUpdateDVDDriveInfo(); //Update to Devicemanager property
                break;
            }
            case DISPLAYMODE:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DISPLAYMODE);
                break;
            }
            case DRCSETTING:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DRCSETTING);
                break;
            }
            case KEYCOMMANDRESPONSE:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DVDCOMMANDSTATUS);
                break;
            }
            case DVDANGLEINFO:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DVDANGLEINFO);
                break;
            }
            case DVDAUDIOCHANNELINFO:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DISCERROR);
                break;
            }
            case DVDCURRENTAUDIOINFO:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DVDCURRENTAUDIOINFO);
                break;
            }
            case DVDPLAYERLANGSETTING:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DVDPLAYERLANGSETTING);
                break;
            }
            case DVDSUBTITLEINFO:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DVDSUBTITLEINFO);
                break;
            }
            case ANGLEMARKSETTING:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_ANGLEMARKSETTING);
                break;
            }
            case PLAYSTATUSSETTING:
            {
                mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_PLAYSTATUSSETTING);
                break;
            }
            default:
            {
                ETG_TRACE_ERR(("Invalid dvd property type: %u",dvdProperty));
                break;
            }

        }
    }
    return MP_NO_ERROR;
}

void CCAOutputWrapper::GetSource(unsigned int &source ,const tDeviceType deviceType,const tConnectionType connectionType)
{
    source = ARL_SRC_NONE;

    switch(deviceType)
    {
        case DTY_BLUETOOTH:
        {
            if(LocalSPM::GetDataProvider().UseArlSrcBtAudio())
            {
                source = ARL_SRC_BTAUDIO;
            }
            else
            {
                source = ARL_SRC_CPRA2;
            }
            break;
        }
        case DTY_IPOD:
        case DTY_IPHONE:
        {
            if(LocalSPM::GetDataProvider().UseArlSrcBtAudio() && (DCT_BLUETOOTH == connectionType))
            {
                source = ARL_SRC_BTAUDIO;
            }
            else
            {
                source = ARL_SRC_CPRA2;
            }
            break;
        }
        case DTY_CDDA:
            source = ARL_SRC_CDDA;
            break;
        case DTY_DVD_DRIVE:
            source = ARL_SRC_BLU_RAY;
            break;
        case DTY_USB:
        case DTY_SD:
        case DTY_MTP:
        case DTY_MSZUNE:
        case DTY_CDROM:
        case DTY_MYMEDIA:
        case DTY_FLASH:
        case DTY_CS:
            source = ARL_SRC_CPRA2;
            break;
        default:
            break;
    }
}

//-->Roadmap 16003 : CD Ripping With Gracenote

tResult CCAOutputWrapper::Send_OnDeleteMediaContentMethodResult(IN tDeleteMediaContentType deleteMediaContentType, IN tFileOperationErrorCodes fileOperationErrorCodes, IN tU16 numofFilesDeleted )
{
    ENTRY
    tResult res = MP_NO_ERROR;
    if (mpApp)
    {
       mpApp->GetCCACCAServiceMediaPlayer().Send_OnDeleteMediaContentMethodResult(deleteMediaContentType,fileOperationErrorCodes,numofFilesDeleted);
    }
    return res;

}

tResult CCAOutputWrapper::Send_OnEditMetadataMethodResult(IN tEditMetadatatType editMetadatatType, IN tFileOperationErrorCodes fileOperationErrorCodes  )
{
    ENTRY
    tResult res = MP_NO_ERROR;
    if (mpApp)
    {
       mpApp->GetCCACCAServiceMediaPlayer().Send_OnEditMetaDataMethodResult(editMetadatatType,fileOperationErrorCodes);
    }
    return res;

}

tResult CCAOutputWrapper::Send_OnAddFileNamesToPlaylistMethodResult(IN tResult playListOperationErrorCodes )
{
    ENTRY
    tResult res = MP_NO_ERROR;
    if (mpApp)
    {
       mpApp->GetCCACCAServiceMediaPlayer().Send_OnAddFileNameToPlaylistMethodResult(playListOperationErrorCodes);
    }
    return res;
}

tResult CCAOutputWrapper::Send_OnDeleteEntriesFromPlaylistMethodResult(IN tResult playListOperationErrorCodes )
{
    ENTRY
    tResult res = MP_NO_ERROR;
    if (mpApp)
    {
       mpApp->GetCCACCAServiceMediaPlayer().Send_OnDeleteEntryFromPlaylistMethodResult(playListOperationErrorCodes);
    }
    return res;
}
//CID 145999, 184724 : Missing return statement
//<--Roadmap 16003 : 'CD Ripping With Gracenote'
tResult CCAOutputWrapper::UpdateStreamingInfo()
{
    ENTRY
    if (mpApp)
    {
       mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_DEVICESTREAMINGINFO);
    }
    return MP_NO_ERROR;
}
//>--Roadmap CMG3G-10221 : 'Scene Recorder '
tResult CCAOutputWrapper::Send_SetfilePermissionByMediaobjectTagsMethodResult(IN tResult filePermissionError, IN tU16 numofFiles)
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().Send_SetfilePermissionByMediaobjectTagsMethodResult(filePermissionError,numofFiles);
    }
    return MP_NO_ERROR;
}
//<--Roadmap CMG3G-10221 : 'Scene Recorder '}
#ifdef IAP2_DEFAULT_ROUTEGUIDANCEDISPLAYCOMPONENT
tResult CCAOutputWrapper::UpdateDiPORouteGuidance()
{
    ENTRY
    tResult res = MP_NO_ERROR;
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCE);
    }
    return res;
}

tResult CCAOutputWrapper::UpdateDiPORouteGuidanceManeuver()
{
    ENTRY
    tResult res = MP_NO_ERROR;
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCEMANEUVER);
    }
    return res;
}
#endif
tResult CCAOutputWrapper::UpdateDiPORouteGuidance()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCE2);
    }
    return MP_NO_ERROR;
}

tResult CCAOutputWrapper::UpdateDiPORouteGuidanceManeuver()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPOROUTEGUIDANCEMANEUVER2);
    }
    return MP_NO_ERROR;
}

tResult CCAOutputWrapper::UpdateDVDVideoSourceStatus(const bool activeStatus)
{
    ENTRY
    VARTRACE(activeStatus)
    tResult result = -1;
    #if defined (VARIANT_S_FTR_ENABLE_MP_VIDEOMANAGER)
    if (mpApp)
    {
        mpApp->GetVideoManagerClientHandler().vSendDVDVideoSourceState(activeStatus);
    }
    #endif
    return result;
}

tResult CCAOutputWrapper::vSendVideoStateAcknowledgement(const tVideoSourceState currentStatus)
{
    ENTRY
    VARTRACE(currentStatus)
    tResult result = -1;
    #if defined (VARIANT_S_FTR_ENABLE_MP_VIDEOMANAGER)
    if (mpApp)
    {
        mpApp->GetVideoManagerClientHandler().vSendVideoStateAcknowledgement(currentStatus);
    }
    #endif
    return result;
}


tResult CCAOutputWrapper::AddOobPairedDevice(const tDeviceID deviceID,const tMACAddress deviceAddress,const tDeviceName deviceName, const tLinkKey linkKey,const tBTOobType oobType)
{
    ENTRY
    tResult result = -1;
#if defined (VARIANT_S_FTR_ENABLE_CONN_MOST_FI)
    if(mpApp)
    {
        result = mpApp->GetCCAClientHandlerGenBTSettings().AddOobPairedDevice(deviceID,deviceAddress,deviceName,linkKey,oobType);
    }
#endif
    return result;
}

tResult CCAOutputWrapper::SendRequestDVDTemperatureAnswer(tU16 temperature , tUserContext userContext) //finished: 100%
{
    ENTRY
    VARTRACE(temperature)
    VARTRACE(userContext)
    if (mpApp)
    {
        if (MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_ID == userContext.serviceID)
            mpApp->GetCCACCAServiceMediaPlayer().SendRequestDVDTemperatureAnswer(temperature,userContext);
       // else if (MPLAY_APPCONTROLFI_C_U16_SERVICE_ID == userContext.serviceID)
           // mpApp->GetCCACCAServiceAppControl().SendRequestDVDTemperatureAnswer(temperature,userContext);
        else
            ETG_TRACE_FATAL(("SendRequestDVDTemperatureAnswer: unknown service"));
    }
    return 0;
}
tResult CCAOutputWrapper::UpdatePlaybackSpeed()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_UPDATEPLAYBACKSPEED);
    }
    return MP_NO_ERROR;
}

void CCAOutputWrapper::UpdateVolumeToAudio(int Volume)
{
    ENTRY
    VARTRACE(Volume);
    if (mpApp)
    {
#ifdef VARIANT_S_FTR_ENABLE_ABSOLUTE_VOLUME_SUPPORT
        mpApp->GetAudioDbusHandlingProxy().UpdateVolume(Volume);
#endif
    }
}
void CCAOutputWrapper::UpdateFolderBrowseStructureCleared()
{
    ENTRY
    if (mpApp)
        {
            mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_FOLDERBROWSESTRUCTURECLEARED);
        }
}
void CCAOutputWrapper::GetCurrentVolumeFromAudio()
{
    ENTRY
    if (mpApp)
    {
#ifdef VARIANT_S_FTR_ENABLE_ABSOLUTE_VOLUME_SUPPORT
        mpApp->GetAudioDbusHandlingProxy().GetCurrentVolumeFromAudio();
#endif
    }
}
void CCAOutputWrapper::UpdateReadyToPlay()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceMediaPlayer().updateClients(MPLAY_MEDIAPLAYERFI_C_U16_READYTOPLAY);
    }
}

tResult CCAOutputWrapper::SendDisconnectSPPService(const tMACAddress deviceAddress)
{
    ENTRY
    VARTRACE(deviceAddress);

    tResult result = MP_ERROR;
#if defined (VARIANT_S_FTR_ENABLE_CONN_MOST_FI)
    if(mpApp)
    {
        result = mpApp->GetCCAClientHandlerGenBTSettings().DisconnectSPPService(deviceAddress);
    }
#endif

    return result;
}

tResult CCAOutputWrapper::UpdateDiPODeviceTime()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCACCAServiceAppControl().updateClients(MPLAY_APPCONTROLFI_C_U16_DIPODEVICETIMEUPDATE);
    }
    return MP_NO_ERROR;
}

void CCAOutputWrapper::RequestDeviceManagerNotifyConnection()
{
    ENTRY
    if (mpApp)
    {
        mpApp->GetCCAClientHandlerDeviceManager().RequestDeviceManagerNotifyConnection();
    }
}
