/*!
  * \file spm_SubStateHandlerConfig.cpp
  *  \brief
  *    Configuration of SubStates
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author            | Modification
  * 07.09.11  | TMS Fischer       | initial version
  ******
  */

// FI-zone starts
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"
#include "dp_generic_if.h"

// SPM  configuration
#include "spm_Config.h"

// my class header
#include "spm_SubStateHandlerConfig.h"

// spm class definitions w/o interface
#include "spm_security.h"

// interfaces class definitions
#include "spm_IOsalProxy.h"
#include "spm_ISystemStateManager.h"
#include "spm_IFactory.h"

#include "spm_ICcaServiceServer.h"

// spm helper
#include "spm_PowerOnCount.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_SSH_PRJ
 #include "trcGenProj/Header/spm_SubStateHandlerConfig.cpp.trc.h"
#endif
// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"


/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/
// //#define SPM_TRACE_FILE_ID   SPM_FILE_SUBSTATEHANDLERCONFIG

spm_tclSubStateHandlerConfig::spm_tclSubStateHandlerConfig( const ISpmFactory& factory,
                                                            tU16               u16AppId )
   : spm_tclSubStateHandler( factory, u16AppId )
   , _bCurrentIgnitionState( FALSE ){

   _u32SubStateForceReset = 0;

   _u32FastShutdownReason = 0;

   // _u32IgnCounter = 0;

   vCheckIgnitionSource( );
}

spm_tclSubStateHandlerConfig::~spm_tclSubStateHandlerConfig( ){
}

tVoid spm_tclSubStateHandlerConfig::vGetReferences( ){
   spm_tclSubStateHandler::vGetReferences( );
}

tVoid spm_tclSubStateHandlerConfig::vCheckIgnitionSource( ){
   // check HW Ignition
   dp_tclSpmDpFeatureHwIgnition oHwIgn;

   _bHwIgnition = (tBool)(oHwIgn.tGetData( ));
}

tBool spm_tclSubStateHandlerConfig::bCheckForFastShutdown( tU32 u32FastShutdownReason ){

   tBool bReturn             = FALSE;

   tU32  u32TmpShutdowReason = _u32FastShutdownReason & ~u32FastShutdownReason;

   if ( ( u32TmpShutdowReason & _u32FastShutdownReason ) == 0 ){
      // stop fastshutdown
      bReturn = FALSE;

      // ETG_TRACE_USR4(("!!!!!!!!!!! STOP FASTSHUTDOWN !!!!!!!"));
   } else {
      // continue fastshutdown
      bReturn = TRUE;

      // ETG_TRACE_USR4(("!!!!!!!!!!! CONTINUE FASTSHUTDOWN !!!!!!!"));
   }


   return( bReturn );
} // bCheckForFastShutdown

tVoid spm_tclSubStateHandlerConfig::vPrjSubStateType( tU32  u32TriggerType,
                                                      tBool bTriggerState ){

   if ( bTriggerState ){
      ISpmSystemStateManager *poclSystemStateManager = dynamic_cast < ISpmSystemStateManager* >( _crfFactory.getSpmObjHandler( "ISpmSystemStateManager" ) );
      SPM_NULL_POINTER_CHECK( poclSystemStateManager );
      SPM_NULL_POINTER_CHECK( _poclOsalProxy );

      if ( poclSystemStateManager->bPointOfNoReturnReached( ) ){
         spm_tclSubStateHandler::vTraceTrigger( SSH_vWakeupTrigger, &_tTriggerWakeup );
         if ( bIsDataFlag( &_tTriggerWakeup, u32TriggerType ) ){
            // reboot immediately because trigger is a wakeup
            ETG_TRACE_USR4( ( "!!!!!!!!!!! REBOOT --> immediately because trigger is a wakeup !!!!!!!" ) );
            (void) _poclOsalProxy->bShutdownSystem( SPM_C_S32_SYSTEMINIT_RESET_WARMSTART );
         }
      }
   }

   SPM_NULL_POINTER_CHECK( _poclCcaServiceHandler );
   if ( u32TriggerType == SPM_U32_IGNITION ){
      if ( bTriggerState && !_bCurrentIgnitionState ){
         // increment IgnitionCycles property if Ignition state changes from OFF to ON.
         _u32IgnitionCycleCount++;
         spm_corefi_tclMsgIgnitionCyclesStatus oIgnitionCycles;
         oIgnitionCycles.IgnitionCycle = _u32IgnitionCycleCount;
         _poclCcaServiceHandler->vUpdateProperty( SPM_COREFI_C_U16_IGNITIONCYCLES, &oIgnitionCycles );
      }
      _bCurrentIgnitionState = bTriggerState;
   }

   if ( u32TriggerType == SPM_U32_CODE_REQUEST ){

      spm_corefi_tclMsgCodeRequestStateStatus tCodeRequestState;
      tCodeRequestState.CodeRequestState.enType = spm_fi_tcl_SPM_e32_CODE_REQUEST::FI_EN_SPM_U32_CODE_IDLE;

      if ( bTriggerState ){
         tCodeRequestState.CodeRequestState.enType = spm_fi_tcl_SPM_e32_CODE_REQUEST::FI_EN_SPM_U32_CODE_REQUESTED;
      }
      _poclCcaServiceHandler->vUpdateProperty( SPM_COREFI_C_U16_CODEREQUESTSTATE, &tCodeRequestState );

   }

} // vPrjSubStateType

// EOF

