/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SubStateDebounce.h
  * @brief        definition of states to be debounced
  * @copyright    (C) 2016 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_ISubStateDebounce.h"

// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------
#define SPM_HWGPIO_IDLE      0
#define SPM_HWGPIO_WAITING   1
#define SPM_HWGPIO_SEND      2

#define SPM_HWGPIO_DELAY_POLLING      100
#define SPM_HWGPIO_DELAY_IDLE         1000
#define SPM_HWGPIO_DELAY_BLOCK        1000
#define SPM_HWGPIO_DELAY_DEBOUNCING   1

#define SPM_HWGPIO_TIPPER_TOGGLE_TIME 3000

#define SPM_HWGPIO_TO_INVALID     0xffffffff

// -----------------------------------------------------------------------------
// class definition
// -----------------------------------------------------------------------------
class ISpmWupOnOffEvents;

class ISpmSubStateClient;

/*!
  *  \class spm_tclHwSig
  *  \brief This project specific class handles general input/output(GPIO) hardware signals.
          It reads and updates GPIO signals. It also maintains GPIO configuration.

        This class uses class spm_tclOsalProxyConfig to set GPIO and to install callback GPIO functionalities. And class spm_tclSubStateHandlerConfig to
        set substate type.

          The spm_tclFactory object creates an instance of this class.
     class spm_tclSubStateHandlerConfig uses this class to check GPIO signals.
  */
class spm_tclSubStateDebounce : public ISpmSubStateDebounce
{
private:
static spm_tclSubStateDebounce *_pMyStaticRef;

OSAL_tMQueueHandle              _hGpioQueueHandle;

tBool                bPostMessage( tU32 u32Msg );

// implementation of spm_tclActive
virtual tVoid vOnStart( );

virtual tVoid vOnTerminate( );

virtual tVoid main( );

struct TGpioCfg
{
   tU32 u32TriggerType;
   tBool bState;
   tU32 u32LastChange;
   tBool bDebouncedState;
   tBool bHwState;
   tU32 u32ChangeIntervall;
   tU32 u32MaxCount;
   tU32 u32ChangeCount;
   tU32 u32StartCountingTime;
   tBool bBlocked;
   tU32 u32BlockTime;
   tBool bEnabled;
};

TGpioCfg _tGpioCfg[eGpioMax];

tU8 u8UpdateGpio( tU32  u32GpioId,
                  tBool bForce = FALSE );

tU32 u32GetNextTriggerGpio( tU32 u32GpioId ) const;

tU32 u32GetGpioId( tU32 u32SubState );

tVoid vCheckCount( tU32 u32GpioId );

tU32                _u32LastTrigger;

tBool               _bTestMode;

tU32                _u32ThreadWaitingDelay;
tBool               _bPollingActive;

ISpmSubStateClient *_poclSubStateHandler;
ISpmWupOnOffEvents *_poclOnOffEventHandler;

public:
/* +++
   Enter your public Data and functions here
 +++ */
/*---------------------------------------------------------------------*/
spm_tclSubStateDebounce( const ISpmFactory& factory ); // constructor
virtual ~spm_tclSubStateDebounce( void );              // destruktor
/*---------------------------------------------------------------------*/


virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual tVoid vHandleTraceMessage( const tUChar *puchData ){ (void )puchData ;} 
virtual const tChar*getName( ) const { return( "spm_tclSubStateDebounce" ); }

virtual tVoid vTraceSignals( );

virtual tVoid vCheckSignals( );

virtual tVoid vSetTestMode( tBool bTstMode ){ _bTestMode = bTstMode; }

virtual tBool bUpdateSubState( tU32  u32Substate,
                               tBool bActive );

virtual tVoid vDisableSubstateDebounce( tU32 u32Substate );

virtual tVoid vEnableSubstateDebounce( tU32 u32Substate );

};
// EOF

