/*!
  * \file spm_StartupSystem_config.cpp
  *  \brief
  *    Project depending functions for startup
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author                      | Modification
  * 29.10.12  | CM-AI/PJ-CB32, Kollai       |
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_Config.h"
#include "spm_StartupSystem.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_PRJ
 #include "trcGenProj/Header/spm_StartupSystem_config.cpp.trc.h"
#endif
// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"


// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------

// ------------------------------------------------------------------------------
tBool spm_tclStartupSystem::bAlternativeProcConfig(tChar *strProcessName, tBool bValidationOnly){
   (tVoid)strProcessName;
   return( TRUE );
}

tVoid spm_tclStartupSystem::vProjectSpecificSetup( tCString strConfigPath,
                                                   tCString strInstance ){
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( strConfigPath );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( strInstance );
}

tVoid spm_tclStartupSystem::onPreProcessStart( OSAL_trProcessAttribute *processAttributes ) const {
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( processAttributes );
}

tVoid spm_tclStartupSystem::onPostProcessStart( OSAL_trProcessAttribute *processAttributes ) const {
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( processAttributes );
}

tVoid spm_tclStartupSystem::vSetStartUpFinishedProcessConfiguration( tU32 instance ){
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( instance );
   /* Intentionally Blank */
}

// EOF

