/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SubStateHandlerConfig.h
  * @brief        This is header file contains project specific interface functions for SubStateHandler.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_StartupSystem.h"

/*!
  *  \class spm_tclStartupSystemConfig
  *  \brief

        The spm_tclFactory object creates an instance of this class.
  */
class spm_tclStartupSystemConfig : public spm_tclStartupSystem
{
public:
spm_tclStartupSystemConfig( const ISpmFactory& factory,
                      const std::string& strConfigPath,
                      const std::string& strInstance,
                      tBool              bReadFirstRegistry );

virtual ~spm_tclStartupSystemConfig( );

virtual tBool bAlternativeProcConfig( tChar *strProcessName, tBool bValidationOnly = FALSE );
virtual tVoid vLoadSelectorRegistries( tChar *strProcessName);

virtual tU32  u32CalculateStartupRegistry(tU32 u32StartupConfig);

};

