/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_Config_project.h
  * @brief        configuration options for LCM features
  * @copyright    (C) 2012 - 2017 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

/*! ******************************************************
   used to check if this file is included prior to any other LCM header file
  */
#define _SPM_CONFIG_H

#include "spm_GlobDefs.h"

// ******************************************************
// go to shutdown when reset in shutdown phase is detected
// ******************************************************
#define SPM_ENABLE_OFF_AFTER_RESET_IN_SHUTDOWN

// ******************************************************
// show additional debug info
// ******************************************************
// #define SPM_ENABLE_ADDITIONAL_DEBUG_INFO
// ******************************************************
// unmount dynamic partion at shutdown
// ******************************************************
// #define SPM_FEATURE_ENABLE_SHUTDOWN_LX_UMOUNT

// ******************************************************
// Debouncing of single SubStates enabled
// ******************************************************
   #define SPM_FEATURE_ENABLE_SUBSTATE_DEBOUNCE

// ******************************************************
// import configuration w/o absolute pathes -> pathes must be added
// ******************************************************
   #define SPM_FEATURE_ENABLE_CONFIG_WO_ABS_PATHES

// ******************************************************
// define voltage level which blocks statemaschine
// ******************************************************
   #define SPM_U32_LOW_VOLTAGE_BLOCKING_TRIGGER SPM_U32_CRITICAL_LOW_VOLTAGE

// ******************************************************
// High Voltage Delay
// ******************************************************
   #define SPM_CVM_HIGH_VOLTAGE_DELAY       0

// ******************************************************
// Use permanent High Voltage Delay (from dev_volt) as high vlotage trigger
// ******************************************************
   #define SPM_FEATURE_ENABLE_HIGH_VOLT_PERMANENT_TRIGGER

// ******************************************************
// cyclic check time for application state transitions
// ******************************************************
   #define SPM_APPREQMON_CHECK_INTERVAL     2000

// ******************************************************
// Processes to be killed in case of DOWNLOAD mode
// ******************************************************
// #define SPM_DOWNLOAD_PROCS_2_KILL    "PROCNAVI", "PROCDAPI", "PROCSDS", "PROCSDSTS", "FC_MEDIAPLAYER"

// ******************************************************
// Define the project download state (default is SPM_SYSTEM_DOWNLOAD)
// Needed for CCA method SYSMODE
//******************************************************

// ******************************************************
// default timeout for application state transition supervision
// ******************************************************
#ifdef DEBUG
      #define SPM_APPREQMON_DEFAULT_INTERVAL   20000 // in ms
#else
      #define SPM_APPREQMON_DEFAULT_INTERVAL   13000 // in ms
#endif
   #define SPM_APPREQMON_WARNING_INTERVAL    4999    // in ms
   #define SPM_APPREQMON_STARTUP_INTERVAL   90000    // in ms

// ******************************************************
// Wakeup configuration --> check with llddeviceconfig
// ******************************************************
   #define SPM_U32_WAKEUPCONFIG_DEFAULT            ( DEV_WUP_C_U32_WAKEUP_REASONS_MASK_ON_TIPPER | DEV_WUP_C_U32_WAKEUP_REASONS_MASK_IGN_PIN | DEV_WUP_C_U32_WAKEUP_REASONS_MASK_CAN | DEV_WUP_C_U32_WAKEUP_REASONS_MASK_TEL_MUTE | DEV_WUP_C_U32_WAKEUP_REASONS_MASK_EXTERNAL_PIN_WAKEUP)
   #define SPM_U32_WAKEUPCONFIG_TRANSPORT          ( DEV_WUP_C_U32_WAKEUP_REASONS_MASK_IGN_PIN )
   #define SPM_U32_WAKEUPCONFIG_EMERGENCY          ( DEV_WUP_C_U32_WAKEUP_REASONS_MASK_IGN_PIN )

// ENABLE SPM Wakeup On/Off State - IGNITION
   #define SPM_WUP_ONOFF_STATE_IGNITION_ENABLED
  
// ENABLE SPM Wakeup On/Off State - WAKE_IN
   #define SPM_WUP_ONOFF_STATE_EXTERNAL_GPIO_ENABLED
   
// ENABLE SPM Wakeup On/Off State - CAN
	#define SPM_WUP_ONOFF_STATE_CAN_ENABLED
 
// ENABLE SPM Wakeup On/Off State - MIC1
	#define SPM_WUP_ONOFF_STATE_TELEPHONE_MUTE_ENABLED


// wakeup configuration -> one entry for each wakeup config item
   #define SPM_WUP_CONFIG \
      { \
         { ( 0 ), ( 0 ), ( 0xf0 ), ( 0x00 ) } \
      }

// CMF1 configuration with full wakeup support
// {(SPM_U8_HW_WUP_EN_TIPPER | SPM_U8_HW_WUP_EN_EJECT | SPM_U8_HW_WUP_EN_ACC | SPM_U8_HW_WUP_EN_INSERT | SPM_U8_HW_WUP_EN_ILLUM ),                    (0), (0xf0), (0x00)} \
// //
// map for bitcoded wakeup configuration -> needed to check if an incomming trigger will restart system after point of no return is reached
   #define SPM_SUBSTATE_WAKEUP_LIST \
      { \
         { ( 0 ), ( 0 ), ( 0 ) } \
      }



/*! ******************************************************
 go directly to shutdown when reset in shutdown phase is detected
**********************************************************/
// #define SPM_ENABLE_OFF_AFTER_RESET_IN_SHUTDOWN

// ******************************************************
// Startup configuration
// ******************************************************
   #define SPM_STARTUP_CONFIGURATION \
      { \
         "/dev/root/opt/bosch/base/registry/StartConfigDefaultQuadCore.reg", \
         "/dev/root/opt/bosch/base/registry/StartConfigMinTarget.reg", \
         "/dev/root/opt/bosch/base/registry/StartConfigMedia.reg" \
      }

   #define SPM_STARTUP_CONFIGURATION_MAX_NB_LAST_MODE  6
   #define SPM_STARTUP_CONFIGURATION_MAX_NB  3

   #define SPM_STARTUP_CONFIGURATION_DEFAULT           0
   #define SPM_STARTUP_CONFIGURATION_MIN_TARGET        1
   #define SPM_STARTUP_CONFIGURATION_MEDIA             2

/*! ******************************************************
which configuration is used in case of SoftwareUpdate (see LCM application mode concept)
**********************************************************/
#define SPM_STARTUP_CONFIGURATION_SWU        "/dev/root/opt/bosch/base/registry/StartConfigDefault_SWU.reg"


#define SPM_STARTUP_CONFIGURATION_OPERATION
#define SPM_STARTUP_CONFIGURATION_DIAGNOSIS_0   "/dev/root/opt/bosch/base/registry/StartConfigDiagnosis0.reg"
#define SPM_STARTUP_CONFIGURATION_DIAGNOSIS_1   "/dev/root/opt/bosch/base/registry/StartConfigDiagnosis1.reg"
/*! ******************************************************
 set numbers of parallel start-up threads
**********************************************************/
#define SPM_STARTUP_CONFIGURATION_NUM_OF_SPMS     1

/*! ******************************************************
 name of the first start-up class
**********************************************************/
#define SPM_STARTUP_CONFIGURATION_CONFIG_PATH1    "LINUX"
// #define SPM_STARTUP_CONFIGURATION_CONFIG_PATH2    "NONE"
// #define SPM_STARTUP_CONFIGURATION_CONFIG_PATH3    "NONE"

// ******************************************************
// SPM_FEATURE_ENABLE_DRV_SPM_SUBSTATE:
// Use dev_spm to communicate to OSAL
// ******************************************************
#define SPM_FEATURE_ENABLE_DRV_SPM_SUBSTATE

/*! ******************************************************
 Start processor watchdog supervision.
**********************************************************/
#define SPM_FEATURE_ENABLE_PROCESSOR_WDT

/*! ******************************************************
 how many seconds before the WDR reset should the warning message be printed
**********************************************************/
#define SPM_FEATURE_WD_PREWARN_TIME_SEC          2

/*! ******************************************************
 enable sending of CVM broadcast events
**********************************************************/
//   #define SPM_FEATURE_ENABLE_OSAL_CVM_BROADCAST

/*! ******************************************************
 Network failed time -> send if ignition TO is detected.
**********************************************************/
// #define SPM_FEATURE_ENABLE_IGNITION_TIMEOUT

// ******************************************************
// SPM_FEATURE_ENABLE_IGN_AUTOMATIC_ON:
// Set automatic mode after PowerOn (switch on via ignition)
// SPM_FEATURE_ENABLE_IGN_AUTOMATIC_OFF:
// Clear automatic mode after PowerOn (switch on via ignition)
// ******************************************************
   #define SPM_FEATURE_ENABLE_IGN_AUTOMATIC_ON
// #define SPM_FEATURE_ENABLE_IGN_AUTOMATIC_OFF

/*! ******************************************************
 All state changes will be counted for the time of\n
 SPM_U32_DEBOUNCE_STATE_CHANGE_TIME. If the count is higher then\n
 SPM_U32_DEBOUNCE_STATE_CHANGE_COUNTER. All state changes\n
 will be blocked for SPM_U32_DEBOUNCE_TIME to reduce system\n
 processor load.
**********************************************************/
#define SPM_FEATURE_ENABLE_DEBOUNCE_STATE_CHANGE

/*! ******************************************************
 time in ms the state must be stable if "fast change" was detected
**********************************************************/
#define SPM_U32_DEBOUNCE_TIME                   2000
/*! ******************************************************
 time in ms the debounce is checked (for SPM_U32_DEBOUNCE_STATE_CHANGE_COUNTER times)
**********************************************************/
#define SPM_U32_DEBOUNCE_STATE_CHANGE_TIME      8000
/*! ******************************************************
 maximum number of times the state may change (within SPM_U32_DEBOUNCE_STATE_CHANGE_TIME)\n
 before a "fast change" is detected.
**********************************************************/
#define SPM_U32_DEBOUNCE_STATE_CHANGE_COUNTER   6

/*! ******************************************************
 Disable watchdog by SPM is enabled.
**********************************************************/
#define SPM_FEATURE_RESET_AND_WATCHDOG
#define SPM_FEATURE_SHUTDOWN_WORKARROUND // how far do we go with the shutdown machine

// ******************************************************
// configuration of substate events
// ******************************************************
/*! ******************************************************
 which substate triggers are stored at shutdown
**********************************************************/
#define SPM_U32_STORE_TRIGGER_TYPES \
     SPM_U32_AUTOMATIC \
   , SPM_U32_IGNITION_LOGIC

/*! ******************************************************
 which substate triggers are restored at start-up
**********************************************************/
   #define SPM_U32_RESTORE_TRIGGER_TYPES \
      SPM_U32_AUTOMATIC \
      , SPM_U32_IGNITION_LOGIC

/*! ******************************************************
 which substate triggers are valid even in case of LowVoltage
 check also description for macro SPM_U32_LOW_VOLTAGE_BLOCKING_TRIGGER.
 These are the excptions for substate blocking when SPM_U32_LOW_VOLTAGE_BLOCKING_TRIGGER
 is active.
 SPM_U32_SYNC_SHUTDOWN_ACK will be appended directly in source code.
**********************************************************/
   #define SPM_U32_SHUTDOWN_TYPES_EN_LOW_VOLT \
      SPM_U32_IGNITION \
      , SPM_U32_ACCESSORY \
      , SPM_U32_FAST_SHUTDOWN \
      , SPM_U32_IGNITION_LOGIC \
      , SPM_U32_IGNITION_TIMEOUT \
      , SPM_U32_EMERGENCY_OFF \
      , SPM_U32_FSM_SHUTDOWN_FINISHED \
      , SPM_U32_SYNC_SHUTDOWN_ACK \
      , SPM_U32_STATE_TO

/*! ******************************************************
 which substate triggers are (or combined) used to set FAST_SHUTDOWN to active
**********************************************************/
#define SPM_U32_FASTSHUTDOWN_TYPES \
		SPM_U32_EMERGENCY_OFF \
      , SPM_U32_ENDURING_LOW_VOLTAGE \
      , SPM_U32_DIAG_FAST_SHUTDOWN \
      , SPM_U32_OVERTEMP

//todo: IVI implementation not used for inf4cv -srs6cob
// project define for initernal worker messages starting with ID 0x3000
   //#define SPM_U32_CALL_MAP_REGION_SCRIPT                    (tU32)0x00003000

	   //todo: IVI implementation not used for inf4cv -srs6cob
   //#define SPM_U32_WORKER_SSM_STATE_LCN2KAI_POWERKEEP            (tU32)( SPM_U32_SPM_WORKER_SPV_ID | 0x00000910 )
   //#define SPM_U32_WORKER_SSM_TOGGLE_MUTE                        (tU32)( SPM_U32_SPM_WORKER_SPV_ID | 0x00000911 )
   //#define SPM_U32_WORKER_SSM_BACKGROUND_IMM_OFF                 (tU32)( SPM_U32_SPM_WORKER_SPV_ID | 0x00000912 )
   //#define SPM_U32_WORKER_SSM_MEMO_DOOROPEN                      (tU32)( SPM_U32_SPM_WORKER_SPV_ID | 0x00000913 )
   //#define SPM_U32_WORKER_SSM_MEMO_ENTRY_ON                      (tU32)( SPM_U32_SPM_WORKER_SPV_ID | 0x00000914 )
   #define SPM_U32_WORKER_SSM_MULTIMEDIA_ON_REQ                  (tU32)( SPM_U32_SPM_WORKER_SPV_ID | 0x00000915 )
   #define SPM_U32_WORKER_SSM_MULTIMEDIA_NO_REQ                  (tU32)( SPM_U32_SPM_WORKER_SPV_ID | 0x00000916 )

   #define SPM_U32_WORKER_LAM_LOW_90V_END                        (tU32)( SPM_U32_SPM_WORKER_LAM_ID | 0x00000110 )

   #define SPM_U32_WORKER_CSM_SIG_IND                            (tU32)( SPM_U32_SPM_WORKER_SPV_ID | 0x00000917 )

   
// ******************************************************
// configuration of generic recovery client
// ******************************************************

/*!
   defines the number of times the recoveryclient must collect debug data before the system is reset
  */
   #define SPM_MAX_NUMBER_OF_RECOVERCLIENT_ACTIONS          3

// ******************************************************
// configuration cyclic reset handling
// ******************************************************

/*!
   defines the state of the pin when WD_OFF is active -> supervision is disabled
  */
   #define SPM_ACTIVE_STATE_WD_OFF    1

/* If LCM callstack generation is triggered in FATAL cases, wait this ammount of time before
   reset is perfomend, to give callstackgeneration and write to errmem a chance*/
   #define  SPM_ERRMEM_WRITE_DELAY_MS 3000



//todo: IVI implementation not used for inf4cv -srs6cob

// 0x00: Default (default)
// 0x01: No.1. Auto_ACC without M-CAN (Nissan CMF-B)
// 0x02: No.2. Auto_ACC with M-CAN (Nissan CMF-CD)
// 0x03: No.3. ACC with V-CAN wake-up (Nissan other vehicle)
// 0x04: No.4. V-CAN wake-up (Renault)
// 0x05: No.5. V-CAN wake-up with IGN (Renault CMF-B) ->Detail:scope2.1
// 0x06: No.6. ACC of current vehicle (Reference)
   #define SPM_U8_CONFIG_DEFAULT        (tU8)0
   //#define SPM_U8_CONFIG_NISSAN_CMFB    (tU8)1
   //#define SPM_U8_CONFIG_NISSAN_CMFCD   (tU8)2
   //#define SPM_U8_CONFIG_NISSAN_STD     (tU8)3
   //#define SPM_U8_CONFIG_RENAULT_C1A    (tU8)4
   //#define SPM_U8_CONFIG_RENAULT_T4VS   (tU8)5
   //#define SPM_U8_CONFIG_ACC_REF        (tU8)6
   //#define SPM_U8_CONFIG_NISSAN_C1A     (tU8)7
   #define SPM_U8_CONFIG_INF4CV		    (tU8)1

// ******************************************************
// configuration of failing shutdown request
// ******************************************************

/*!
   defines the number of times OSAL_C_S32_IOCTRL_WUP_SHUTDOWN is send to dev_wup before a 
   reset is requested by dev_wup.
  */
   #define SPM_SHUTDOWN_REQ_MAX_TRY_RESET                          3

/*!
   defines the number of times OSAL_C_S32_IOCTRL_WUP_SHUTDOWN is send before a FATAL_ASSERT is done.
   This is done if also the reset request could not be done by dev_wup.
  */
   #define SPM_SHUTDOWN_REQ_MAX_TRY_ASSERT                          5

// ******************************************************
// configuration of OSAL queue fill status
// ******************************************************

/*!
   defines the percentage of fill level that will create a warning message in ErrMem
  */
   #define SPM_WARNING_QUEUE_FILL_LEVEL_PERCENTAGE                  70
   #define SPM_WARNING_QUEUE_FILL_LEVEL_PERCENTAGE_WARN             70

/*!
   defines the percentage of fill level that will create a first callstack dump
  */
#define SPM_ERROR_QUEUE_FILL_LEVEL_PERCENTAGE_HIGH                    80

/*!
   defines the percentage of fill level that will create a second callstack dump
  */
#define SPM_ERROR_QUEUE_FILL_LEVEL_PERCENTAGE_CRTICICAL_HIGH          90

// ******************************************************
// configuration of systemd interface
// ******************************************************

/*!
   activates the subsciption to ALL systemd properties
   ATTENTION: This is causing roughly 10% system load
  */
   // #define SPM_FEATURE_ENABLE_SYSTEMD_SUBSCRIBE

/*!
   defines period in seconds for RAM loading supervision checking. This bases on supervision interval time.
  */
#define SPM_RAM_USAGE_CHECK_PERIOD_SECONDS                            ( 10 * SPM_HW_WATCHDOG_DEFAULT_INTERVAL /*ms*/) / 1000 /*ms*/

// ******************************************************
// configuration of systemd interface
// ******************************************************

// ******************************************************
// trigger sd_notify by project if needed
// project has to take care that the trigger has to be send in any case when startup is finished

//
//   SPM_GET_IF_REFERENCE_NEW_VAR( poclSvMngr, ISpmSupervisionManager );
//   poclSvMngr->vStartUpFinished();
//
// ******************************************************
//#define SPM_FEATURE_SD_NOTIFY_BY_PROJECT_CONFIG

// ******************************************************
// configuration of SPM_CORE_FI interface
// ******************************************************

/*! ******************************************************
   Define the allowed AppIDs to trigger StartProcess of Spm_Core_Fi interfaces\n
   ATTENTION: default is CCA_C_U16_APP_SPM_TEST_ADAPTOR used for testing\n
              and will be replaced by certain AppIDs in production
   Needed for CCA method StartProcess
**********************************************************/
#define SPM_CONFIGURED_APP_2_STARTPROCESS \
{ \
    CCA_C_U16_APP_SPM_TEST_ADAPTOR \
}

/*! ******************************************************
   Define the allowed AppIDs to trigger StopProcess of Spm_Core_Fi interfaces\n
   ATTENTION: default is CCA_C_U16_APP_SPM_TEST_ADAPTOR used for testing\n
              and will be replaced by certain AppIDs in production
   Needed for CCA method StopProcess
**********************************************************/
#define SPM_CONFIGURED_APP_2_STOPPROCESS \
{ \
    CCA_C_U16_APP_SPM_TEST_ADAPTOR \
}
/*! ******************************************************
   Define the allowed AppIDs to trigger Restart of Spm_Core_Fi interfaces\n
   ATTENTION: default is CCA_C_U16_APP_SPM_TEST_ADAPTOR used for testing\n
              and will be replaced by certain AppIDs in production
   Needed for CCA method Restart
   Leave it empty if no App configured.
**********************************************************/
#define SPM_CONFIGURED_APP_2_RESTART \
{ \
    CCA_C_U16_APP_SPM_TEST_ADAPTOR \
}
