/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SystemPowerManagerConfig.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#ifndef __SPM_SYSTEMPOWERMANAGERCONFIG_H
#define __SPM_SYSTEMPOWERMANAGERCONFIG_H

#include "spm_SystemPowerManager.h"

class ISpmFactory;

/*!
  *  \class spm_tclSystemPowerManagerConfig
  *  \brief This class handles project specific shutdown and write error memory.

          The ISpmFactory object creates an instance of this class.
  */
class spm_tclSystemPowerManagerConfig : public spm_tclSystemPowerManager
{
public:
spm_tclSystemPowerManagerConfig( const ISpmFactory& factory );
virtual ~spm_tclSystemPowerManagerConfig( );

virtual tVoid vWriteProjectSpecificShutdownInfoToErrMem( tU32 u32ShutdownOption = 0 );

virtual tVoid vShutdownSystem( tU32 u32ShutdownOption );

protected:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar *puchData );

virtual const tChar*getName( ) const { return( "spm_tclSystemPowerManagerConfig" ); }
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( ){ spm_tclSystemPowerManager::vStartCommunication( ); }

};

#endif // __SPM_SYSTEMPOWERMANAGERCONFIG_H

