/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISecurity.h
  * @brief        This is header file contains interfaces to handle security states.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_config.h must be included!
#endif

#include "spm_IWorkerClient.h"

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes

/*!
  *  \class ISpmSecurity
  *  \brief This abstract class provides interfaces to handle security states.
          It also delivers pure virtual functions to set security mode and definition and to get security lock type.

  */
class ISpmSecurity : public ISpmWorkerClient
{
public:
typedef enum tenSecurityState
{
   eSecWaiting = 0,
   eSecGreen,
   eSecYellow,
   eSecRed,
   eSecUnlocked
}tenSecurityState;

public:
ISpmSecurity( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){}
virtual ~ISpmSecurity( ){}

virtual tVoid vSecurityInfo( )                         = 0;

virtual tVoid vSetSecurityMode( tBool bEnabled ) const = 0;

virtual tVoid vSetFactoryDef( ) const                  = 0;

virtual tVoid vSecurityIdReceived( tU8 *pu8Data,
                                   tU8  u8Len )        = 0;

virtual tenSecurityState tGetSecLockType( ) const      = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmSecurity" ); }
};

