/*!
  * \file spm_OsalProxy_G2Config.cpp
  *  \brief
  *    The project specific part of the abstraction layer of the platform.
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author             | Modification
  * 28.09.11  | TMS Fischer        | initial version
  ******
  */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "spm_Config.h"
#include "spm_OsalProxyConfig.h"
#include "spm_IFactory.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_OsalProxyConfig.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/
// #define SPM_TRACE_FILE_ID   SPM_FILE_OSALPROXY_G2CONFIG

spm_tclOsalProxyConfig::spm_tclOsalProxyConfig( const ISpmFactory& factory,
                                                tU32                  u32AppId ) : spm_tclOsalProxy( factory, u32AppId ){
}

spm_tclOsalProxyConfig::~spm_tclOsalProxyConfig( ){
}

tVoid spm_tclOsalProxyConfig::vStartCommunication( ){
   spm_tclOsalProxy::vStartCommunication( );
}

tVoid spm_tclOsalProxyConfig::vGetReferences( ){
   spm_tclOsalProxy::vGetReferences( );
}

