/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CcaSupplierHandlerConfig.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#ifndef __SPM_CCASUPPLIERHANDLERCONFIG_H
#define __SPM_CCASUPPLIERHANDLERCONFIG_H

#ifndef _SPM_CONFIG_H
#error spm_config.h must be included!
#endif

#include "spm_CcaSupplierHandler.h"

// //////////////////////////////////////////////////////////////////////////////
// project specific configuration class for spm_tclCcaSupplierHandler
//

/*!
  *  \class spm_tclCcaSupplierHandlerConfig
  *  \brief Configuration class  for cca supplier handling.
          The ISpmFactory object creates an instance of this class.
  */
class spm_tclCcaSupplierHandlerConfig : public spm_tclCcaSupplierHandler
{
public:
spm_tclCcaSupplierHandlerConfig( const ISpmFactory& factory );
virtual ~spm_tclCcaSupplierHandlerConfig( );

protected:
// ISpmBase / ISpmWorkerClient interface functions
virtual const tChar*getName( ) const { return( "spm_tclCcaSupplierHandlerConfig" ); }
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

};

#endif // __SPM_CCASUPPLIERHANDLERCONFIG_H

