/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISystemInfoClient.h
  * @brief        This is header file contains interfaces to handle ignition cycle event and system power mode event.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_config.h must be included!
#endif

// //////////////////////////////////////////////////////////////////////////////
// Interface to exchange substate events

/*!
  *  \class ISpmSystemInfoClient
  *  \brief This abstract class provides interfaces to handle ignition cycle event and system power mode event.
  */
class ISpmSystemInfoClient
{
public:
virtual ~ISpmSystemInfoClient( ){ }
virtual tVoid vHandleIgnitionCycleEvent( tU32 u32IgnitionCycleEvent ) = 0;

virtual tVoid vHandleSysPwrModeEvent( tU32 u32SysPwrModeEvent )       = 0;

virtual tVoid vHandleTriggerMostRemoteReset( )                        = 0;

};

