/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CcaServiceHandlerFiParamConfig.h
  * @brief        Automated generation of method and property variables from
  *               System Power Management Service, Application Functional Interface
  *               Version : $Revision:   1.12  $
  *               Author  : Klaus-Peter Kollai
  *               Title   : SPM_CORE_FI
  *               Date    : $Date:  05.04.2017  $
  * @copyright    (C) 2017 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

///////////////////////////////////////////////////////////////////////////////
// properties need to be overloaded, if set function is available
///////////////////////////////////////////////////////////////////////////////


// property variables
spm_Property < spm_corefi_tclMsgDownloadLockStatesStatus >         _downloadLockStates;
spm_Property < spm_corefi_tclMsgActiveOnOffTriggerStatus >         _activeOnOffTrigger;
spm_Property < spm_corefi_tclMsgHistoryTriggerStatus >             _historyTrigger;
spm_Property < spm_corefi_tclMsgInsertStateStatus >                _insertState;
spm_Property < spm_corefi_tclMsgMediaEjectStateStatus >            _mediaEjectState;
spm_Property < spm_corefi_tclMsgIgnitionCyclesStatus >             _ignitionCycles;
spm_Property < spm_corefi_tclMsgSysPwrModeStatus >                 _sysPwrMode;
spm_Property < spm_corefi_tclMsgSysPwrSaveModeStatus >             _sysPwrSaveMode;
spm_Property < spm_corefi_tclMsgActiveStartUpSyncPointsStatus >    _activeStartUpSyncPoints;
spm_Property < spm_corefi_tclMsgCoproStateStatus >                 _coproState;
spm_Property < spm_corefi_tclMsgLifesignStatus >                   _lifesign;
spm_Property < spm_corefi_tclMsgSystemPowerBehaviourStatus >       _systemPowerBehaviour;
spm_Property < spm_corefi_tclMsgWifiStateStatus >                  _wifiState;
spm_Property < spm_corefi_tclMsgStartupFinishedStatus >            _startupFinished;
spm_Property < spm_corefi_tclMsgSysStateStatus >                   _sysState;
spm_Property < spm_corefi_tclMsgMostStateStatus >                  _mostState;
spm_Property < spm_corefi_tclMsgMostVersionStatus >                _mostVersion;
spm_PropertyRVCState                                               _rVCState;
spm_Property < spm_corefi_tclMsgTriggerMostRemoteResetStatus >     _triggerMostRemoteReset;
spm_Property < spm_corefi_tclMsgPartnumberStatus >                 _partnumber;
spm_Property < spm_corefi_tclMsgPartnumbersStatus >                _partnumbers;
spm_Property < spm_corefi_tclMsgAlphacodeStatus >                  _alphacode;
spm_Property < spm_corefi_tclMsgAlphacodesStatus >                 _alphacodes;
spm_Property < spm_corefi_tclMsgManufacturersEnableCounterStatus > _manufacturersEnableCounter;
spm_Property < spm_corefi_tclMsgNoCalibrationStateStatus >         _noCalibrationState;
spm_Property < spm_corefi_tclMsgSecurityCommErrorStatus >          _securityCommError;
spm_Property < spm_corefi_tclMsgSecurityMoreThan10VinStatus >      _securityMoreThan10Vin;
spm_Property < spm_corefi_tclMsgSecurityInvalidVinStatus >         _securityInvalidVin;
spm_Property < spm_corefi_tclMsgSecurityCurrentVinStatus >         _securityCurrentVin;
spm_Property < spm_corefi_tclMsgSecurityVinHistoryStatus >         _securityVinHistory;
spm_Property < spm_corefi_tclMsgVINStatus >                        _vIN;
spm_Property < spm_corefi_tclMsgSecurityStateStatus >              _securityState;
spm_Property < spm_corefi_tclMsgDisplayVariantStatus >             _displayVariant;
spm_Property < spm_corefi_tclMsgReductionLevelStatus >             _reductionLevel;
spm_Property < spm_corefi_tclMsgStartupStateStatus >               _startupState;
spm_Property < spm_corefi_tclMsgEntertainMuteStatus >              _entertainMute;
spm_Property < spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus > _unballastTimeFromEngineStopped;
spm_Property < spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus > _unballastTimeBeforeUnballast;
spm_Property < spm_corefi_tclMsgUnballastWarningTimeStatus >       _unballastWarningTime;
spm_Property < spm_corefi_tclMsgDegradedCountStatus >              _degradedCount;
spm_Property < spm_corefi_tclMsgDegradedTimeStatus >               _degradedTime;
spm_PropertyPhoneHandoverWarnTime                                  _phoneHandoverWarnTime;

// method variables
spm_MethodChangeBluetoothState                                     _changeBluetoothState;
spm_MethodChangeAudioState                                         _changeAudioState;
spm_MethodChangeSpiState                                           _changeSpiState;
spm_MethodChangeTunerState                                         _changeTunerState;
spm_MethodChangeWifiState                                          _changeWifiState;
spm_MethodSetFactorySettingsNew                                    _setFactorySettingsNew;
spm_MethodClearVIN                                                 _clearVIN;
spm_MethodPrepareDownload                                          _prepareDownload;
spm_MethodEndDownload                                              _endDownload;
spm_MethodSetOnConfiguration                                       _setOnConfiguration;
spm_MethodSetProcessConfiguration                                  _setProcessConfiguration;
spm_MethodEntertainDeMute                                          _entertainDeMute;
spm_MethodEntertainMuteRequest                                     _entertainMuteRequest;

