/*****************************************************************************
 * @file:        spm_CcaServiceHandlerFiParamConfig.cpp
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * @brief:  Automated generation of method and property variables from
 *          System Power Management Service, Application Functional Interface
 *          Version : $Revision:   1.12  $
 *          Author  : Klaus-Peter Kollai
 *          Title   : SPM_CORE_FI
 *          Date    : $Date:  05.04.2017  $
 *
 * ----------------------------------------------------------------------------
 * @copyright   (C) 2017 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

// FI-zone starts
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

//-----------------------------------------------------------------------------
// includes FC SPM
//-----------------------------------------------------------------------------

#include "spm_Config.h"
#include "spm_trace.h"
#include "spm_OsalProxyConfig.h"
#include "spm_CcaServiceHandlerConfig.h"


enum
{
   GEN_P_DOWNLOADLOCKSTATES,
   GEN_P_ACTIVEONOFFTRIGGER,
   GEN_P_HISTORYTRIGGER,
   GEN_P_INSERTSTATE,
   GEN_P_MEDIAEJECTSTATE,
   GEN_P_IGNITIONCYCLES,
   GEN_P_SYSPWRMODE,
   GEN_P_SYSPWRSAVEMODE,
   GEN_P_ACTIVESTARTUPSYNCPOINTS,
   GEN_P_COPROSTATE,
   GEN_P_LIFESIGN,
   GEN_P_SYSTEMPOWERBEHAVIOUR,
   GEN_P_WIFISTATE,
   GEN_P_STARTUPFINISHED,
   GEN_P_SYSSTATE,
   GEN_P_MOSTSTATE,
   GEN_P_MOSTVERSION,
   GEN_P_RVCSTATE,
   GEN_P_TRIGGERMOSTREMOTERESET,
   GEN_P_PARTNUMBER,
   GEN_P_PARTNUMBERS,
   GEN_P_ALPHACODE,
   GEN_P_ALPHACODES,
   GEN_P_MANUFACTURERSENABLECOUNTER,
   GEN_P_NOCALIBRATIONSTATE,
   GEN_P_SECURITYCOMMERROR,
   GEN_P_SECURITYMORETHAN10VIN,
   GEN_P_SECURITYINVALIDVIN,
   GEN_P_SECURITYCURRENTVIN,
   GEN_P_SECURITYVINHISTORY,
   GEN_P_VIN,
   GEN_P_SECURITYSTATE,
   GEN_P_DISPLAYVARIANT,
   GEN_P_REDUCTIONLEVEL,
   GEN_P_STARTUPSTATE,
   GEN_P_ENTERTAINMUTE,
   GEN_P_UNBALLASTTIMEFROMENGINESTOPPED,
   GEN_P_UNBALLASTTIMEBEFOREUNBALLAST,
   GEN_P_UNBALLASTWARNINGTIME,
   GEN_P_DEGRADEDCOUNT,
   GEN_P_DEGRADEDTIME,
   GEN_P_PHONEHANDOVERWARNTIME
};

enum
{
   GEN_M_CHANGEBLUETOOTHSTATE,
   GEN_M_CHANGEAUDIOSTATE,
   GEN_M_CHANGESPISTATE,
   GEN_M_CHANGETUNERSTATE,
   GEN_M_CHANGEWIFISTATE,
   GEN_M_SETFACTORYSETTINGSNEW,
   GEN_M_CLEARVIN,
   GEN_M_PREPAREDOWNLOAD,
   GEN_M_ENDDOWNLOAD,
   GEN_M_SETONCONFIGURATION,
   GEN_M_SETPROCESSCONFIGURATION,
   GEN_M_ENTERTAINDEMUTE,
   GEN_M_ENTERTAINMUTEREQUEST
};


spm_AdminProperty arPropertiesConfig[] =
{
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "DownloadLockStates"     }, // DOWNLOADLOCKSTATES
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "ActiveOnOffTrigger"     }, // ACTIVEONOFFTRIGGER
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "HistoryTrigger"         }, // HISTORYTRIGGER
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "InsertState"            }, // INSERTSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "MediaEjectState"        }, // MEDIAEJECTSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "IgnitionCycles"         }, // IGNITIONCYCLES
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "SysPwrMode"             }, // SYSPWRMODE
   { NULL, SPM_PROP_ADMIN_GET,           "SysPwrSaveMode"         }, // SYSPWRSAVEMODE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "ActiveStartUpSyncPoints" }, // ACTIVESTARTUPSYNCPOINTS
   { NULL, SPM_PROP_ADMIN_GET_SET_UPREG, "CoproState"             }, // COPROSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "Lifesign"               }, // LIFESIGN
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "SystemPowerBehaviour"   }, // SYSTEMPOWERBEHAVIOUR
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "WifiState"              }, // WIFISTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "StartupFinished"        }, // STARTUPFINISHED
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "SysState"               }, // SYSSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "MostState"              }, // MOSTSTATE
   { NULL, SPM_PROP_ADMIN_GET,           "MostVersion"            }, // MOSTVERSION
   { NULL, SPM_PROP_ADMIN_GET_SET,       "RVCState"               }, // RVCSTATE
   { NULL, SPM_PROP_ADMIN_GET_SET_UPREG, "TriggerMostRemoteReset" }, // TRIGGERMOSTREMOTERESET
   { NULL, SPM_PROP_ADMIN_GET_SET,       "Partnumber"             }, // PARTNUMBER
   { NULL, SPM_PROP_ADMIN_GET,           "Partnumbers"            }, // PARTNUMBERS
   { NULL, SPM_PROP_ADMIN_GET_SET,       "Alphacode"              }, // ALPHACODE
   { NULL, SPM_PROP_ADMIN_GET,           "Alphacodes"             }, // ALPHACODES
   { NULL, SPM_PROP_ADMIN_GET_SET,       "ManufacturersEnableCounter" }, // MANUFACTURERSENABLECOUNTER
   { NULL, SPM_PROP_ADMIN_GET_SET,       "NoCalibrationState"     }, // NOCALIBRATIONSTATE
   { NULL, SPM_PROP_ADMIN_GET,           "SecurityCommError"      }, // SECURITYCOMMERROR
   { NULL, SPM_PROP_ADMIN_GET,           "SecurityMoreThan10Vin"  }, // SECURITYMORETHAN10VIN
   { NULL, SPM_PROP_ADMIN_GET,           "SecurityInvalidVin"     }, // SECURITYINVALIDVIN
   { NULL, SPM_PROP_ADMIN_GET,           "SecurityCurrentVin"     }, // SECURITYCURRENTVIN
   { NULL, SPM_PROP_ADMIN_GET,           "SecurityVinHistory"     }, // SECURITYVINHISTORY
   { NULL, SPM_PROP_ADMIN_GET,           "VIN"                    }, // VIN
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "SecurityState"          }, // SECURITYSTATE
   { NULL, SPM_PROP_ADMIN_GET_SET,       "DisplayVariant"         }, // DISPLAYVARIANT
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "ReductionLevel"         }, // REDUCTIONLEVEL
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "StartupState"           }, // STARTUPSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "EntertainMute"          }, // ENTERTAINMUTE
   { NULL, SPM_PROP_ADMIN_GET,           "UnballastTimeFromEngineStopped" }, // UNBALLASTTIMEFROMENGINESTOPPED
   { NULL, SPM_PROP_ADMIN_GET_SET,       "UnballastTimeBeforeUnballast" }, // UNBALLASTTIMEBEFOREUNBALLAST
   { NULL, SPM_PROP_ADMIN_GET_SET,       "UnballastWarningTime"   }, // UNBALLASTWARNINGTIME
   { NULL, SPM_PROP_ADMIN_GET,           "DegradedCount"          }, // DEGRADEDCOUNT
   { NULL, SPM_PROP_ADMIN_GET,           "DegradedTime"           }, // DEGRADEDTIME
   { NULL, SPM_PROP_ADMIN_GET_SET_UPREG, "PhoneHandoverWarnTime"  } // PHONEHANDOVERWARNTIME
};

spm_AdminMethod   arMethodsConfig[] =
{
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "ChangeBluetoothState" }, // CHANGEBLUETOOTHSTATE
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "ChangeAudioState" }, // CHANGEAUDIOSTATE
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "ChangeSpiState" }, // CHANGESPISTATE
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "ChangeTunerState" }, // CHANGETUNERSTATE
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "ChangeWifiState" }, // CHANGEWIFISTATE
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "SetFactorySettingsNew" }, // SETFACTORYSETTINGSNEW
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "ClearVIN" }, // CLEARVIN
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "PrepareDownload" }, // PREPAREDOWNLOAD
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "EndDownload" }, // ENDDOWNLOAD
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "SetOnConfiguration" }, // SETONCONFIGURATION
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "SetProcessConfiguration" }, // SETPROCESSCONFIGURATION
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "EntertainDeMute" }, // ENTERTAINDEMUTE
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "EntertainMuteRequest" } // ENTERTAINMUTEREQUEST
};

#define ADD_GEN_PROPERTY(a, b) \
   arPropertiesConfig[GEN_P_ ## a]._pProperty = &b; \
   _oSpmProperties.vAddProperty(SPM_COREFI_C_U16_ ## a, &arPropertiesConfig[GEN_P_ ## a])

#define ADD_GEN_METHOD(a, b) \
   arMethodsConfig[GEN_M_ ## a]._pMethod      = &b; \
   _oSpmMethods.vAddMethod(SPM_COREFI_C_U16_ ## a, &arMethodsConfig[GEN_M_ ## a])


tVoid spm_tclCcaServiceHandlerConfig::vInitPropertiesConfig(){
   ADD_GEN_PROPERTY(DOWNLOADLOCKSTATES,     _downloadLockStates);
   ADD_GEN_PROPERTY(ACTIVEONOFFTRIGGER,     _activeOnOffTrigger);
   ADD_GEN_PROPERTY(HISTORYTRIGGER,         _historyTrigger);
   ADD_GEN_PROPERTY(INSERTSTATE,            _insertState);
   ADD_GEN_PROPERTY(MEDIAEJECTSTATE,        _mediaEjectState);
   ADD_GEN_PROPERTY(IGNITIONCYCLES,         _ignitionCycles);
   ADD_GEN_PROPERTY(SYSPWRMODE,             _sysPwrMode);
   ADD_GEN_PROPERTY(SYSPWRSAVEMODE,         _sysPwrSaveMode);
   ADD_GEN_PROPERTY(ACTIVESTARTUPSYNCPOINTS, _activeStartUpSyncPoints);
   ADD_GEN_PROPERTY(COPROSTATE,             _coproState);
   ADD_GEN_PROPERTY(LIFESIGN,               _lifesign);
   ADD_GEN_PROPERTY(SYSTEMPOWERBEHAVIOUR,   _systemPowerBehaviour);
   ADD_GEN_PROPERTY(WIFISTATE,              _wifiState);
   ADD_GEN_PROPERTY(STARTUPFINISHED,        _startupFinished);
   ADD_GEN_PROPERTY(SYSSTATE,               _sysState);
   ADD_GEN_PROPERTY(MOSTSTATE,              _mostState);
   ADD_GEN_PROPERTY(MOSTVERSION,            _mostVersion);
   ADD_GEN_PROPERTY(RVCSTATE,               _rVCState);
   ADD_GEN_PROPERTY(TRIGGERMOSTREMOTERESET, _triggerMostRemoteReset);
   ADD_GEN_PROPERTY(PARTNUMBER,             _partnumber);
   ADD_GEN_PROPERTY(PARTNUMBERS,            _partnumbers);
   ADD_GEN_PROPERTY(ALPHACODE,              _alphacode);
   ADD_GEN_PROPERTY(ALPHACODES,             _alphacodes);
   ADD_GEN_PROPERTY(MANUFACTURERSENABLECOUNTER, _manufacturersEnableCounter);
   ADD_GEN_PROPERTY(NOCALIBRATIONSTATE,     _noCalibrationState);
   ADD_GEN_PROPERTY(SECURITYCOMMERROR,      _securityCommError);
   ADD_GEN_PROPERTY(SECURITYMORETHAN10VIN,  _securityMoreThan10Vin);
   ADD_GEN_PROPERTY(SECURITYINVALIDVIN,     _securityInvalidVin);
   ADD_GEN_PROPERTY(SECURITYCURRENTVIN,     _securityCurrentVin);
   ADD_GEN_PROPERTY(SECURITYVINHISTORY,     _securityVinHistory);
   ADD_GEN_PROPERTY(VIN,                    _vIN);
   ADD_GEN_PROPERTY(SECURITYSTATE,          _securityState);
   ADD_GEN_PROPERTY(DISPLAYVARIANT,         _displayVariant);
   ADD_GEN_PROPERTY(REDUCTIONLEVEL,         _reductionLevel);
   ADD_GEN_PROPERTY(STARTUPSTATE,           _startupState);
   ADD_GEN_PROPERTY(ENTERTAINMUTE,          _entertainMute);
   ADD_GEN_PROPERTY(UNBALLASTTIMEFROMENGINESTOPPED, _unballastTimeFromEngineStopped);
   ADD_GEN_PROPERTY(UNBALLASTTIMEBEFOREUNBALLAST, _unballastTimeBeforeUnballast);
   ADD_GEN_PROPERTY(UNBALLASTWARNINGTIME,   _unballastWarningTime);
   ADD_GEN_PROPERTY(DEGRADEDCOUNT,          _degradedCount);
   ADD_GEN_PROPERTY(DEGRADEDTIME,           _degradedTime);
   ADD_GEN_PROPERTY(PHONEHANDOVERWARNTIME,  _phoneHandoverWarnTime);

   // set the default values of the properties
   // vInitProperties: user specific code start

   // vInitProperties: user specific code end
} // vInitPropertiesConfig

tVoid spm_tclCcaServiceHandlerConfig::vInitMethodsConfig(){
   ADD_GEN_METHOD(CHANGEBLUETOOTHSTATE, _changeBluetoothState);
   ADD_GEN_METHOD(CHANGEAUDIOSTATE,    _changeAudioState);
   ADD_GEN_METHOD(CHANGESPISTATE,      _changeSpiState);
   ADD_GEN_METHOD(CHANGETUNERSTATE,    _changeTunerState);
   ADD_GEN_METHOD(CHANGEWIFISTATE,     _changeWifiState);
   ADD_GEN_METHOD(SETFACTORYSETTINGSNEW, _setFactorySettingsNew);
   ADD_GEN_METHOD(CLEARVIN,            _clearVIN);
   ADD_GEN_METHOD(PREPAREDOWNLOAD,     _prepareDownload);
   ADD_GEN_METHOD(ENDDOWNLOAD,         _endDownload);
   ADD_GEN_METHOD(SETONCONFIGURATION,  _setOnConfiguration);
   ADD_GEN_METHOD(SETPROCESSCONFIGURATION, _setProcessConfiguration);
   ADD_GEN_METHOD(ENTERTAINDEMUTE,     _entertainDeMute);
   ADD_GEN_METHOD(ENTERTAINMUTEREQUEST, _entertainMuteRequest);
}

