/*****************************************************************************
 * @file:        spm_CcaServiceHandlerAccessOverload.cpp
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * @brief:  Automated generation of method and property variables from
 *          System Power Management Service, Application Functional Interface
 *          Version : $Revision:   1.15  $
 *          Author  : Klaus-Peter Kollai
 *          Title   : SPM_CORE_FI
 *          Date    : $Date:  08.08.2018  $
 *
 * ----------------------------------------------------------------------------
 * @copyright   (C) 2017-2018 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

// FI-zone starts
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

//-----------------------------------------------------------------------------
// includes FC SPM
//-----------------------------------------------------------------------------

#include "spm_Config.h"
#include "spm_CcaServiceHandlerAccess.h"

// Spm trace specific code can be put here
// spm_tclCcaServiceHandlerAccess_include_spm: user specific code start
// spm_tclCcaServiceHandlerAccess_include_spm: user specific code end

///////////////////////////////////////////////////////////////////////////////
// properties need to be overloaded, if set function is available
///////////////////////////////////////////////////////////////////////////////


tU8 spm_PropertyOnOffReason::u8SetOperationPrj(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage            oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgOnOffReasonSet oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) ){
      // u8SetOperation 'OnOffReason': user specific code start

      // u8SetOperation 'OnOffReason': user specific code end
   }
   return( IPROPERTY_RETURN_UNKNOWN );
}

