/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CcaServiceHandlerAccessConfig.h
  * @brief        Automated generation of method and property variables from
  *               System Power Management Service, Application Functional Interface
  *               Version : $Revision:   1.12  $
  *               Author  : Klaus-Peter Kollai
  *               Title   : SPM_CORE_FI
  *               Date    : $Date:  05.04.2017  $
  * @copyright    (C) 2017 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include "spm_CcaMethods.h"    // "spm_CcaProperties.h" is already included in "spm_CcaMethods.h"

///////////////////////////////////////////////////////////////////////////////
// properties need to be overloaded, if set function is available
///////////////////////////////////////////////////////////////////////////////


class spm_PropertyRVCState : public spm_Property < spm_corefi_tclMsgRVCStateStatus >
{
public:
virtual const spm_PropertyRVCState& operator=(const spm_corefi_tclMsgRVCStateStatus& op);

private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};
class spm_PropertyPhoneHandoverWarnTime : public spm_Property < spm_corefi_tclMsgPhoneHandoverWarnTimeStatus >
{
private:
virtual tU8 u8SetOperation(amt_tclServiceData *poSrvData);

virtual tVoid vGetOperation(amt_tclServiceData *poSrvData);

};

///////////////////////////////////////////////////////////////////////////////
// start project depending methods
///////////////////////////////////////////////////////////////////////////////



































class spm_MethodChangeBluetoothState : public spm_Method <spm_corefi_tclMsgChangeBluetoothStateMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodChangeAudioState : public spm_Method <spm_corefi_tclMsgChangeAudioStateMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodChangeSpiState : public spm_Method <spm_corefi_tclMsgChangeSpiStateMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodChangeTunerState : public spm_Method <spm_corefi_tclMsgChangeTunerStateMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodChangeWifiState : public spm_Method <spm_corefi_tclMsgChangeWifiStateMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};






class spm_MethodSetFactorySettingsNew : public spm_Method <spm_corefi_tclMsgSetFactorySettingsNewMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodClearVIN : public spm_Method <spm_corefi_tclMsgClearVINMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodPrepareDownload : public spm_Method <spm_corefi_tclMsgPrepareDownloadMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodEndDownload : public spm_Method <spm_corefi_tclMsgEndDownloadMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodSetOnConfiguration : public spm_Method <spm_corefi_tclMsgSetOnConfigurationMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodSetProcessConfiguration : public spm_Method <spm_corefi_tclMsgSetProcessConfigurationMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodEntertainDeMute : public spm_Method <spm_corefi_tclMsgEntertainDeMuteMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};



class spm_MethodEntertainMuteRequest : public spm_Method <spm_corefi_tclMsgEntertainMuteRequestMethodResult>
{
private:
// implementation of interface IMethod
virtual tU32 u32MethodStart(amt_tclServiceData *poSrvData);

};

