/*****************************************************************************
 * @file:        spm_CcaServiceHandlerAccessConfig.cpp
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * @brief:  Automated generation of method and property variables from
 *          System Power Management Service, Application Functional Interface
 *          Version : $Revision:   1.12  $
 *          Author  : Klaus-Peter Kollai
 *          Title   : SPM_CORE_FI
 *          Date    : $Date:  05.04.2017  $
 *
 * ----------------------------------------------------------------------------
 * @copyright   (C) 2017 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

// FI-zone starts
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

//-----------------------------------------------------------------------------
// includes FC SPM
//-----------------------------------------------------------------------------

#include "spm_Config.h"
#include "spm_CcaServiceHandlerAccessConfig.h"

// Spm trace specific code can be put here
// spm_tclCcaServiceHandlerAccessConfig_include_spm: user specific code start
#include "spm_ILamAppManager.h"
#include "spm_ICcaServiceServer.h"
#include "spm_IFactory.h"
// spm_tclCcaServiceHandlerAccessConfig_include_spm: user specific code end

///////////////////////////////////////////////////////////////////////////////
// properties need to be overloaded, if set function is available
///////////////////////////////////////////////////////////////////////////////

const spm_PropertyRVCState& spm_PropertyRVCState::operator=(const spm_corefi_tclMsgRVCStateStatus& op){
   _property = op;
   return( * this );
}

tU8 spm_PropertyRVCState::u8SetOperation(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgRVCStateSet oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) ){
      // u8SetOperation 'RVCState': user specific code start

      // u8SetOperation 'RVCState': user specific code end
   }
   return( IPROPERTY_RETURN_FAILED );
}

tVoid spm_PropertyRVCState::vGetOperation(amt_tclServiceData *poSrvData){
   (tVoid)poSrvData;
   // vGetOperation 'RVCState': user specific code start

   // vGetOperation 'RVCState': user specific code end
}

tU8 spm_PropertyPhoneHandoverWarnTime::u8SetOperation(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgPhoneHandoverWarnTimeSet oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) ){
      // u8SetOperation 'PhoneHandoverWarnTime': user specific code start

      // u8SetOperation 'PhoneHandoverWarnTime': user specific code end
   }
   return( IPROPERTY_RETURN_FAILED );
}

tVoid spm_PropertyPhoneHandoverWarnTime::vGetOperation(amt_tclServiceData *poSrvData){
   (tVoid)poSrvData;
   // vGetOperation 'PhoneHandoverWarnTime': user specific code start

   // vGetOperation 'PhoneHandoverWarnTime': user specific code end
}























// implementation of interface IMethod
tU32 spm_MethodChangeBluetoothState::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgChangeBluetoothStateMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'ChangeBluetoothState': user specific code start
	   //todo: IVI implementation not used for inf4cv -srs6cob
       //tU8 u8PowerPlatform = 0;
       //dp_tclSpmDpRnAiviCurrentPowerPlatform oCurPowerPlatform;
       //oCurPowerPlatform >> u8PowerPlatform;

       //if (   (u8PowerPlatform == SPM_U8_CONFIG_RENAULT_C1A)
       //        || (u8PowerPlatform == SPM_U8_CONFIG_RENAULT_T4VS)
       //) {

       //    ISpmLamAppManager* poclLamAppManager           = dynamic_cast<ISpmLamAppManager*>(ISpmFactory::_poFactoryRef->getSpmObjHandler("ISpmLamAppManager"));
       //    SPM_NULL_POINTER_CHECK_VAL(poclLamAppManager);
       //    if (oResultData.BtState.enType == spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL) {
       //        //poclLamAppManager->vUpdateMultimediaTrigger(ISpmLamAppManager::eMultimediaTriggerBtOn);
       //    } else {
       //       // poclLamAppManager->vUpdateMultimediaTrigger(ISpmLamAppManager::eMultimediaTriggerBtOff);
       //    }

       //} else {
       //    ISpmCcaServiceServer* poclCcaServiceHandler    = dynamic_cast<ISpmCcaServiceServer*>(ISpmFactory::_poFactoryRef->getSpmObjHandler("spm_tclCcaServiceHandlerConfig"));
       //    SPM_NULL_POINTER_CHECK_VAL(poclCcaServiceHandler);

       //    spm_corefi_tclMsgBluetoothStateStatus        tBtState;
       //    tBtState.BtState = oResultData.BtState;
       //    poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_BLUETOOTHSTATE, &tBtState);
       //}

       return( IMETHOD_RETURN_SUCCESS );

      // vMethodStart 'ChangeBluetoothState': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodChangeAudioState::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgChangeAudioStateMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'ChangeAudioState': user specific code start
       ISpmCcaServiceServer* poclCcaServiceHandler    = dynamic_cast<ISpmCcaServiceServer*>(ISpmFactory::_poFactoryRef->getSpmObjHandler("spm_tclCcaServiceHandlerConfig"));
       SPM_NULL_POINTER_CHECK_VAL(poclCcaServiceHandler);

       spm_corefi_tclMsgAudioStateStatus        tAudioState;

       tAudioState.AudioState.enType = oResultData.AudioState.enType;
       poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_AUDIOSTATE, &tAudioState);

       return( IMETHOD_RETURN_SUCCESS );

      // vMethodStart 'ChangeAudioState': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodChangeSpiState::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgChangeSpiStateMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'ChangeSpiState': user specific code start

      // vMethodStart 'ChangeSpiState': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodChangeTunerState::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgChangeTunerStateMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'ChangeTunerState': user specific code start

      // vMethodStart 'ChangeTunerState': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodChangeWifiState::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgChangeWifiStateMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'ChangeWifiState': user specific code start
	   //todo: IVI implementation not used for inf4cv -srs6cob
       //tU8 u8PowerPlatform = 0;
       //dp_tclSpmDpRnAiviCurrentPowerPlatform oCurPowerPlatform;
       //oCurPowerPlatform >> u8PowerPlatform;

       //if (   (u8PowerPlatform == SPM_U8_CONFIG_RENAULT_C1A)
       //        || (u8PowerPlatform == SPM_U8_CONFIG_RENAULT_T4VS)
       //) {

       //    ISpmLamAppManager* poclLamAppManager           = dynamic_cast<ISpmLamAppManager*>(ISpmFactory::_poFactoryRef->getSpmObjHandler("ISpmLamAppManager"));
       //    SPM_NULL_POINTER_CHECK_VAL(poclLamAppManager);
       //    if (oResultData.WiFiState.enType == spm_fi_tcl_SPM_e32_WIFI_STATE::FI_EN_WIFISTATE_NORMAL) {
       //        //poclLamAppManager->vUpdateMultimediaTrigger(ISpmLamAppManager::eMultimediaTriggerWifiOn);
       //    } else {
       //        //poclLamAppManager->vUpdateMultimediaTrigger(ISpmLamAppManager::eMultimediaTriggerWifiOff);
       //    }

       //} else {

       //    ISpmCcaServiceServer* poclCcaServiceHandler    = dynamic_cast<ISpmCcaServiceServer*>(ISpmFactory::_poFactoryRef->getSpmObjHandler("spm_tclCcaServiceHandlerConfig"));
       //    SPM_NULL_POINTER_CHECK_VAL(poclCcaServiceHandler);

       //    spm_corefi_tclMsgWifiStateStatus        tWiFiState;
       //    tWiFiState.WiFiState = oResultData.WiFiState;
       //    poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_WIFISTATE, &tWiFiState);
       //}
       return( IMETHOD_RETURN_SUCCESS );

      // vMethodStart 'ChangeWifiState': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}




// implementation of interface IMethod
tU32 spm_MethodSetFactorySettingsNew::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgSetFactorySettingsNewMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'SetFactorySettingsNew': user specific code start

      // vMethodStart 'SetFactorySettingsNew': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodClearVIN::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgClearVINMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'ClearVIN': user specific code start

      // vMethodStart 'ClearVIN': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodPrepareDownload::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgPrepareDownloadMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'PrepareDownload': user specific code start

      // vMethodStart 'PrepareDownload': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodEndDownload::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgEndDownloadMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'EndDownload': user specific code start

      // vMethodStart 'EndDownload': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodSetOnConfiguration::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgSetOnConfigurationMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'SetOnConfiguration': user specific code start

      // vMethodStart 'SetOnConfiguration': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodSetProcessConfiguration::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgSetProcessConfigurationMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'SetProcessConfiguration': user specific code start

      // vMethodStart 'SetProcessConfiguration': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodEntertainDeMute::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgEntertainDeMuteMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'EntertainDeMute': user specific code start
	   //todo: IVI implementation not used for inf4cv -srs6cob
       //tU8 u8PowerPlatform = 0;
       //dp_tclSpmDpRnAiviCurrentPowerPlatform oCurPowerPlatform;
       //oCurPowerPlatform >> u8PowerPlatform;

       //if (   (u8PowerPlatform == SPM_U8_CONFIG_RENAULT_C1A)
       //        || (u8PowerPlatform == SPM_U8_CONFIG_RENAULT_T4VS)
       //) {

       //    ISpmLamAppManager* poclLamAppManager           = dynamic_cast<ISpmLamAppManager*>(ISpmFactory::_poFactoryRef->getSpmObjHandler("ISpmLamAppManager"));
       //    SPM_NULL_POINTER_CHECK_VAL(poclLamAppManager);
       //    //poclLamAppManager->vUpdateMultimediaTrigger(ISpmLamAppManager::eMultimediaTriggerAudioOn);

       //} else {
       //    ISpmCcaServiceServer* poclCcaServiceHandler    = dynamic_cast<ISpmCcaServiceServer*>(ISpmFactory::_poFactoryRef->getSpmObjHandler("spm_tclCcaServiceHandlerConfig"));
       //    SPM_NULL_POINTER_CHECK_VAL(poclCcaServiceHandler);

       //    dp_tclSpmDpInternDataEntertainMute oMute;
       //    tBool bMute = FALSE;

       //    oMute >> bMute;
       //    if (bMute) {
       //        //mute is currently active --> demute now
       //        oMute << FALSE;

       //        spm_corefi_tclMsgEntertainMuteStatus  oEntertainMuteStatus;
       //        oMute >> oEntertainMuteStatus.bMuteState;

       //        poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_ENTERTAINMUTE, &oEntertainMuteStatus);
       //    }
       //}

      return IMETHOD_RETURN_SUCCESS;

      // vMethodStart 'EntertainDeMute': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}


// implementation of interface IMethod
tU32 spm_MethodEntertainMuteRequest::u32MethodStart(amt_tclServiceData *poSrvData){
   //Extract CCA Message..
   fi_tclVisitorMessage oMsg(poSrvData);

   //Create Object..
   spm_corefi_tclMsgEntertainMuteRequestMethodStart oResultData;

   if ( OSAL_OK == oMsg.s32GetData(oResultData) )
   {
      // vMethodStart 'EntertainMuteRequest': user specific code start
	   //todo: IVI implementation not used for inf4cv -srs6cob
       //tU8 u8PowerPlatform = 0;
       //dp_tclSpmDpRnAiviCurrentPowerPlatform oCurPowerPlatform;
       //oCurPowerPlatform >> u8PowerPlatform;

       //if (   (u8PowerPlatform == SPM_U8_CONFIG_RENAULT_C1A)
       //        || (u8PowerPlatform == SPM_U8_CONFIG_RENAULT_T4VS)
       //) {

       //    ISpmLamAppManager* poclLamAppManager           = dynamic_cast<ISpmLamAppManager*>(ISpmFactory::_poFactoryRef->getSpmObjHandler("ISpmLamAppManager"));
       //    SPM_NULL_POINTER_CHECK_VAL(poclLamAppManager);
       //    //poclLamAppManager->vUpdateMultimediaTrigger(ISpmLamAppManager::eMultimediaTriggerAudioOff);

       //} else {
       //    ISpmCcaServiceServer* poclCcaServiceHandler    = dynamic_cast<ISpmCcaServiceServer*>(ISpmFactory::_poFactoryRef->getSpmObjHandler("spm_tclCcaServiceHandlerConfig"));
       //    SPM_NULL_POINTER_CHECK_VAL(poclCcaServiceHandler);

       //    dp_tclSpmDpInternDataEntertainMute oMute;
       //    tBool bMute = FALSE;

       //    oMute >> bMute;
       //    if (!bMute) {
       //        //mute is currently active --> demute now
       //        oMute << TRUE;

       //        spm_corefi_tclMsgEntertainMuteStatus  oEntertainMuteStatus;
       //        oMute >> oEntertainMuteStatus.bMuteState;

       //        poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_ENTERTAINMUTE, &oEntertainMuteStatus);
       //    }
       //}

       return IMETHOD_RETURN_SUCCESS;

      // vMethodStart 'EntertainMuteRequest': user specific code end
   }
   return( IMETHOD_RETURN_FAILED );
}
