/*!
  * \file spm_prjFactoryHelper.cpp
  *  \brief
  *    ....
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author            | Modification
  * 25.05.16  | kol2hi            | initial version
  ******
  */

/* ---
   read "---" comments to know what the code does
   --- */

/* +++
   read "+++" comments to know what you have to implement
 +++ */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"
#include "dp_spm_if.h"
#include "dp_generic_if.h"

#include "spm_Config.h"
#include "spm_GlobDefs.h"
#include "spm_trace.h"

#include "spm_prjFactoryHelper.h"
   //todo: IVI implementation not used for inf4cv -srs6cob
//#include "spm_SystemStateManagerNiCmfCd.h"
//#include "spm_SystemStateManagerNiCmfB.h"
//#include "spm_SystemStateManagerNiStd.h"
//#include "spm_SystemStateManagerNiC1A.h"
//#include "spm_SystemStateManagerDefault.h"
//#include "spm_SystemStateManagerRnC1A.h"
//#include "spm_SystemStateManagerRnT4VS.h"
#include "spm_SystemStateManagerInf4cv.h"
#include "spm_WdgAccSupervisor.h"
#include "spm_UnballastSupervisor.h"
#include "spm_ICsmService.h"

#ifdef SPM_FEATURE_ENABLE_SUBSTATE_DEBOUNCE
#include "spm_ISubStateDebounce.h"
#endif

#include "spm_IFactory.h"

// include interfaces

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_PRJ
#include "trcGenProj/Header/spm_prjFactoryHelper.cpp.trc.h"
#endif

// -----------------------------------------------------------------------------
// local defines
// -----------------------------------------------------------------------------
spm_tclPrjFactoryHelper::spm_tclPrjFactoryHelper(const ISpmFactory& factory) : ISpmPrjFactoryHelper(factory){
/*!
  * \fn
  *  \brief
  *    Constructor.
  *
  *  \param
  *    poSPM: pointer to parent
  *  \note
  *  \bug
  *    no bugs known
  *  \todo
  *    nothing left
  *  \version
  *    1.0   - Initial
  ******
  */

   return;
}

spm_tclPrjFactoryHelper::~spm_tclPrjFactoryHelper(){
/*!
  * \fn
  *  \brief
  *    Destructor.
  *
  *  \param
  *  \note
  *  \bug
  *    no bugs known
  *  \todo
  *    nothing left
  *  \version
  *    1.0   - Initial
  ******
  */
}

tVoid spm_tclPrjFactoryHelper::vGetReferences(){
}

tVoid spm_tclPrjFactoryHelper::vStartCommunication(){
	ISpmSystemStateManager* poclSystemStateManager = dynamic_cast < ISpmSystemStateManager* >(_crfFactory.getSpmObjHandler("ISpmSystemStateManager"));

	/*Reading the KDS value for HourLogicEnabled*/

	dp_tclKdsAIVIVariantCoding variantCoding1;
	tU8 u8HourLogicEnabled = 0;
	variantCoding1.u8GetHourLogicEnabled(u8HourLogicEnabled);

	ETG_TRACE_ERRMEM(("Kds value for HourLogicEnabled is: 0x%x", u8HourLogicEnabled));

	dp_tclSpmDpConfigStateProfileStatus oStateProfileStatus;

	if (u8HourLogicEnabled == 0)
	{
		oStateProfileStatus << FALSE;
	}
	else if(u8HourLogicEnabled == 1)
	{
		oStateProfileStatus << TRUE ;

	}
	else
	{
		ETG_TRACE_ERRMEM(("Out of boundary of HourLogicEnabled 0x%x ",u8HourLogicEnabled));
	}

	/*Reading the KDS value for HourLogicTimeRange*/

	dp_tclKdsAIVIVariantCoding variantCoding2;
	tU8 u8HourLogicTimeRange = 0;
	variantCoding2.u8GetHourLogicTimeRange(u8HourLogicTimeRange);

	ETG_TRACE_ERRMEM(("Kds value for HourLogicTimeRange is: 0x%x", u8HourLogicTimeRange));

	SPM_NULL_POINTER_CHECK(poclSystemStateManager);
	poclSystemStateManager->vSetStateTime(SPM_SYSTEM_STATE_PROFILE, (u8HourLogicTimeRange * 60000)); //Converting minutes to miliseconds

	dp_tclSpmDpConfigStateProfileTime oStateProfileTime;
        if((u8HourLogicTimeRange>0) && (u8HourLogicTimeRange<=255))    //Boundary value of Hourlogic timeout configuration is from 0-255 minutes
	{
		oStateProfileTime << u8HourLogicTimeRange;
	}
	else
	{
		ETG_TRACE_ERRMEM(("Out of boundary of HourLogicTimeRange 0x%x ",u8HourLogicTimeRange));
	}

	/*Reading the KDS value for StandbyTimeRange*/

/*	dp_tclKdsAIVIVariantCoding variantCoding5;
	tU8 *u8StandbyTimeout= new tU8;
	tU16 u16BufLen= 100;
	variantCoding5.u8GetStandbyTimeout(u8StandbyTimeout,u16BufLen);

	ETG_TRACE_ERRMEM(("Kds value for StandbyTimeout is: 0x%x", u8StandbyTimeout));

	SPM_NULL_POINTER_CHECK(poclSystemStateManager);
	tU8 StandbyTimeout= *u8StandbyTimeout;
	poclSystemStateManager->vSetStateTime(SPM_SYSTEM_BACKGROUND, ((StandbyTimeout/60) * 60000)); //Converting sec to miliseconds

	dp_tclSpmDpConfigStandbyTime oStandbyTime;
	if((StandbyTimeout>0) && (StandbyTimeout<=1200))  //Standby timeout configuration possible upto 0-65535 Seconds but limiting the value to 1200 seconds. 
	{
		oStandbyTime << StandbyTimeout;
	}
	else
	{
		ETG_TRACE_ERRMEM(("Out of boundary of standyTimeout 0x%x ",StandbyTimeout));
	}
*/
}

ISpmSystemStateManager* spm_tclPrjFactoryHelper::oStartSystemStateManager() {

    ISpmSystemStateManager* poclSystemStateManager = dynamic_cast < ISpmSystemStateManager* >( _crfFactory.getSpmObjHandler("ISpmSystemStateManager") );

    return poclSystemStateManager;
}

tVoid spm_tclPrjFactoryHelper::vRemoveSystemStateHandler(ISpmSystemStateManager *poclSystemStateManager) {

    ETG_TRACE_FATAL( ( "spm_tclPrjFactoryHelper::vRemoveSystemStateHandler(): now remove FSM '%s' from system!", poclSystemStateManager->getName() ) );
    //spm_tclUnballastSupervisor *poclSupervisionUnballast = dynamic_cast < spm_tclUnballastSupervisor* >( _crfFactory.getSpmObjHandler("spm_tclUnballastSupervisor") );
    //if (poclSupervisionUnballast != NULL) {
    //    ISpmFactory::_poFactoryRef->vRemoveFactoryClient(poclSupervisionUnballast);
    //    delete poclSupervisionUnballast;
    //}

    /*spm_tclWdgAccSupervisor *poclSupervisionAcc = dynamic_cast < spm_tclWdgAccSupervisor* >( _crfFactory.getSpmObjHandler("spm_tclWdgAccSupervisor") );
    if (poclSupervisionAcc != NULL) {
        ISpmFactory::_poFactoryRef->vRemoveFactoryClient(poclSupervisionAcc);
        delete poclSupervisionAcc;
    }*/

    ISpmTrace* poclTraceHdl = dynamic_cast < ISpmTrace* >( _crfFactory.getSpmObjHandler("ISpmTrace") );
    SPM_NULL_POINTER_CHECK(poclTraceHdl);

    poclTraceHdl->vRemoveTraceClient(poclSystemStateManager);
    ISpmFactory::_poFactoryRef->vRemoveFactoryClient(poclSystemStateManager);
    delete poclSystemStateManager;

    return;
}

// EOF
