/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_factory_config.h
  * @brief        This is the header file contains class definition of spm_tclFactoryConfig which is derived from base class spm_tclFactory of generic part.
  * @copyright    (C) 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef _SPM_FACTORY_CONFIG_H_
#define _SPM_FACTORY_CONFIG_H_

#ifndef _SPM_CONFIG_H
#error spm_config.h must be included!
#endif
#include "spm_ClientHandlerBase.h"
#include "spm_AnimationServiceHandler.h"
#include "spm_factory.h"

// forward declaration
class ISpmCsmService;
class ISpmSecurity;
class ISpmSupervisionClient;
class ISpmCvmUserClient;

/*!
  *  \class spm_tclFactoryConfig
  *  \brief This class extends from base class spm_tclFactory to add additional specific project functions and implement pure virtual functions.
  *
  *         To integrate with this class, any other class has to be derived from ISpmBase.
  *
  *         All spm components and client handlers are using this class for creation and to initialize all dependencies.
  *
  *         FC SPM components initialize the dependencies using getSpmObjHandler by passing the dependent class name.
  *         FC SPM client handlers initialize the dependencies using getClientHandler by passing the dependent class name.
  */

class spm_tclFactoryConfig : public spm_tclFactory
{
public:
    spm_tclFactoryConfig( );
    virtual ~spm_tclFactoryConfig();
    virtual const tChar*getName( ) const { return( "spm_tclFactoryConfig" ); }

private:
    // Implementation of base class spm_tclFactory
    virtual tVoid vCreatePrjComponents( );
    virtual tVoid vCreateClientHandling( );
    virtual tVoid vPrePrjStart( );
    virtual tVoid vStartPrjComponents( );
    virtual tVoid vPostPrjStart( );
    virtual tVoid vShowSystemInformationPrj( );
    virtual tVoid vPreStartEvaluateProcessStartup( );
    virtual tVoid vHandleTraceMessagePrj( const tUChar *puchData );

private:
    // csm
    ISpmCsmService          *CreateCsmIf();
    // security
    ISpmSecurity            *CreateSecurity();
    // supervision
    ISpmSupervisionClient   *CreateWdgClamp15Supervisor();
    ISpmSupervisionClient   *CreateWdgQSupervisor();
    ISpmSupervisionClient   *CreateWdgClampSupervisor();
    ISpmSupervisionClient   *CreateEngineeringSupervisor();
    ISpmSupervisionClient   *CreatePhoneHandoverSupervisor();
    // cvm
    ISpmCvmUserClient       *CreateCvmHandler8500mV();
    ISpmCvmUserClient       *CreateCvmHandler6000mV();
    ISpmCvmUserClient       *CreateCvmHandler19000mV();
};

#endif // _SPM_FACTORY_CONFIG_H_