/*!
  * \file  spm_Factory_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2018 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclFactory_include_ext: user specific code start
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"
#include "dp_generic_if.h"

#include "spm_factory_config.h"
#include "spm_IPrjFactoryHelper.h"
// spm_tclFactory_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_PRJ
#include "trcGenProj/Header/spm_Factory_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclFactory_include_spm: user specific code start
#include "spm_traceCommandsPrj.h"
#include "spm_UnballastSupervisor.h"
#include "spm_ISubStateClient.h"
#include "spm_ILamAppManager.h"
#include "spm_ICcaServiceServer.h"
#include "spm_SystemStateManagerInf4cv.h"
// spm_tclFactory_include_spm: user specific code end


tVoid spm_tclFactoryConfig::vHandleTraceMessagePrj(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_SPMTESTCMDPRJFACTORYGENERIC:
      {
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTestCmdPrjFactoryGeneric' was called" ) );

         // SpmTestCmdPrjFactoryGeneric: user specific code start
         // SpmTestCmdPrjFactoryGeneric: user specific code end
      }
      break;
/*
      case SPM_SPMRESTARTFSM:
      {
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmRestartFsm' was called: param1 = 0x%x", param1 ) );

         // SpmRestartFsm: user specific code start
       dp_tclSpmDpRnAiviPowerPlatform oRegPlatformType;

       oRegPlatformType.vSetData((tU8)param1);
       ISpmPrjFactoryHelper* poclFactoryHelper = dynamic_cast < ISpmPrjFactoryHelper* >( _crfFactory.getSpmObjHandler("ISpmPrjFactoryHelper") );
       SPM_NULL_POINTER_CHECK(poclFactoryHelper);

       ISpmSystemStateManager* poclSystemStateManager = poclFactoryHelper->oStartSystemStateManager();
       if (poclSystemStateManager == NULL) {
           ETG_TRACE_FATAL( ( "!!!!!!!!!!! FAILED to (re)start SystemStateManager !!!!!!!" ) );
       }

         // SpmRestartFsm: user specific code end
      }
      break;

      case SPM_SPMVEHICLESTATE:
      {
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmVehicleState' was called" ) );

         // SpmVehicleState: user specific code start
         SPM_NULL_POINTER_CHECK(_poSubStateHdl);
         if (_poSubStateHdl->bIsTriggerSet(SPM_U32_ACCESSORY)) {
             ETG_TRACE_USR1( ( "AutoACC:  ON") );
         } else {
             ETG_TRACE_USR1( ( "AutoACC:  OFF") );
         }
         if (_poSubStateHdl->bIsTriggerSet(SPM_U32_IGNITION)) {
             ETG_TRACE_USR1( ( "IGNITION: ON") );
         } else {
             ETG_TRACE_USR1( ( "IGNITION: OFF") );
         }
         //SPM_NULL_POINTER_CHECK(_poLamAppCfg);
         //_poLamAppCfg->vTraceMmiState();

         // SpmVehicleState: user specific code end
      }
      break;

      case SPM_SPMUNBALLASTSTATE:
      {
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmUnballastState' was called" ) );

         // SpmUnballastState: user specific code start

         //spm_tclUnballastSupervisor *poclSupervisionUnballast = dynamic_cast < spm_tclUnballastSupervisor* >( _crfFactory.getSpmObjHandler("spm_tclUnballastSupervisor") );
         //SPM_NULL_POINTER_CHECK(poclSupervisionUnballast);
         //poclSupervisionUnballast->vTraceInfo();

         // SpmUnballastState: user specific code end
      }
      break;

      case SPM_SPMMEMOSTATE:
      {
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmMemoState' was called" ) );

         // SpmMemoState: user specific code start
         //SPM_NULL_POINTER_CHECK(_poLamAppCfg);
         //_poLamAppCfg->vTraceMemoState();

         // SpmMemoState: user specific code end
      }
      break;

      case SPM_SPMTRIGGERHMIPOPUP:
      {
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerHmiPopup' was called: param1 = 0x%x", param1 ) );

         // SpmTriggerHmiPopup: user specific code start
         ISpmCcaServiceServer  *poclCcaServiceHandler = dynamic_cast < ISpmCcaServiceServer* >( _crfFactory.getSpmObjHandler("ISpmCcaServiceServer") );
         SPM_NULL_POINTER_CHECK(poclCcaServiceHandler);

         spm_corefi_tclMsgSystemPowerBehaviourStatus tSysPwrBehv;
         tSysPwrBehv.eSystemPowerBehaviour.enType = (spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::tenType)param1;

         poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_SYSTEMPOWERBEHAVIOUR, &tSysPwrBehv);
         // SpmTriggerHmiPopup: user specific code end
      }
      break;

      case SPM_SPMTRIGGERAUDIOSUBSTATE:
      {
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerAudioSubState' was called: param1 = 0x%x", param1 ) );

         // SpmTriggerAudioSubState: user specific code start
         ISpmCcaServiceServer *poclCcaServiceHandler = dynamic_cast < ISpmCcaServiceServer* >( _crfFactory.getSpmObjHandler("ISpmCcaServiceServer") );
         SPM_NULL_POINTER_CHECK(poclCcaServiceHandler);

         spm_corefi_tclMsgAudioStateStatus       tAudioState;
         tAudioState.AudioState.enType   = (spm_fi_tcl_SPM_e32_AUDIO_STATE::tenType)param1;
         poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_AUDIOSTATE, &tAudioState);
         // SpmTriggerAudioSubState: user specific code end
      }
      break;

      case SPM_SPMTRIGGERENTERTAINMENTMUTE:
      {
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerEntertainmentMute' was called: param1 = 0x%x", param1 ) );

         // SpmTriggerEntertainmentMute: user specific code start
         ISpmCcaServiceServer *poclCcaServiceHandler = dynamic_cast < ISpmCcaServiceServer* >( _crfFactory.getSpmObjHandler("ISpmCcaServiceServer") );
         SPM_NULL_POINTER_CHECK(poclCcaServiceHandler);

         spm_corefi_tclMsgEntertainMuteStatus    oEntertainMuteStatus;
         dp_tclSpmDpInternDataEntertainMute      oMute;

         if (param1 != 0) {
             oMute << FALSE;
         } else {
             oMute << TRUE;
         }

         oMute >> oEntertainMuteStatus.bMuteState;
         poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_ENTERTAINMUTE, &oEntertainMuteStatus);
         // SpmTriggerEntertainmentMute: user specific code end
      }
      break;
*/
      case SPM_SPMHOURLOGIC:
      {
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmHourLogic' was called: param1 = 0x%x", param1 ) );

         // SpmHourLogic: user specific code start
		 dp_tclSpmDpConfigStateProfileStatus oStateProfileStatus;

         if (param1 != 0) {
             oStateProfileStatus << TRUE;
         } else {
             oStateProfileStatus << FALSE;
         }
         // SpmHourLogic: user specific code end
      }
      break;

      case SPM_SPMSETHOURLOGICTIME:
      {
         tU16 param1 = (tU16)((puchData[3]<<8) | puchData[4]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSetHourLogicTime' was called: param1 = 0x%x", param1 ) );

         // SpmSetHourLogicTime: user specific code start
		 SPM_NULL_POINTER_CHECK(_poSystemStateManager);
	     _poSystemStateManager->vSetStateTime(SPM_SYSTEM_STATE_PROFILE, (param1 * 1000));
		 dp_tclSpmDpConfigStateProfileTime oStateProfileTime;
		 oStateProfileTime << param1;
         // SpmSetHourLogicTime: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclFactoryFunction: user specific code start
     // spm_tclFactoryFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclFactoryFile: user specific code start
// spm_tclFactoryFile: user specific code end

