#ifndef _SPM_CVM_9_0V_HANDLER_H_
#define _SPM_CVM_9_0V_HANDLER_H_

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------

#include "spm_ISpmCvmUserClient.h"

class ISpmOsalCvm;
class ISpmSubStateClient;

/*!
  *  \class spm_tclCvmHandler9000mV
  *  \brief Handle user voltage level 9.0V

        The ISpmFactory object creates an instance of this class.

  */
class spm_tclCvmHandler9000mV : public ISpmCvmUserClient
{
private:
ISpmOsalCvm        *_poOsalCvm;
ISpmSubStateClient *_poclSubStateHandler;

OSAL_tTimerHandle   _hVoltageTimer;
static tVoid vVoltageTimerCallback(tVoid *pArg);


tU32                _u32LowVoltageTimeout;

public:
/*---------------------------------------------------------------------*/
spm_tclCvmHandler9000mV(const ISpmFactory& factory); // Lint requested default constructor
virtual ~spm_tclCvmHandler9000mV(void);                 // destructor
/*---------------------------------------------------------------------*/

virtual tVoid vGetReferences();

virtual tVoid vStartCommunication();

virtual tVoid vStartLateCommunication();

virtual tVoid vHandleTraceMessage(const tUChar *puchData){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual const tChar*getName() const { return( "spm_tclCvmHandler9000mV" ); }

virtual tVoid vVoltageLevelOverrun();

virtual tVoid vVoltageLevelUnderrun();

};
#endif // _SPM_CVM_6_0V_HANDLER_H_

