/*!
  * \file spm_cvm_9_0v_handler.cpp
  *  \brief
  *    Handle user voltage level 9.0V.
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author            | Modification
  * 17.03.16  | kol2hi            | initial version
  ******
  */

/* ---
   read "---" comments to know what the code does
   --- */

/* +++
   read "+++" comments to know what you have to implement
 +++ */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

#include "spm_Config.h"
#include "spm_GlobDefs.h"
#include "spm_trace.h"

#include "spm_cvm_LowVoltage_handler.h"

#include "spm_IFactory.h"

// include interfaces
#include "spm_ISpmOsalCvm.h"
#include "spm_ISubStateClient.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_PRJ
#include "trcGenProj/Header/spm_cvm_LowVoltage_handler.cpp.trc.h"
#endif

// -----------------------------------------------------------------------------
// local defines
// -----------------------------------------------------------------------------
spm_tclCvmHandler9000mV::spm_tclCvmHandler9000mV(const ISpmFactory& factory)
   : ISpmCvmUserClient(factory),
   _poOsalCvm(NULL),
   _hVoltageTimer(OSAL_C_INVALID_HANDLE),
   _poclSubStateHandler(NULL){
/*!
  * \fn
  *  \brief
  *    Constructor.
  *
  *  \param
  *    poSPM: pointer to parent
  *  \note
  *  \version
  *    1.0   - Initial
  ******
  */

   dp_tclSpmDpConfigLowVoltageShutdownTime         oLowVoltShutdown;
   oLowVoltShutdown >> _u32LowVoltageTimeout;

   if (OSAL_s32TimerCreate(vVoltageTimerCallback, this, &_hVoltageTimer) != OSAL_OK){
      ETG_TRACE_ERR( ( "SPM: !!!!!! Error detected !!!!!!" ) );
   }
   return;
}

spm_tclCvmHandler9000mV::~spm_tclCvmHandler9000mV(){
/*!
  * \fn
  *  \brief
  *    Destructor.
  *
  *  \param
  *  \note
  *  \version
  *    1.0   - Initial
  ******
  */
   _poclSubStateHandler = NULL;
   _poOsalCvm           = NULL;
}

tVoid spm_tclCvmHandler9000mV::vGetReferences(){
   SPM_GET_IF_REFERENCE_USE_VAR( _poOsalCvm,           ISpmOsalCvm );
   SPM_GET_IF_REFERENCE_USE_VAR( _poclSubStateHandler, ISpmSubStateClient );
}

tVoid spm_tclCvmHandler9000mV::vStartCommunication(){
}

tVoid spm_tclCvmHandler9000mV::vStartLateCommunication(){

   SPM_NULL_POINTER_CHECK(_poOsalCvm);

   ETG_TRACE_USR1( ( "spm_tclCvmHandler9000mV::vStartLateCommunication(): Register to OsalCvm!" ) );
   _poOsalCvm->bAddUserVoltClient(this, 9000, 100);

}

tVoid spm_tclCvmHandler9000mV::vVoltageLevelUnderrun(){
   ETG_TRACE_USR1( ( "spm_tclCvmHandler9000mV::vVoltageLevelUnderrun(): We are now below 9.0V -> Start timer of %dms!!!", _u32LowVoltageTimeout ) );
   if (OSAL_s32TimerSetTime(_hVoltageTimer, _u32LowVoltageTimeout, 0) != OSAL_OK){
      ETG_TRACE_ERR( ( "SPM: !!!!!! spm_tclCvmHandler9000mV::vVoltageLevelUnderrun(): Error detected --> cannot start timer!!!!!!" ) );
   }
}

tVoid spm_tclCvmHandler9000mV::vVoltageLevelOverrun(){
   ETG_TRACE_USR1( ( "spm_tclCvmHandler9000mV::vVoltageLevelOverrun(): We are now above 9.0V --> stop timer!!!" ) );
   if (OSAL_s32TimerSetTime(_hVoltageTimer, 0, 0) != OSAL_OK){
      ETG_TRACE_ERR( ( "SPM: !!!!!! spm_tclCvmHandler9000mV::vVoltageLevelUnderrun(): Error detected --> cannot start timer!!!!!!" ) );
   }

   SPM_NULL_POINTER_CHECK(_poclSubStateHandler);
   _poclSubStateHandler->vSetSubStateType(SPM_U32_ENDURING_LOW_VOLTAGE, FALSE);

   ISpmWorkerServer* poclWorkerServer = dynamic_cast < ISpmWorkerServer* >( _crfFactory.getSpmObjHandler("ISpmWorkerServer") );
   SPM_NULL_POINTER_CHECK(poclWorkerServer);
   poclWorkerServer->bPostMessage("ISpmLamAppManager", SPM_U32_WORKER_LAM_LOW_90V_END);
}

tVoid spm_tclCvmHandler9000mV::vVoltageTimerCallback(tVoid *pArg){
   spm_tclCvmHandler9000mV *poVoltageManager = (spm_tclCvmHandler9000mV*)pArg;

   /*SPM_NULL_POINTER_CHECK(poVoltageManager);
   poVoltageManager->_poclSubStateHandler->vSetSubStateType(SPM_U32_ENDURING_LOW_VOLTAGE, TRUE);*/
}

// EOF

