/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ICsmService.h
  * @brief        This is header file contains interfaces to handle CAN stack messages.
  * @copyright    (C) 2015 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_config.h must be included!
#endif

#include "spm_ISpmBase.h"

/*!
  *  \class ISpmCsmService
  *  \brief This abstract class provides interfaces to handle CAN stack messages.
          This class delivers interfaces for sending and reading CSM broadcast signals.
  */
class ISpmCsmService : public ISpmBase
{
public:
ISpmCsmService( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmCsmService( ){}

virtual tVoid vSendCsmBroadcastSignal( tU8 *pabData,
                                       tU8  u8Len,
                                       tU32 u32CsmSignal,
                                       tU8  u8TxType )       = 0;

virtual tU32  u32ReadCsmBroadcastSignal( tU8 *pabData,
                                         tU8  u8Len,
                                         tU32 u32CsmSignal ) = 0;

virtual tVoid vCsmCommunicationRequest( tU8 u8ConnectState ) = 0;

virtual tVoid vTraceCsmSignals( ) const                      = 0;

virtual tVoid vCheckCsmSignals( ) const                      = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmCsmService" ); }
};

