/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_service_csm.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#ifndef _SPM_SERVICE_CSM_H_
#define _SPM_SERVICE_CSM_H_

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_ICsmService.h"
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h" 
#include "spm_SpmDbusServiceHandler.h"

class CSMInterface;
class ISpmSubStateClient;
class ISpmSystemPowerManager;
class ISpmWorkerServer;
class ISpmSystemStateManager;


// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
// class definition
// -----------------------------------------------------------------------------


/*!
  *  \class spm_tclCsmIf
  *  \brief This project specific class handles car area network stack(CSM) broadcast signals. It reads and sends CAN stack broadcast signals .
          it also checks and traces CSM signals. 

        The spm_tclFactory object creates an instance of this class.

  */
class spm_tclCsmIf : public ISpmCsmService
{

private:
static spm_tclCsmIf    *_pMyStaticRef;

CSMInterface           *_poMyCSMInterface;
static tVoid vSignalInd( tVoid *pHandle,
                         tU32   u32SignalId,
                         tU32   u32SignalStatus );

tVoid vSignalIndication(tU32 u32SignalId);


ISpmSubStateClient     *_poclSubStateHandler;
ISpmSystemPowerManager *_poclSystemPowerManager;
ISpmWorkerServer       *_poclWorkerServer;
ISpmSystemStateManager *_poclSystemStateManager;
spm_tclSpmDBusServiceHandler *_poLcmdbusclientprj;
tBool                   bConnectCsmIf(tU32 u32MaxWaitingTime);

public:
/* +++
   Enter your public Data and functions here
 +++ */
/*---------------------------------------------------------------------*/
spm_tclCsmIf( const ISpmFactory& factory );
/*---------------------------------------------------------------------*/
virtual ~spm_tclCsmIf( void ); // destruktor
/*---------------------------------------------------------------------*/
virtual tVoid vSendCsmBroadcastSignal( tU8 *pabData,
                                       tU8  u8Len,
                                       tU32 u32CsmSignal,
                                       tU8  u8TxType );

virtual tU32  u32ReadCsmBroadcastSignal( tU8 *pabData,
                                         tU8  u8Len,
                                         tU32 u32CsmSignal );

virtual tVoid vCsmCommunicationRequest( tU8 u8ConnectState );
virtual tVoid vTraceCsmSignals( ) const;
virtual tVoid vCheckCsmSignals( ) const;

// ISpmBase methods
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );
virtual tVoid vStartLateCommunication( );
tU8 getKDSPNMGRP10Status();
tU8 getKDSSystemType();

virtual tVoid vHandleTraceMessage( const tUChar *puchData ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual const tChar*getName( ) const { return( "spm_tclCsmIf" ); }
tVoid vHandlePNMGrp10Stat();
bool CheckOpcode();

protected:
// Implementation of interface ISpmWorkerClient
virtual tVoid vHandleMessage( tU32 u32Message,
							  tU32 u32Parm = 0 );

virtual tBool bHandleSynchrounousCall( tU32   u32Message,
										tVoid *args );
};
#endif // _SPM_SERVICE_CSM_H_




