/**
* @swcomponent Life Cycle Management
* @{
* @file        spm_VdDiagLogCcaServiceHandler.h
* @brief       This is header file contains interface functions for VdDialog Service.
* @copyright   (C) 2018 Robert Bosch GmbH.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/
#ifndef SPM_VDDIAGLOGSERVICEHANDLER_H
#define SPM_VDDIAGLOGSERVICEHANDLER_H 

#define SYSTEM_S_IMPORT_INTERFACE_SET
#define SYSTEM_S_IMPORT_INTERFACE_MAP
#include "stl_pif.h"

#ifndef _SPM_CONFIG_H
#error spm_config.h must be included!
#endif

#include "ICcaDiaglogProxy.h"


#define DIAGLOG_FI_S_IMPORT_INTERFACE_DIAGLOG_MAINFI_TYPES
#define DIAGLOG_FI_S_IMPORT_INTERFACE_DIAGLOG_MAINFI_FUNCTIONIDS
#include "diaglog_fi_if.h"


// service handler requests ---------------------------------------

class spm_tclVdDiagLogServiceHandler : public ICcaDiaglogProxy
{
private:
	// trouble codes
	std::map<tU16, diaglog_fi_tcl_e8_TestResult::tenType> _tc;

	// handle functions of power service
	tVoid vHandleSaveTestResult(amt_tclServiceData *poMessage);
	tVoid vHandleSendNextTestResult(amt_tclServiceData *poMessage);

	tVoid vSendAllTestResults(const std::set<tU16>& incl);
protected:
    //ISpmBase interface functions
    virtual tVoid vHandleTraceMessage(const tUChar* /*puchData*/) {};
    virtual const tChar* getName() const { return "spm_tclVdDiagLogServiceHandler"; }
    //virtual tVoid vGetReferences();
    //virtual tVoid vStartCommunication();

public:
	spm_tclVdDiagLogServiceHandler(const ISpmFactory& factory);
	virtual ~spm_tclVdDiagLogServiceHandler();
	virtual tVoid vRegisterFids();

    // add an error type
   virtual tVoid vAddItc(tU16 itc,
                         tU8  u8Result = SPM_U8_CCAPROXY_DIAGLOG_PASSED);

   virtual tVoid vSetItcError(tU16 u16ItcType,
                              tU8  u8Result);

	DECLARE_MSG_MAP(spm_tclVdDiagLogServiceHandler)
};

#endif

