/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SystemStateMachineServiceHandlerConfig.h
  * @brief        Project specific implementation of the INC client handler for system state machine component
  * @copyright    (C) 2016 Robert Bosch Engineering and Business Solutions Vietnam Company.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_SystemStateMachineServiceHandler.h"


/*!
  *  \class spm_tclSystemStateMachineServiceHandlerConfig
  *  \brief This is the extension for the spm_tclSystemStateMachineServiceHandler class.
  *         Project specific re-action can be defined here to handle the response from the system state machine server.
  *         The ISpmFactory object creates an instance of this class.
  */
class spm_tclSystemStateMachineServiceHandlerConfig : public spm_tclSystemStateMachineServiceHandler
{

public:
	spm_tclSystemStateMachineServiceHandlerConfig( const ISpmFactory& factory );
	virtual ~spm_tclSystemStateMachineServiceHandlerConfig();
	virtual const tChar* getName() const { return( "spm_tclSystemStateMachineServiceHandlerConfig" ); }
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
private:
   /* R_COMPONENT_STATUS */
   virtual tVoid vOnComponentStatusRespond( eSystemSm_ApplicationStatus eServerComponentStatus );
   /* R_REJECT */
   virtual tVoid vOnMessageReject( tU8 u8RejectedMsgID, eSystemSm_RejReason eRejectReason );
   /* R_SET_STATEMACHINE_TYPE */
   virtual tVoid vOnSetStateMachineTypeRespond( eSystemSm_StateMachineType eStateMachineType );
   /* R_SET_SM_TRIGGER */
   virtual tVoid vOnSetStateMachineTriggerRespond( tU8 u8NumOfTriggers,
                                                   tU8 *pu8SMTriggerList1, tU8 u8NumOfSMTriggerList1,
                                                   tU8 *pu8SMTriggerList2, tU8 u8NumOfSMTriggerList2,
                                                   tU8 *pu8SMTriggerList3, tU8 u8NumOfSMTriggerList3 );
   /* R_SET_SCC_SYSTEMSTATE */
   /* R_SEND_APP_SYSTEMSTATE */
   /* R_SCC_SYSTEMSTATE */
   virtual tVoid vOnSCCSystemStateUpdate( eSystemSm_SccSystemState eSccSystemState );
   /* R_APP_SYSTEMSTATE */
   virtual tVoid vOnSetAppSystemStateRequest( eSystemSm_AppSystemState eAppSystemState );

   //todo: IVI implementation not used for inf4cv -srs6cob
   //tU8 _u8PowerPlatform;
};
