/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ILamAppManager.h
  * @brief        This is header file contains interfaces to handle applications states, to update HMI state and process subState.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

// FI-zone starts
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#define SPM_MAX_ERRMEM_BUF              33
#define SPM_MAX_ERRMEM_APP_FAIL_BUF     ( SPM_MAX_ERRMEM_BUF + 4 )

#include "spm_IWorkerClient.h"
#include "spm_SubStateDefines.h"

class spm_corefi_tclMsgHmiStateStatus;
// //////////////////////////////////////////////////////////////////////////////
// Interface to SystemPowerManager

/*!
  *  \class ISpmLamAppManager
  *  \brief This abstract class provides interfaces to handle applications states. This class also delivers
          interfaces to update HMI state and process subState.

  */
class ISpmLamAppManager : public ISpmWorkerClient
{
public:

	//todo:  Multimedia triggers not used for inf4cv . need to revisit - srs6cob
    typedef enum {
        eMultimediaTriggerNone       = 0,
        eMultimediaTriggerDoorOpened = 1,
        eMultimediaTriggerEntryOn    = 2,
        eMultimediaTriggerForceOff   = 3,
        eMultimediaTriggerForceOn    = 4,
        eMultimediaTriggerIgnOn      = 5,
        eMultimediaTriggerIgnOff     = 6,
        eMultimediaTriggerHmiOnStdy  = 7,
        eMultimediaTriggerHmiOn      = 8,
        eMultimediaTriggerHmiOff     = 9,
        eMultimediaTriggerAnimationFinished = 10,
        eMultimediaTriggerAudioOn    = 11,
        eMultimediaTriggerAudioOff   = 12,
        eMultimediaTriggerBtOn       = 13,
        eMultimediaTriggerBtOff      = 14,
        eMultimediaTriggerWifiOn     = 15,
        eMultimediaTriggerWifiOff    = 16,
        eMultimediaTriggerDoorClosed = 17
    }EMultimediaTrigger;

    ISpmLamAppManager( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
    virtual ~ISpmLamAppManager( ){ }

protected:
    virtual tVoid vUpdateHmiState( spm_corefi_tclMsgHmiStateStatus *pStateToSend ) = 0;

public:
    virtual tVoid vStartCommunication( )                                           = 0;

    virtual tVoid vNewSubState( TTriggerMsg *tNewTrigger )                         = 0;

    virtual tVoid vProcessSystemState( tU32 u32NewSystemState,
            tU32 u32SystemStateReached )                = 0;

    virtual tVoid vAppStateAcknowledge( tU32 u32AppId,
            tU32 u32AppState )                         = 0;

    virtual tVoid vNewAppStateReached( )                                           = 0;

    virtual tVoid vAllSubStatesProcessed( )                                        = 0;

virtual tVoid vTraceRemainingTime( )                                           = 0;

// Implementation of interface ISpmWorkerClient
virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 )                               = 0;

    virtual tBool bHandleSynchrounousCall( tU32   u32Message,
            tVoid *args )                           = 0;

    virtual const tChar*getInterfaceName( ) const { return( "ISpmLamAppManager" ); }
};

