/*!
  * \file spm_LamAppManagerConfig.cpp
  *  \brief
  *    Project Specific class to process HMI and DMI states
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  *   Date      | Author                           | Modification
  * 12.08.11  | PJ-VW32 Klaus-Peter Kollai       | initial version
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

#include "spm_Config.h"

// my class header
#include "spm_LamAppManagerConfig.h"

// spm class definitions w/o interface
//#include "spm_security.h"
//#include "spm_ApplicationConfigurationConfig.h"

// interfaces class definitions
#include "spm_ISubStateClient.h"
#include "spm_ICcaServiceServer.h"
#include "spm_ILocalAppManager.h"

// include for call of static function
#include "spm_SubStateHandler.h"
#include "spm_GlobalApplicationManager.h"
#include "spm_ApplicationConfiguration.h"
#include "spm_trace.h"
#include "spm_WorkerServer.h"
#include "spm_ApplicationDatabase.h"

#include "spm_IFactory.h"

//include interfaces
#include "spm_ICcaServiceServer.h"
#include "spm_ISubStateClient.h"
// spm helper

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_PRJ
#include "trcGenProj/Header/spm_LamAppManagerConfig.cpp.trc.h"
#endif

 

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/

spm_tclLamAppManagerConfig::spm_tclLamAppManagerConfig(const ISpmFactory& factory)
: ISpmLamAppManager(factory)
{
	_poclWorkerServer = NULL;
	_poclSubStateHandler = NULL;
	_poclCcaServiceHandler = NULL;
	_bSwitchedOffByCriticalLow = FALSE;
	_bSwitchedOffByHigh = FALSE;
//  	_poSecurity = NULL;
// 	_poclAppCfg  = NULL;
}

spm_tclLamAppManagerConfig::~spm_tclLamAppManagerConfig()
{
	if(_poclWorkerServer != NULL){
        _poclWorkerServer->vRemoveClient(this);
}
	_poclWorkerServer = NULL;
	_poclSubStateHandler = NULL;
	_poclCcaServiceHandler = NULL;
//  	_poSecurity = NULL;
//  	_poclAppCfg = NULL;
}

tVoid spm_tclLamAppManagerConfig::vGetReferences()
{
	_poclWorkerServer = dynamic_cast <ISpmWorkerServer*>( _crfFactory.getSpmObjHandler("ISpmWorkerServer") );
	_poclSubStateHandler = dynamic_cast <ISpmSubStateClient*>( _crfFactory.getSpmObjHandler("ISpmSubStateClient") );
	_poclCcaServiceHandler = dynamic_cast <ISpmCcaServiceServer*>( _crfFactory.getSpmObjHandler("ISpmCcaServiceServer") );
	//_poSecurity = dynamic_cast <ISpmSecurity*>( _crfFactory.getSpmObjHandler("spm_tclSecurity") );
	//_poclAppCfg = dynamic_cast <spm_tclApplicationConfigurationConfig*>( _crfFactory.getSpmObjHandler("spm_tclApplicationConfigurationConfig") );

	SPM_NULL_POINTER_CHECK(_poclWorkerServer);
	SPM_NULL_POINTER_CHECK(_poclSubStateHandler);
	SPM_NULL_POINTER_CHECK(_poclCcaServiceHandler);
	//SPM_NULL_POINTER_CHECK(_poSecurity);
	//SPM_NULL_POINTER_CHECK(_poclAppCfg);
	_poclWorkerServer->vAddClient(this);
}

tVoid spm_tclLamAppManagerConfig::vStartCommunication()
{
}

tVoid spm_tclLamAppManagerConfig::vNewSubState(TTriggerMsg *tNewTrigger)
{
	(tVoid)tNewTrigger;
}

tVoid spm_tclLamAppManagerConfig::vAllSubStatesProcessed(){
	
	dp_tclSpmDpInternDataSystemState    oNewSysState;
	spm_corefi_tclMsgHmiStateStatus     tHmiState;
	spm_corefi_tclMsgBluetoothStateStatus tBtState;
	spm_corefi_tclMsgAudioStateStatus     tAudioState;

	/*Piyush 22/04/2021: This has to be revisted later*/
	/*tHmiState.HmiState.enType = spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_OFF;
	tBtState.BtState.enType = spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_BT_OFF;
	tAudioState.AudioState.enType = spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_OFF;*/  

	switch (oNewSysState.tGetData())
	{
		case SPM_SYSTEM_ON:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_HMI;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_NORMAL;
		break;

		case SPM_SYSTEM_MMI_ON_TEL:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_OFF_PHONE;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_NORMAL;
		break;

		case SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_INFOTAINMENT_OFF ;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_BT_OFF;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_EMERGENCY;
		break;

		case SPM_SYSTEM_MMI_ON:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_ON_PARTIAL_USER;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_NORMAL;
		break;
		
		case SPM_SYSTEM_STATE_PROFILE:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_HMI_HOUR_MODE;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_NORMAL;		
		break;

		case SPM_SYSTEM_IGNITION:
			if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_Q_CRITICAL))
			{
				tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_INACTIVE;
				tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_BT_OFF;
				tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_EMERGENCY;
			}
			else
			{
				tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_STANDBY;
				tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL;
				tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_NORMAL;
			}		
		break;
		
		case SPM_SYSTEM_SAFE:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_INACTIVE;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_BT_OFF;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_EMERGENCY;
		break;
		
		case SPM_SYSTEM_DOWNLOAD:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_HMI;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_OFF;	
		break; 
		
		case SPM_SYSTEM_DIAGNOSIS:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_OFF_DIAG;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_NORMAL;		
		break;

		case SPM_SYSTEM_MMI_STANDBY:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_ANIMATION;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_NORMAL;
		break;

		case SPM_SYSTEM_DOOR_OPEN:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_OFF;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_NORMAL;
		break;

		case SPM_SYSTEM_STANDBY:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_GOODBYE;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_NORMAL;	
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_EMERGENCY;
		break;

		case SPM_SYSTEM_MMI_ON_SWDL:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_REMOTE_PROGRAMMING;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_BT_OFF;	
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_OFF;
		break;

		case SPM_SYSTEM_BACKGROUND:
		case SPM_SYSTEM_PREPARE_SHUTDOWN:
		case SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_OFF;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_BT_OFF;	
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_EMERGENCY;
		break;
		
		default:
			tHmiState.HmiState.enType		= spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_OFF;
			tBtState.BtState.enType			= spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_BT_OFF;
			tAudioState.AudioState.enType	= spm_fi_tcl_SPM_e32_AUDIO_STATE::FI_EN_SPM_U32_AUDIOSTATE_OFF;
		break;

	} // switch

	ETG_TRACE_USR1(("spm_tclLamAppManagerConfig::vProcessSystemState(): Update  HmiState '%u',BtState '%u', AudioState '%u'",
		ETG_ENUM(CFC_FI_SPM_HMI_STATE, (tU32)tHmiState.HmiState.enType),
		ETG_ENUM(SPM_BT_STATE, (tU32)tBtState.BtState.enType),
		ETG_ENUM(SPM_AUDIO_STATE, (tU32)tAudioState.AudioState.enType)
		));

	vUpdateDimState();
	vUpdateHmiState(&tHmiState);
	_poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_BLUETOOTHSTATE, &tBtState);
	_poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_AUDIOSTATE, &tAudioState);
}

tVoid spm_tclLamAppManagerConfig::vProcessSystemState(tU32 u32NewSystemState,
                                                      tU32 u32SystemStateReached){
   (tVoid)u32NewSystemState;
   (tVoid)u32SystemStateReached;
   
} // lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used


tVoid spm_tclLamAppManagerConfig::vUpdateDimState()
{
	spm_corefi_tclMsgDimStateStatus         tDimState;
	spm_corefi_tclMsgDimmingStateStatus     tDimmingState;

	tDimState.DimState.enType       = (spm_fi_tcl_SPM_e32_DIM_STATE::tenType)0;
	tDimmingState.DimState.u32Value = 0x80000000;

	_bSwitchedOffByHigh = FALSE;
	if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_HIGH_VOLTAGE) ) 
	{
        	_bSwitchedOffByHigh = TRUE;
	}

	if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_CRITICAL_LOW_VOLTAGE) ) 
	{
        	_bSwitchedOffByCriticalLow = TRUE;
	}

    //if voltage level is above udrop 9.0V disable voltage switch off for dimming
	if (!_poclSubStateHandler->bIsTriggerSet(SPM_U32_LOW_VOLTAGE) ) 
	{
		_bSwitchedOffByCriticalLow = FALSE;
	}

	tBool bAudioOn = FALSE;
	dp_tclSpmDpInternDataSystemState    oNewSysState;

	if (!_bSwitchedOffByCriticalLow && !_bSwitchedOffByHigh) 
	{
        	switch (oNewSysState.tGetData() )
		{
			case SPM_SYSTEM_ON:
			case SPM_SYSTEM_MMI_ON_TEL:
			case SPM_SYSTEM_DOWNLOAD:
			case SPM_SYSTEM_DIAGNOSIS:
			case SPM_SYSTEM_STATE_PROFILE:
			case SPM_SYSTEM_MMI_STANDBY:
			case SPM_SYSTEM_MMI_ON:
			case SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1:
			case SPM_SYSTEM_STANDBY:
			case SPM_SYSTEM_MMI_ON_SWDL:
 				tDimState.DimState.enType = (spm_fi_tcl_SPM_e32_DIM_STATE::tenType)( ( tU32 ) spm_fi_tcl_SPM_e32_DIM_STATE::FI_EN_SPM_U32_DIMSTATE | ( tU32 ) 		   						spm_fi_tcl_SPM_e32_DIM_STATE::FI_EN_SPM_U32_DIMSTATE_BACKLIGHT );
              			tDimmingState.DimState.bits.SPM_U32_DIMMINGSTATE           = 1;
             			tDimmingState.DimState.bits.SPM_U32_DIMMINGSTATE_BACKLIGHT = 1;
              			bAudioOn = TRUE;
             		break;
			case SPM_SYSTEM_BACKGROUND:
			case SPM_SYSTEM_IGNITION:
			case SPM_SYSTEM_SAFE:
			case SPM_SYSTEM_DOOR_OPEN:
			case SPM_SYSTEM_PREPARE_SHUTDOWN:
			case SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2:
				tDimState.DimState.enType = spm_fi_tcl_SPM_e32_DIM_STATE::FI_EN_SPM_U32_DIMSTATE;
				tDimmingState.DimState.u32Value = 0x80000000;  
			break;
         		default:
              		break;
		} // switch
	}

	ETG_TRACE_USR1( ( "spm_tclLamAppManagerConfig::vAllSubStatesProcessed(): Update DimState '%08x'",(tU32)tDimState.DimState.enType));

	ISpmCcaServiceServer *pCcaSrv = dynamic_cast < ISpmCcaServiceServer* >( _crfFactory.getSpmObjHandler("ISpmCcaServiceServer"));
	if (pCcaSrv)
	{
		pCcaSrv->vUpdateProperty(SPM_COREFI_C_U16_DIMSTATE, &tDimState);
        	pCcaSrv->vUpdateProperty(SPM_COREFI_C_U16_DIMMINGSTATE, &tDimmingState);
	}


    /*if (_poAppCfg) {
        if (bAudioOn) {
            _poAppCfg->vSetValue(CCA_C_U16_APP_AUDIO, oNewSysState.tGetData(), AMT_C_U32_STATE_NORMAL);
        } else {
            _poAppCfg->vSetValue(CCA_C_U16_APP_AUDIO, oNewSysState.tGetData(), AMT_C_U32_STATE_PAUSE);
        }

        ISpmLocalAppManager* poclLocalAppManager;
        SPM_GET_IF_REFERENCE_USE_VAR( poclLocalAppManager, ISpmLocalAppManager );
        poclLocalAppManager->bSetAllApplicationsInProfile();

    }*/
}

tVoid spm_tclLamAppManagerConfig::vNewAppStateReached()
{
}

tVoid spm_tclLamAppManagerConfig::vTraceRemainingTime()
{
}

tVoid spm_tclLamAppManagerConfig::vHandleMessage(tU32 u32Message,tU32 u32Parm)
{
	(tVoid)u32Message;
	(tVoid)u32Parm;
	switch (u32Message)
	{
		case SPM_U32_DBUSSERVICE_HANDLER_UP:
			//PSARCC30-2062, Proclcmdbusclient delay causing Service unavailability. HMI starting earlier than expected.
			//ETG_TRACE_USR4( ( "spm_tclLamAppManagerConfig::vHandleMessage  u32HmiApplicationstate : %d",  u32HmiApplicationstate) );
			/*if(u32HmiApplicationstate == SPM_U32_LCM_SHUTDOWNTYPE_RUNUP)
			{
				vHandleHMIStartup();
			}*/
		break;
		case SPM_U32_WORKER_LAM_LOW_90V_END:
			//switch backlight on by leaving 9.0V level
			_bSwitchedOffByCriticalLow = FALSE;
			vUpdateDimState();
		break;
		default:
		break;
	}

   /*if (u32Message == SPM_U32_WORKER_LAM_LOW_90V_END){
       //switch backlight on by leaving 9.0V level
       _bSwitchedOffByCriticalLow = FALSE;

       vUpdateDimState();   }*/
}

tVoid spm_tclLamAppManagerConfig::vUpdateHmiState(spm_corefi_tclMsgHmiStateStatus *pStateToSend)
{
	SPM_NULL_POINTER_CHECK(_poclCcaServiceHandler);
	_poclCcaServiceHandler->vUpdateProperty(SPM_COREFI_C_U16_HMISTATE, pStateToSend);
}





