/*****************************************************************************
* FILE:         lcmdbusclient_ServiceLcmDbusClientIf.h
* PROJECT:      G3G project
* SW-COMPONENT: lcmdbusclient
* Template:     ServiceIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __lcmdbusclient_ServiceLcmDbusClientIf__IF__H_
#define __lcmdbusclient_ServiceLcmDbusClientIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_lcmdbusclient_ServiceLcmDbusClientIf.h"
#include "lcmdbusclient_AppMain.h"
#include "lcmdbusclient_ServiceLcmDbusClientCallbackIf.h"

// lcmdbusclient_tclServiceLcmDbusClientIf_Include: user specific code start
// lcmdbusclient_tclServiceLcmDbusClientIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ilcmdbusclient_tclServiceLcmDbusClient;

class lcmdbusclient_tclServiceLcmDbusClientIf : public Ilcmdbusclient_tclServiceLcmDbusClientIf, public lcmdbusclient_tclServiceLcmDbusClientCallbackIF
{
public:

   lcmdbusclient_tclServiceLcmDbusClientIf(tVoid); 
   lcmdbusclient_tclServiceLcmDbusClientIf(lcmdbusclient_tclAppMain* poMainAppl);
   virtual ~lcmdbusclient_tclServiceLcmDbusClientIf();

   // lcmdbusclient_tclServiceLcmDbusClientIfDeclarations: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
   virtual const tChar* getName() const { return "lcmdbusclient_tclServiceLcmDbusClientIf"; };
   
   //Nanomsg
   virtual tVoid sendNanomsgStatusStatus(tBool Nanomsgconstate);
   virtual tBool onNanomsgStatusSet(tBool Nanomsgconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual void vGetNanomsgStatusMsg(lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetNanomsgStatusMsg(oStatus);}

   virtual tVoid sendVoltagelevelStatusStatus(tU8 Voltagelevelconstate);
   virtual tBool onVoltagelevelStatusSet(tU8 Voltagelevelconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual void vGetVoltagelevelStatusMsg(lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetVoltagelevelStatusMsg(oStatus);}
   
   virtual tVoid sendCockpitmodeStatusStatus(tU8 Cockpitmodeconstate);
   virtual tBool onCockpitmodeStatusSet(tU8 Cockpitmodeconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual void vGetCockpitmodeStatusMsg(lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetCockpitmodeStatusMsg(oStatus);}
   
   virtual tVoid sendSubsystemerrorStatusStatus(lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate);
   virtual tBool onSubsystemerrorStatusSet(lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual void vGetSubsystemerrorStatusMsg(lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetSubsystemerrorStatusMsg(oStatus);}
   
   virtual tVoid sendThermallevelStatusStatus(tU16 Thermallevelconstate);
   virtual tBool onThermallevelStatusSet(tU16 Thermallevelconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual void vGetThermallevelStatusMsg(lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetThermallevelStatusMsg(oStatus);}
   
   //DoorUnlock
   virtual tVoid sendDoorUnlockStatusStatus(tBool DoorUnlockconstate);
   virtual tBool onDoorUnlockStatusSet(tBool DoorUnlockconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual void vGetDoorUnlockStatusMsg(lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDoorUnlockStatusMsg(oStatus);}
   
   virtual tVoid vHandleMessage(lcmdbusclient_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendCurrentSourceStatus(lcmdbusclient_fi_tclString strSourceName);





   virtual void vGetCurrentSourceMsg(lcmdbusclient_mainfi_tclMsgCurrentSourceStatus& oStatus) {if (_poServerRef) _poServerRef->vGetCurrentSourceMsg(oStatus);}

private:
   Ilcmdbusclient_tclServiceLcmDbusClient* _poServerRef;

// lcmdbusclient_tclServiceLcmDbusClientIfDeclarationsPart2: user specific code start
// lcmdbusclient_tclServiceLcmDbusClientIfDeclarationsPart2: user specific code end

};

#endif // __lcmdbusclient_ServiceLcmDbusClientIf__IF__H_




