/*****************************************************************************
* FILE:         lcmdbusclient_ServiceLcmDbusClientIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: lcmdbusclient
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// lcmdbusclient_tclServiceLcmDbusClientIfIncludes: user specific code start
// lcmdbusclient_tclServiceLcmDbusClientIfIncludes: user specific code end

#include "lcmdbusclient_ServiceLcmDbusClientIf.h"
#include "I_lcmdbusclient_ServiceLcmDbusClient.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCMDBUSCLIENT_SERVER_LCMDBUSCLIENT
#include "trcGenProj/Header/lcmdbusclient_ServiceLcmDbusClientIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: lcmdbusclient_tclServiceLcmDbusClientIf::
*             lcmdbusclient_tclServiceLcmDbusClientIf(lcmdbusclient_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
lcmdbusclient_tclServiceLcmDbusClientIf::lcmdbusclient_tclServiceLcmDbusClientIf(lcmdbusclient_tclAppMain* poMainAppl) : 
Ilcmdbusclient_tclServiceLcmDbusClientIf(poMainAppl)
{
   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClientIf() entered."));
   _poServerRef = OSAL_NULL;

   // lcmdbusclient_tclServiceLcmDbusClientIfConstructor: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: lcmdbusclient_tclServiceLcmDbusClientIf::
*             ~lcmdbusclient_tclServiceLcmDbusClientIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
lcmdbusclient_tclServiceLcmDbusClientIf::~lcmdbusclient_tclServiceLcmDbusClientIf(tVoid)
{
   //ETG_TRACE_USR4(("~lcmdbusclient_tclServiceLcmDbusClientIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // lcmdbusclient_tclServiceLcmDbusClientIfDestructor: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'lcmdbusclient_ServiceLcmDbusClientIf.h':
*     Add forward declaration:
*         class Ilcmdbusclient_tclObject2Get;
*
*     Add declaration of object reference:
*         Ilcmdbusclient_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ilcmdbusclient_tclObject2Get*>(_cpoMain->getHandler("Ilcmdbusclient_tclObject2Get"));
*     LCMDBUSCLIENT_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vGetReferences(tVoid)
{
   //ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClientIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClient*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClient"));

   LCMDBUSCLIENT_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // lcmdbusclient_tclServiceLcmDbusClientIfvGetReferences: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vStartCommunication(tVoid)
{
   //ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClientIf::vStartCommunication() entered."));
   // lcmdbusclient_tclServiceLcmDbusClientIfvStartCommunication: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vHandleMessage(lcmdbusclient_tclBaseIf::TMsg* pMsg)
{
   //ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClientIf::vHandleMessage() entered %u -> data: %d.", //ETG_CENUM(lcmdbusclient_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // lcmdbusclient_tclServiceLcmDbusClientIfvHandleMessage: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vHandleTraceMessage(const tUChar* puchData)
{
   LCMDBUSCLIENT_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClientIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // lcmdbusclient_tclServiceLcmDbusClientIfvHandleTraceMessage: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vTraceInfo()
{
   // lcmdbusclient_tclServiceLcmDbusClientIfvTraceInfo: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClientIf::onServiceAvailable() entered."));

   // lcmdbusclient_tclServiceLcmDbusClientIfvOnServiceAvailable: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClientIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClientIf::onServiceUnavailable() entered."));
	
  // lcmdbusclient_tclServiceLcmDbusClientIfvOnServiceUnavailable: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientIfvOnServiceUnavailable: user specific code end
}
 tBool lcmdbusclient_tclServiceLcmDbusClientIf::onNanomsgStatusSet(tBool Nanomsgconstate, tBool& bPropertyChanged, tU16& u16ErrorCode)
 {
	tBool _bResult = FALSE;
	return _bResult;
 }

 tBool lcmdbusclient_tclServiceLcmDbusClientIf::onVoltagelevelStatusSet(tU8 Voltagelevelconstate, tBool& bPropertyChanged, tU16& u16ErrorCode)
 {
	tBool _bResult = FALSE;
	return _bResult;
 }

tBool lcmdbusclient_tclServiceLcmDbusClientIf::onCockpitmodeStatusSet(tU8 Cockpitmodeconstate, tBool& bPropertyChanged, tU16& u16ErrorCode)
 {
	tBool _bResult = FALSE;
	return _bResult;
 }
 tBool lcmdbusclient_tclServiceLcmDbusClientIf::onSubsystemerrorStatusSet(lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate, tBool& bPropertyChanged, tU16& u16ErrorCode)
 {
	tBool _bResult = FALSE;
	return _bResult;
 }
 tBool lcmdbusclient_tclServiceLcmDbusClientIf::onThermallevelStatusSet(tU16 Thermallevelconstate, tBool& bPropertyChanged, tU16& u16ErrorCode)
 {
	tBool _bResult = FALSE;
	return _bResult;
 }
 tBool lcmdbusclient_tclServiceLcmDbusClientIf::onDoorUnlockStatusSet(tBool DoorUnlockconstate, tBool& bPropertyChanged, tU16& u16ErrorCode)
 {
	tBool _bResult = FALSE;
	return _bResult;
 }
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::sendCurrentSourceStatus(lcmdbusclient_fi_tclString strSourceName) {
    //just forward send request
    LCMDBUSCLIENT_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCurrentSourceStatus(strSourceName);
}

tVoid lcmdbusclient_tclServiceLcmDbusClientIf::sendNanomsgStatusStatus(tBool Nanomsgconstate) {
	//just forward send request
    LCMDBUSCLIENT_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendNanomsgStatusStatus(Nanomsgconstate);
}
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::sendVoltagelevelStatusStatus(tU8 Voltagelevelconstate) {
	//just forward send request
    LCMDBUSCLIENT_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendVoltagelevelStatusStatus(Voltagelevelconstate);
}

tVoid lcmdbusclient_tclServiceLcmDbusClientIf::sendCockpitmodeStatusStatus(tU8 Cockpitmodeconstate) {
	//just forward send request
    LCMDBUSCLIENT_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCockpitmodeStatusStatus(Cockpitmodeconstate);
}

tVoid lcmdbusclient_tclServiceLcmDbusClientIf::sendSubsystemerrorStatusStatus(lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate) {
	//just forward send request
    LCMDBUSCLIENT_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSubsystemerrorStatusStatus(Subsystemerrorconstate);
}
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::sendThermallevelStatusStatus(tU16 Thermallevelconstate) {
	//just forward send request
    LCMDBUSCLIENT_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendThermallevelStatusStatus(Thermallevelconstate);
}
tVoid lcmdbusclient_tclServiceLcmDbusClientIf::sendDoorUnlockStatusStatus(tBool DoorUnlockconstate) {
	//just forward send request
    LCMDBUSCLIENT_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDoorUnlockStatusStatus(DoorUnlockconstate);
}


// lcmdbusclient_tclServiceLcmDbusClientIflcmdbusclient_ServiceLcmDbusClientIf: user specific code start
// lcmdbusclient_tclServiceLcmDbusClientIflcmdbusclient_ServiceLcmDbusClientIf: user specific code end

//EOF


