/*****************************************************************************
* FILE:         lcmdbusclient_ServiceLcmDbusClient.cpp
* PROJECT:      G3G project
* SW-COMPONENT: lcmdbusclient
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// lcmdbusclient_tclServiceLcmDbusClientIncludes: user specific code start
// lcmdbusclient_tclServiceLcmDbusClientIncludes: user specific code end

#include "lcmdbusclient_ServiceLcmDbusClient.h"
#include "lcmdbusclient_ServiceLcmDbusClientCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCMDBUSCLIENT_SERVER_LCMDBUSCLIENT
#include "trcGenProj/Header/lcmdbusclient_ServiceLcmDbusClient.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define LCMDBUSCLIENT_SERVICE_ID              215
#define LCMDBUSCLIENT_FI_MAJOR_VERSION        1
#define LCMDBUSCLIENT_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(lcmdbusclient_tclServiceLcmDbusClient, ahl_tclBaseWork)
ON_MESSAGE_SVCDATA(LCMDBUSCLIENT_MAINFI_C_U16_PNMGRP10SIGNALSTATUS,AMT_C_U8_CCAMSG_OPCODE_SET, vHandlePNMGRP10SignalStatus)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: lcmdbusclient_tclServiceLcmDbusClient::
*             lcmdbusclient_tclServiceLcmDbusClient(lcmdbusclient_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
lcmdbusclient_tclServiceLcmDbusClient::lcmdbusclient_tclServiceLcmDbusClient(lcmdbusclient_tclAppMain* poMainAppl) : 
Ilcmdbusclient_tclServiceLcmDbusClient(poMainAppl, LCMDBUSCLIENT_SERVICE_ID, LCMDBUSCLIENT_FI_MAJOR_VERSION, LCMDBUSCLIENT_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClient() entered."));
   _poCallbackIf = OSAL_NULL;
   
   _tNanomsgStatus_Nanomsgconstate = FALSE;
   _tVoltagelevelStatus_Voltagelevelconstate = 0;
    _tCockpitmodeStatus_Cockpitmodeconstate = 0;
	_tThermallevelStatus_Thermallevelconstate = 0;
	_tDoorUnlockStatus_DoorUnlockconstate = FALSE;
	
	_tSubsystemerrorStatus_Subsystemerrorconstate = {};
	
	 plcmdbusclient_tclNanomsgClienthandler = NULL ;
	

   // lcmdbusclient_tclServiceLcmDbusClientConstructor: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: lcmdbusclient_tclServiceLcmDbusClient::
*             ~lcmdbusclient_tclServiceLcmDbusClient(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
lcmdbusclient_tclServiceLcmDbusClient::~lcmdbusclient_tclServiceLcmDbusClient(tVoid)
{
   ETG_TRACE_USR4(("~lcmdbusclient_tclServiceLcmDbusClient() entered."));
    ETG_TRACE_FATAL(("Property support:      NanomsgStatus (LCMDBUSCLIENT_MAINFI_C_U16_NANOMSGSTATUS) -> Opcode: Get, Set, Status, Error, "));
    ETG_TRACE_FATAL(("Property support:      VoltagelevelStatus (LCMDBUSCLIENT_MAINFI_C_U16_VOLTAGELEVELSTATUS) -> Opcode: Get, Set, Status, Error, "));
	ETG_TRACE_FATAL(("Property support:      CockpitmodeStatus (LCMDBUSCLIENT_MAINFI_C_U16_COCKPITMODESTATUS) -> Opcode: Get, Set, Status, Error, "));
	ETG_TRACE_FATAL(("Property support:      SubsystemerrorStatus (LCMDBUSCLIENT_MAINFI_C_U16_SUBSYSTEMERRORSTATUS) -> Opcode: Get, Set, Status, Error, "));
	ETG_TRACE_FATAL(("Property support:      ThermallevelStatus (LCMDBUSCLIENT_MAINFI_C_U16_THERMALLEVELSTATUS) -> Opcode: Get, Set, Status, Error, "));
	ETG_TRACE_FATAL(("Property support:      DoorUnlockStatus (LCMDBUSCLIENT_MAINFI_C_U16_DOORUNLOCKSTATUS) -> Opcode: Get, Set, Status, Error, "));
   _poCallbackIf = OSAL_NULL;
    plcmdbusclient_tclNanomsgClienthandler = NULL ;
   
   // lcmdbusclient_tclServiceLcmDbusClientDestructor: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClient::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'lcmdbusclient_ServiceLcmDbusClient.h':
*     Add forward declaration:
*         class Ilcmdbusclient_tclObject2Get;
*
*     Add declaration of object reference:
*         Ilcmdbusclient_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ilcmdbusclient_tclObject2Get*>(_cpoMain->getHandler("Ilcmdbusclient_tclObject2Get"));
*     LCMDBUSCLIENT_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClient::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClient::vGetReferences() entered."));
   // lcmdbusclient_tclServiceLcmDbusClientvGetReferences: user specific code start
	plcmdbusclient_tclNanomsgClienthandler = dynamic_cast <INanomsgClienthandler *>(_cpoMain->getHandler("NanoMsgLCMInterface"));
	LCMDBUSCLIENT_NULL_POINTER_CHECK(plcmdbusclient_tclNanomsgClienthandler);
   // lcmdbusclient_tclServiceLcmDbusClientvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClient::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClient::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClient::vStartCommunication() entered."));
   // lcmdbusclient_tclServiceLcmDbusClientvStartCommunication: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClient::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   lcmdbusclient_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClient::vHandleMessage(lcmdbusclient_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClient::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(lcmdbusclient_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // lcmdbusclient_tclServiceLcmDbusClientvHandleMessage: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClient::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClient::vHandleTraceMessage(const tUChar* puchData)
{
   LCMDBUSCLIENT_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClient::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // lcmdbusclient_tclServiceLcmDbusClientvHandleTraceMessage: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClient::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClient::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      CurrentSource (LCMDBUSCLIENT_MAINFI_C_U16_CURRENTSOURCE) -> Opcode: Get, Status, Error, "));

   // lcmdbusclient_tclServiceLcmDbusClientvTraceInfo: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClient::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClient::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // lcmdbusclient_tclServiceLcmDbusClientvOnServiceAvailable: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcmdbusclient_tclServiceLcmDbusClient::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid lcmdbusclient_tclServiceLcmDbusClient::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // lcmdbusclient_tclServiceLcmDbusClientvOnServiceUnavailable: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientvOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool lcmdbusclient_tclServiceLcmDbusClient
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool lcmdbusclient_tclServiceLcmDbusClient
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClient:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case LCMDBUSCLIENT_MAINFI_C_U16_CURRENTSOURCE:
      {
         lcmdbusclient_mainfi_tclMsgCurrentSourceStatus oStatus;

         oStatus.strSourceName = _tCurrentSource_strSourceName;

         // CaseCurrentSourceStatus_Pre: user specific code start
         // CaseCurrentSourceStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUSCLIENT_FI_MAJOR_VERSION);

         // CaseCurrentSourceStatus: user specific code start
         // CaseCurrentSourceStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
	  
	 case LCMDBUSCLIENT_MAINFI_C_U16_NANOMSGSTATUS:
      {
         lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus oStatus;

         oStatus.Nanomsgconstate = _tNanomsgStatus_Nanomsgconstate;


         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUSCLIENT_FI_MAJOR_VERSION);

         // CaseNanomsgStatusStatus: user specific code start
         // CaseNanomsgStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

 	case LCMDBUSCLIENT_MAINFI_C_U16_VOLTAGELEVELSTATUS:
      {
         lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus oStatus;

         oStatus.Voltagelevelconstate = _tVoltagelevelStatus_Voltagelevelconstate;


         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUSCLIENT_FI_MAJOR_VERSION);

         // CaseVoltagelevelStatusStatus: user specific code start
         // CaseVoltagelevelStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
	  case LCMDBUSCLIENT_MAINFI_C_U16_COCKPITMODESTATUS:
      {
         lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus oStatus;

         oStatus.Cockpitmodeconstate = _tCockpitmodeStatus_Cockpitmodeconstate;


         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUSCLIENT_FI_MAJOR_VERSION);

         // CaseCockpitmodeStatusStatus: user specific code start
         // CaseCockpitmodeStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
	  case LCMDBUSCLIENT_MAINFI_C_U16_SUBSYSTEMERRORSTATUS:
      {
         lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus oStatus;

         oStatus.Subsystemerrorconstate = _tSubsystemerrorStatus_Subsystemerrorconstate;


         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUSCLIENT_FI_MAJOR_VERSION);

         // CaseSubsystemerrorStatusStatus: user specific code start
         // CaseSubsystemerrorStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
	  case LCMDBUSCLIENT_MAINFI_C_U16_THERMALLEVELSTATUS:
      {
         lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus oStatus;

         oStatus.Thermallevelconstate = _tThermallevelStatus_Thermallevelconstate;


         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUSCLIENT_FI_MAJOR_VERSION);

         // CaseThermallevelStatusStatus: user specific code start
         // CaseThermallevelStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
	  case LCMDBUSCLIENT_MAINFI_C_U16_DOORUNLOCKSTATUS:
      {
         lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus oStatus;

         oStatus.DoorUnlockconstate = _tDoorUnlockStatus_DoorUnlockconstate;


         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUSCLIENT_FI_MAJOR_VERSION);

         // CaseDoorUnlockStatusStatus: user specific code start
         // CaseDoorUnlockStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
     }
     break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool lcmdbusclient_tclServiceLcmDbusClient
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool lcmdbusclient_tclServiceLcmDbusClient
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClient:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {
	case LCMDBUSCLIENT_MAINFI_C_U16_NANOMSGSTATUS:
      {
         lcmdbusclient_mainfi_tclMsgNanomsgStatusSet oSet;

         if (oVisitorMsg.s32GetData(oSet, LCMDBUSCLIENT_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onNanomsgStatusSet(oSet.Nanomsgconstate, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onNanomsgStatusSet(oSet.Nanomsgconstate, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseNanomsgStatusSet: user specific code start
         // CaseNanomsgStatusSet: user specific code end

         oSet.vDestroy();
      }
      break;
      	case LCMDBUSCLIENT_MAINFI_C_U16_VOLTAGELEVELSTATUS:
      {
         lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet oSet;

         if (oVisitorMsg.s32GetData(oSet, LCMDBUSCLIENT_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onVoltagelevelStatusSet(oSet.Voltagelevelconstate, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onVoltagelevelStatusSet(oSet.Voltagelevelconstate, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseVoltagelevelStatusSet: user specific code start
         // CaseVoltagelevelStatusSet: user specific code end

         oSet.vDestroy();
      }
      break;
	  case LCMDBUSCLIENT_MAINFI_C_U16_COCKPITMODESTATUS:
      {
         lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet oSet;

         if (oVisitorMsg.s32GetData(oSet, LCMDBUSCLIENT_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onCockpitmodeStatusSet(oSet.Cockpitmodeconstate, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onCockpitmodeStatusSet(oSet.Cockpitmodeconstate, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseCockpitmodeStatusSet: user specific code start
         // CaseCockpitmodeStatusSet: user specific code end

         oSet.vDestroy();
      }
      break;
	  case LCMDBUSCLIENT_MAINFI_C_U16_SUBSYSTEMERRORSTATUS:
      {
         lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet oSet;

         if (oVisitorMsg.s32GetData(oSet, LCMDBUSCLIENT_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onSubsystemerrorStatusSet(oSet.Subsystemerrorconstate, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onSubsystemerrorStatusSet(oSet.Subsystemerrorconstate, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseCockpitmodeStatusSet: user specific code start
         // CaseCockpitmodeStatusSet: user specific code end

         oSet.vDestroy();
      }
      break;
	  case LCMDBUSCLIENT_MAINFI_C_U16_THERMALLEVELSTATUS:
      {
         lcmdbusclient_mainfi_tclMsgThermallevelStatusSet oSet;

         if (oVisitorMsg.s32GetData(oSet, LCMDBUSCLIENT_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onThermallevelStatusSet(oSet.Thermallevelconstate, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onThermallevelStatusSet(oSet.Thermallevelconstate, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseThermallevelStatusSet: user specific code start
         // CaseThermallevelStatusSet: user specific code end

         oSet.vDestroy();
      }
      break;
	  case LCMDBUSCLIENT_MAINFI_C_U16_DOORUNLOCKSTATUS:
      {
         lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet oSet;

         if (oVisitorMsg.s32GetData(oSet, LCMDBUSCLIENT_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDoorUnlockStatusSet(oSet.DoorUnlockconstate, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onDoorUnlockStatusSet(oSet.DoorUnlockconstate, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseDoorUnlockStatusSet: user specific code start
         // CaseDoorUnlockStatusSet: user specific code end

         oSet.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid lcmdbusclient_tclServiceLcmDbusClient::sendCurrentSourceStatus(lcmdbusclient_fi_tclString strSourceName)
{

   _tCurrentSource_strSourceName = strSourceName;


   ETG_TRACE_USR4(("sendCurrentSourceStatus() called."));
   eUpdateClients(LCMDBUSCLIENT_MAINFI_C_U16_CURRENTSOURCE);
}

tVoid lcmdbusclient_tclServiceLcmDbusClient::sendNanomsgStatusStatus(tBool Nanomsgconstate)
{

   _tNanomsgStatus_Nanomsgconstate = Nanomsgconstate;


   ETG_TRACE_USR4(("sendNanomsgStatusStatus() called."));
   eUpdateClients(LCMDBUSCLIENT_MAINFI_C_U16_NANOMSGSTATUS);
}

tVoid lcmdbusclient_tclServiceLcmDbusClient::sendVoltagelevelStatusStatus(tU8 Voltagelevelconstate)
{

   _tVoltagelevelStatus_Voltagelevelconstate = Voltagelevelconstate;

   	
   ETG_TRACE_USR4(("sendVoltagelevelStatusStatus() called."));
   eUpdateClients(LCMDBUSCLIENT_MAINFI_C_U16_VOLTAGELEVELSTATUS);
}

tVoid lcmdbusclient_tclServiceLcmDbusClient::sendCockpitmodeStatusStatus(tU8 Cockpitmodeconstate)
{

   _tCockpitmodeStatus_Cockpitmodeconstate = Cockpitmodeconstate;

   
   ETG_TRACE_USR4(("sendCockpitmodeStatusStatus() called."));
   eUpdateClients(LCMDBUSCLIENT_MAINFI_C_U16_COCKPITMODESTATUS);
}
tVoid lcmdbusclient_tclServiceLcmDbusClient::sendSubsystemerrorStatusStatus(lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate)
{

   _tSubsystemerrorStatus_Subsystemerrorconstate = Subsystemerrorconstate;

   std::vector<lcmdbusclient_fi_tclheDevInfo, std::allocator<lcmdbusclient_fi_tclheDevInfo> >::iterator it;
   for (it = Subsystemerrorconstate.SubsystemList.begin(); it != Subsystemerrorconstate.SubsystemList.end(); it++)
   {
	ETG_TRACE_USR4(("lcmdbusclient_tclServiceLcmDbusClient::sendSubsystemerrorStatusStatus devId=%d,devIP=%d,devError=%d",it->devId,it->devIP,it->devError));
   }
   ETG_TRACE_USR4(("sendSubsystemerrorStatusStatus() called."));
   eUpdateClients(LCMDBUSCLIENT_MAINFI_C_U16_SUBSYSTEMERRORSTATUS);
}
tVoid lcmdbusclient_tclServiceLcmDbusClient::sendThermallevelStatusStatus(tU16 Thermallevelconstate)
{

   _tThermallevelStatus_Thermallevelconstate = Thermallevelconstate;


   ETG_TRACE_USR4(("sendThermallevelStatusStatus() called."));
   eUpdateClients(LCMDBUSCLIENT_MAINFI_C_U16_THERMALLEVELSTATUS);
}
tVoid lcmdbusclient_tclServiceLcmDbusClient::sendDoorUnlockStatusStatus(tBool DoorUnlockconstate)
{

   _tDoorUnlockStatus_DoorUnlockconstate = DoorUnlockconstate;


   ETG_TRACE_USR4(("sendDoorUnlockStatusStatus() called."));
   eUpdateClients(LCMDBUSCLIENT_MAINFI_C_U16_DOORUNLOCKSTATUS);
}
tBool lcmdbusclient_tclServiceLcmDbusClient::onNanomsgStatusSet(tBool Nanomsgconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)Nanomsgconstate;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onNanomsgStatusSet: user specific code start
   // onNanomsgStatusSet: user specific code end
   return _bResult;
}
tBool lcmdbusclient_tclServiceLcmDbusClient::onVoltagelevelStatusSet(tU8 Voltagelevelconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tU8)Voltagelevelconstate;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onVoltagelevelStatusSet: user specific code start
   // onVoltagelevelStatusSet: user specific code end
   return _bResult;
}
tBool lcmdbusclient_tclServiceLcmDbusClient::onCockpitmodeStatusSet(tU8 Cockpitmodeconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tU8)Cockpitmodeconstate;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onCockpitmodeStatusSet: user specific code start
   // onCockpitmodeStatusSet: user specific code end
   return _bResult;
}

tBool lcmdbusclient_tclServiceLcmDbusClient::onSubsystemerrorStatusSet(lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (lcmdbusclient_fi_tclheSubsystemList)Subsystemerrorconstate;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onSubsystemerrorStatusSet: user specific code start
   // onSubsystemerrorStatusSet: user specific code end
   return _bResult;
}
tBool lcmdbusclient_tclServiceLcmDbusClient::onThermallevelStatusSet(tU16 Thermallevelconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tU16)Thermallevelconstate;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onThermallevelStatusSet: user specific code start
   // onThermallevelStatusSet: user specific code end
   return _bResult;
}
tBool lcmdbusclient_tclServiceLcmDbusClient::onDoorUnlockStatusSet(tBool DoorUnlockconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)DoorUnlockconstate;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDoorUnlockStatusSet: user specific code start
   // onDoorUnlockStatusSet: user specific code end
   return _bResult;
}

tVoid lcmdbusclient_tclServiceLcmDbusClient::vHandlePNMGRP10SignalStatus(amt_tclServiceData *poMessage)
{
	ETG_TRACE_USR4( ( "lcmdbusclient_tclServiceLcmDbusClient::vHandlePNMGRP10SignalStatus") );
	if (poMessage != NULL)
	{
		if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_SET )
		{
			fi_tclVisitorMessage  oInMsg(poMessage);
			lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus onPNMGRP10SignalStatus;
			if (oInMsg.s32GetData(onPNMGRP10SignalStatus,LCMDBUSCLIENT_FI_MAJOR_VERSION) != OSAL_ERROR)
			{
				tU8 PNMGRP10SignalStateVal     = onPNMGRP10SignalStatus.PNMGRP10Signalstate;
				ETG_TRACE_USR4( ( "lcmdbusclient_tclServiceLcmDbusClient::vHandlePNMGRP10SignalStatus %u",onPNMGRP10SignalStatus.PNMGRP10Signalstate));
				if(NULL != plcmdbusclient_tclNanomsgClienthandler)
				{
					ETG_TRACE_USR4(( "lcmdbusclient_tclServiceLcmDbusClient()::vHandlePNMGRP10SignalStatus  vHandleSystemStates Calling"));
					plcmdbusclient_tclNanomsgClienthandler->vHandlePNMGRP10status(PNMGRP10SignalStateVal);
				}
			}
			onPNMGRP10SignalStatus.vDestroy();
		}
	}
}
// lcmdbusclient_tclServiceLcmDbusClientlcmdbusclient_ServiceLcmDbusClient: user specific code start
// lcmdbusclient_tclServiceLcmDbusClientlcmdbusclient_ServiceLcmDbusClient: user specific code end

//EOF




