/**************************************************************************************
* @file         : <XMLReader.h>
* @author       : <Madhureeben> <ECG> <INF4CV>
* @brief        :
* @copyright    : (C) 2019 Robert Bosch GmbH
*                 (C) 2019 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef READ_XMLReader
#define READ_XMLReader

#include <map>
#include <vector>
#include <string>
#include <cstring>
#include <cstdlib>
#include "tinystr.h"
#include "tinyxml.h"
#include "EntityData.h"
#include <stdint.h>
#include <map>

#define COACHMEDIA_AMPLIFIER    "CMA1"
#define COACHMEDIA_GLASS       "CMG"
#define COACHMEDIA_CAMERAPORT_1 "CCP1"
#define COACHMEDIA_INVALID    "INVALID"

using namespace std;


class XMLReader
{
   public:
	  static XMLReader* GetInstance();
      virtual ~XMLReader();
      bool FetchResults();
	  bool getParsed();
	  std::vector<EntityData*> m_entityData;
	  
   private:
      XMLReader();
	  static XMLReader* m_XMLReader;
	  uint64_t m_entityId;
	  uint8_t m_devId;
	  uint8_t m_devNr;
	  std::string m_entityName;
	  std::string m_entityMac;
      std::string m_entityIp;
      void GetInfo(TiXmlNode*);
      void ExtractInfo(TiXmlElement* pElement);
      void processNameAndID(const char* pAttribValue);
	  void processDevNr(std::string ip);
	  void storeEntity();
      TiXmlDocument _xmlDoc;
      const char* m_lastAttri;
      bool parsed;
	  void printVector();
};






#endif
