/*****************************************************************************
 * @file:         lcmdbusclient_ClientAudio.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: lcmdbusclient
 * @Template:     DBusProxy.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          Franca interface file
 *
 *          Do manual changes only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end 
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2019 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// lcmdbusclient_ClientAudioIncludePart: user specific code start
#include "I_lcmdbusclient_ServiceLcmDbusClientIf.h"

#define STATE_CONNECTED         1
// lcmdbusclient_ClientAudioIncludePart: user specific code end

#include "lcmdbusclient_ClientAudio.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCMDBUSCLIENT_CLIENT_AUDIO
#include "trcGenProj/Header/lcmdbusclient_ClientAudio.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::org::genivi::audiomanager::CommandInterface;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/lcmdbusclient/lcmdbusclient_tclClientAudio", lcmdbusclient_tclClientAudio, Info);


lcmdbusclient_tclClientAudio::lcmdbusclient_tclClientAudio(lcmdbusclient_tclAppMain* baseRef)
   : Ilcmdbusclient_tclClientAudio(baseRef)
   , _bSrvAvailable(FALSE)
   , _AudioProxy(CommandInterfaceProxy::createProxy("audioFiPort", * this) )
{
   LOG_INFO("Constructor for lcmdbusclient_tclClientAudio called");
   ETG_TRACE_USR1( ( "Constructor for lcmdbusclient_tclClientAudio called" ) );
   
   // lcmdbusclient_ClientAudiolcmdbusclient_tclClientAudio: user specific code start
   // lcmdbusclient_ClientAudiolcmdbusclient_tclClientAudio: user specific code end
}

lcmdbusclient_tclClientAudio::~lcmdbusclient_tclClientAudio(){
   LOG_INFO("~lcmdbusclient_tclClientAudio called");
   ETG_TRACE_USR1( ( "~lcmdbusclient_tclClientAudio called" ) );
   // lcmdbusclient_tclClientAudiolcmdbusclient_tclClientAudioDest: user specific code start
   // lcmdbusclient_tclClientAudiolcmdbusclient_tclClientAudioDest: user specific code end
   
}

void lcmdbusclient_tclClientAudio::onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;

   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onAvailable(): CALLED" ) );
   if (_AudioProxy == proxy){
      ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio : onAvailable _AudioProxy " ) );
      _AudioProxy->sendNumberOfMainConnectionsChangedRegister(* this);
      _AudioProxy->sendNewMainConnectionRegister(* this);
      _AudioProxy->sendMainConnectionStateChangedRegister(* this);
      _bSrvAvailable = TRUE;
   }
   // lcmdbusclient_ClientAudioonAvailable: user specific code start
   _AudioProxy->sendGetListMainSourcesRequest(* this);
   _AudioProxy->sendGetListMainConnectionsRequest(*this);
   // lcmdbusclient_ClientAudioonAvailable: user specific code end
}

void lcmdbusclient_tclClientAudio::onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onUnavailable(): CALLED" ) );
   if (_AudioProxy == proxy){
      _bSrvAvailable = FALSE;
      ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio : onUnavailable _AudioProxy " ) );
      _AudioProxy->sendNumberOfMainConnectionsChangedDeregister(0);
      _AudioProxy->sendNewMainConnectionDeregister(0);
      _AudioProxy->sendMainConnectionStateChangedDeregister(0);

   }
   // lcmdbusclient_ClientAudioonUnavailable: user specific code start
   // lcmdbusclient_ClientAudioonUnavailable: user specific code end

}

// TimerCallbackIF
void lcmdbusclient_tclClientAudio::onExpired(asf::core::Timer& timer, boost::shared_ptr <asf::core::TimerPayload> payload){
   // lcmdbusclient_ClientAudioonExpired: user specific code start
   (tVoid)timer;
   (tVoid)payload;
   // lcmdbusclient_ClientAudioonExpired: user specific code end
}

void lcmdbusclient_tclClientAudio::onGetListMainConnectionsError(const::boost::shared_ptr <CommandInterfaceProxy>  & proxy, const boost::shared_ptr <GetListMainConnectionsError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onGetListMainConnectionsError(): CALLED" ) );
   // lcmdbusclient_ClientAudioonGetListMainConnectionsError: user specific code start
   // lcmdbusclient_ClientAudioonGetListMainConnectionsError: user specific code end
}
void lcmdbusclient_tclClientAudio::onGetListMainConnectionsResponse(const::boost::shared_ptr <CommandInterfaceProxy> & proxy, const boost::shared_ptr <GetListMainConnectionsResponse>& response){
   (tVoid)proxy;
   (tVoid)response;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onGetListMainConnectionsResponse(): CALLED" ) );
   // lcmdbusclient_ClientAudioonGetListMainConnectionsResponse: user specific code start
   ::std::vector< GetListMainConnectionsResponseListConnectionsStruct > ConnList = response->getListConnections();
   ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >::iterator it;

   ETG_TRACE_FATAL(("-----------Connection list begin---------"));
   for (it = ConnList.begin() ; it != ConnList.end(); it++)
   {
       ETG_TRACE_FATAL(("Connection ID : %d", it->getElem2()));
       ETG_TRACE_FATAL(("Connection state : %d", it->getElem5()));
       if (it->getElem5() == STATE_CONNECTED) {
           if (_MappingTable.end() != _MappingTable.find(it->getElem2())) {
               Ilcmdbusclient_tclServiceLcmDbusClientIf* pSrv = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClientIf*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClientIf"));
               if (pSrv) {
                   lcmdbusclient_fi_tclString strSourceName = _MappingTable.find(it->getElem2())->second.c_str();
                   pSrv->sendCurrentSourceStatus(strSourceName);
               }
           }
       }
   }
   ETG_TRACE_FATAL(("-----------Connection list End---------"));



   // lcmdbusclient_ClientAudioonGetListMainConnectionsResponse: user specific code end
}

void lcmdbusclient_tclClientAudio::onGetListMainSourcesError(const::boost::shared_ptr <CommandInterfaceProxy>  & proxy, const boost::shared_ptr <GetListMainSourcesError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onGetListMainSourcesError(): CALLED" ) );
   // lcmdbusclient_ClientAudioonGetListMainSourcesError: user specific code start
   // lcmdbusclient_ClientAudioonGetListMainSourcesError: user specific code end
}
void lcmdbusclient_tclClientAudio::onGetListMainSourcesResponse(const::boost::shared_ptr <CommandInterfaceProxy> & proxy, const boost::shared_ptr <GetListMainSourcesResponse>& response){
   (tVoid)proxy;
   (tVoid)response;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onGetListMainSourcesResponse(): CALLED" ) );
   // lcmdbusclient_ClientAudioonGetListMainSourcesResponse: user specific code start

   ::std::vector< GetListMainSourcesResponseListMainSourcesStruct > SrcList = response->getListMainSources();
   ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >::iterator it;
   ::std::string sSrcName = "";
   int nSrcID = 0;

   for (it = SrcList.begin(); it != SrcList.end(); it++) {
      nSrcID = it->getElem1();
      sSrcName.assign(it->getElem2());
      _MappingTable.insert(std::pair<int, std::string> (nSrcID,sSrcName));
   }

   ETG_TRACE_FATAL( ( "------------------ Audio source ID to string list BEGIN :---------------------------- "));
   std::map<int, std::string>::iterator itr;
   for (itr = _MappingTable.begin() ;itr!= _MappingTable.end() ;itr++)
   {
       ETG_TRACE_FATAL(( "ID : %d  |  SourceName : %s",itr->first,itr->second.c_str()));
   }
   ETG_TRACE_FATAL( ( "-------------------Audio source ID to string list END :------------------------------- "));

   // lcmdbusclient_ClientAudioonGetListMainSourcesResponse: user specific code end
}

void lcmdbusclient_tclClientAudio::onNumberOfMainConnectionsChangedError(const::boost::shared_ptr <CommandInterfaceProxy>  & proxy, const boost::shared_ptr <NumberOfMainConnectionsChangedError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onNumberOfMainConnectionsChangedError(): CALLED" ) );
   // lcmdbusclient_ClientAudioonNumberOfMainConnectionsChangedError: user specific code start
   // lcmdbusclient_ClientAudioonNumberOfMainConnectionsChangedError: user specific code end
}
void lcmdbusclient_tclClientAudio::onNumberOfMainConnectionsChangedSignal(const::boost::shared_ptr <CommandInterfaceProxy> & proxy, const boost::shared_ptr <NumberOfMainConnectionsChangedSignal>& signal){
   (tVoid)proxy;
   (tVoid)signal;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onNumberOfMainConnectionsChangedSignal(): CALLED" ) );
   // lcmdbusclient_ClientAudioonNumberOfMainConnectionsChangedSignal: user specific code start
   if (_AudioProxy) _AudioProxy->sendGetListMainConnectionsRequest(*this);
   // lcmdbusclient_ClientAudioonNumberOfMainConnectionsChangedSignal: user specific code end
}

void lcmdbusclient_tclClientAudio::onNewMainConnectionError(const::boost::shared_ptr <CommandInterfaceProxy>  & proxy, const boost::shared_ptr <NewMainConnectionError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onNewMainConnectionError(): CALLED" ) );
   // lcmdbusclient_ClientAudioonNewMainConnectionError: user specific code start
   // lcmdbusclient_ClientAudioonNewMainConnectionError: user specific code end
}
void lcmdbusclient_tclClientAudio::onNewMainConnectionSignal(const::boost::shared_ptr <CommandInterfaceProxy> & proxy, const boost::shared_ptr <NewMainConnectionSignal>& signal){
   (tVoid)proxy;
   (tVoid)signal;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onNewMainConnectionSignal(): CALLED" ) );
   // lcmdbusclient_ClientAudioonNewMainConnectionSignal: user specific code start
   if (_AudioProxy) _AudioProxy->sendGetListMainConnectionsRequest(*this);
   // lcmdbusclient_ClientAudioonNewMainConnectionSignal: user specific code end
}

void lcmdbusclient_tclClientAudio::onMainConnectionStateChangedError(const::boost::shared_ptr <CommandInterfaceProxy>  & proxy, const boost::shared_ptr <MainConnectionStateChangedError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onMainConnectionStateChangedError(): CALLED" ) );
   // lcmdbusclient_ClientAudioonMainConnectionStateChangedError: user specific code start
   // lcmdbusclient_ClientAudioonMainConnectionStateChangedError: user specific code end
}
void lcmdbusclient_tclClientAudio::onMainConnectionStateChangedSignal(const::boost::shared_ptr <CommandInterfaceProxy> & proxy, const boost::shared_ptr <MainConnectionStateChangedSignal>& signal){
   (tVoid)proxy;
   (tVoid)signal;
   ETG_TRACE_USR1( ( "lcmdbusclient_tclClientAudio::onMainConnectionStateChangedSignal(): CALLED" ) );
   // lcmdbusclient_ClientAudioonMainConnectionStateChangedSignal: user specific code start
   // lcmdbusclient_ClientAudioonMainConnectionStateChangedSignal: user specific code end
}



tVoid lcmdbusclient_tclClientAudio::vHandleMessage(lcmdbusclient_tclBaseIf::TMsg* pMsg) {
   // lcmdbusclient_ClientAudiovHandleMessage: user specific code start
   (tVoid)pMsg;
   // lcmdbusclient_ClientAudiovHandleMessage: user specific code end
}

tVoid lcmdbusclient_tclClientAudio::vGetReferences() {
   // lcmdbusclient_ClientAudiovGetReferences: user specific code start
   // lcmdbusclient_ClientAudiovGetReferences: user specific code end
}

tVoid lcmdbusclient_tclClientAudio::vStartCommunication() {
   // lcmdbusclient_ClientAudiovStartCommunication: user specific code start
   // lcmdbusclient_ClientAudiovStartCommunication: user specific code end
}

tVoid lcmdbusclient_tclClientAudio::vTraceInfo() {
   // lcmdbusclient_ClientAudiovTraceInfo: user specific code start
   // lcmdbusclient_ClientAudiovTraceInfo: user specific code end
}

// lcmdbusclient_ClientAudioDefinitioPart: user specific code start
// lcmdbusclient_ClientAudioDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {

