
#ifndef _LCMDBUSCLIENT_CLIENTSPM_H
#define _LCMDBUSCLIENT_CLIENTSPM_H

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"

#include "SPM_CORE_FIProxy.h"

#include "asf/stream/MemoryStream.h"

#include "Ilcmdbusclient_ClientSpm.h"

// lcmdbusclient_ClientSpmInclude: user specific code start
// lcmdbusclient_ClientSpmInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::SPM_CORE_FI;
    using namespace::asf::core;
    using namespace::org::bosch::cm::lcmdbusclient;

    // lcmdbusclient_Server__SERVER_NAME__NameSpace: user specific code start
    // lcmdbusclient_Server__SERVER_NAME__NameSpace: user specific code end

    class lcmdbusclient_tclClientSpm : public Ilcmdbusclient_tclClientSpm
        , public ServiceAvailableIF
        , public SysPwrModeCallbackIF
        , public SystemStateCallbackIF
        , public SubStatesCallbackIF
    {
    private:
        DECLARE_CLASS_LOGGER();

        tBool _bSrvAvailable;
		::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES u32SystemState ;
    public:
        lcmdbusclient_tclClientSpm(lcmdbusclient_tclAppMain* baseRef);
        virtual ~lcmdbusclient_tclClientSpm();

        // ServiceAvailableIF
        virtual void onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        virtual void onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        // SysPwrModeCallbackIF
        virtual void onSysPwrModeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysPwrModeError >& error);
        virtual void onSysPwrModeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysPwrModeStatus >& status);

        // SystemStateCallbackIF
        virtual void onSystemStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SystemStateError >& error);
        virtual void onSystemStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SystemStateStatus >& status);

        // SubStatesCallbackIF
        virtual void onSubStatesError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SubStatesError >& error);
        virtual void onSubStatesStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SubStatesStatus >& status);

    private:

        ::boost::shared_ptr <SPM_CORE_FIProxy> _SpmProxy;

    public:
        virtual const tChar* getName() const { return "lcmdbusclient_tclClientSpm"; }

        virtual tVoid vHandleMessage(lcmdbusclient_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* puchData) {} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        virtual tVoid sendSystemStateGet();
        virtual tVoid sendSubStatesSet(::spm_core_fi_types::T_SPM_e32_SubStateType subStateType, tBool subStateData);
        virtual tVoid sendSubStatesGet();
        virtual tVoid sendSysPwrModeGet();

        // lcmdbusclient_ClientSpmDeclarationsPart: user specific code start
		virtual ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES getSpmSystemState(tVoid){
			return u32SystemState;
		} 
        // lcmdbusclient_ClientSpmDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {

#endif // ifndef _LCMDBUSCLIENT_CLIENTSPM_H
