// lcmdbusclient_ClientSpmIncludePart: user specific code start
// lcmdbusclient_ClientSpmIncludePart: user specific code end

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "lcmdbusclient_ClientSpm.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCMDBUSCLIENT_SERVER_LCMDBUSCLIENT
#include "trcGenProj/Header/lcmdbusclient_ClientSpm.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::SPM_CORE_FI;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/Lcmdbusclient/lcmdbusclient_tclClientSpm", lcmdbusclient_tclClientSpm, Info);


lcmdbusclient_tclClientSpm::lcmdbusclient_tclClientSpm(lcmdbusclient_tclAppMain* baseRef)
   : Ilcmdbusclient_tclClientSpm(baseRef)
   , _bSrvAvailable(FALSE)
   , _SpmProxy(SPM_CORE_FIProxy::createProxy("spmFiPort", * this) )
{
  // LOG_INFO("Constructor for lcmdbusclient_tclClientSpm called");
   ETG_TRACE_FATAL(( "Constructor for lcmdbusclient_tclClientSpm called" ));
   u32SystemState = ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_BACKGROUND;
   plcmdbusclient_tclNanomsgClienthandler = NULL ;
   // lcmdbusclient_ClientSpmlcmdbusclient_tclClientSpm: user specific code start
   // lcmdbusclient_ClientSpmlcmdbusclient_tclClientSpm: user specific code end
}

lcmdbusclient_tclClientSpm::~lcmdbusclient_tclClientSpm(){
   //LOG_INFO("~lcmdbusclient_tclClientSpm called");
  ETG_TRACE_FATAL( ( "~lcmdbusclient_tclClientSpm called" ) );
  plcmdbusclient_tclNanomsgClienthandler = NULL ;
}

void lcmdbusclient_tclClientSpm::onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;

	ETG_TRACE_FATAL( ( "lcmdbusclient_tclClientSpm::onAvailable(): CALLED" ) );
   if (_SpmProxy == proxy){
	  ETG_TRACE_FATAL( ( "lcmdbusclient_tclClientSpm : onAvailable _SpmProxy " ) );
      _SpmProxy->sendSysPwrModeUpReg(* this);
      _SpmProxy->sendSystemStateUpReg(* this);
      _SpmProxy->sendSubStatesUpReg(* this);

      // !!! Any UpReg's with parameter will not be generated --> parameter value are specific !!!

      // lcmdbusclient_ClientSpmonAvailableUpregParam: user specific code start
      // lcmdbusclient_ClientSpmonAvailableUpregParam: user specific code end

      _bSrvAvailable = TRUE;
   }
   // lcmdbusclient_ClientSpmonAvailable: user specific code start
   // lcmdbusclient_ClientSpmonAvailable: user specific code end
}

void lcmdbusclient_tclClientSpm::onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;
   ETG_TRACE_FATAL( ( "lcmdbusclient_tclClientSpm::onUnavailable(): CALLED" ) );
   if (_SpmProxy == proxy){
      _bSrvAvailable = FALSE;
      ETG_TRACE_FATAL( ( "lcmdbusclient_tclClientSpm : onUnavailable _SpmProxy " ) );
   }
   // lcmdbusclient_ClientSpmonUnavailable: user specific code start
   // lcmdbusclient_ClientSpmonUnavailable: user specific code end

}

void lcmdbusclient_tclClientSpm::onSysPwrModeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SysPwrModeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   //ETG_TRACE_USR1( ( "lcmdbusclient_tclClientSpm::onSysPwrModeError(): CALLED" ) );
   // lcmdbusclient_ClientSpmonSysPwrModeError: user specific code start
   // lcmdbusclient_ClientSpmonSysPwrModeError: user specific code end
}

void lcmdbusclient_tclClientSpm::onSysPwrModeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SysPwrModeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   //ETG_TRACE_USR1( ( "lcmdbusclient_tclClientSpm::onSysPwrModeStatus(): CALLED" ) );

   // lcmdbusclient_ClientSpmonSysPwrModeStart: user specific code start
   // lcmdbusclient_ClientSpmonSysPwrModeStart: user specific code end
}

void lcmdbusclient_tclClientSpm::onSystemStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SystemStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   //ETG_TRACE_USR1( ( "lcmdbusclient_tclClientSpm::onSystemStateError(): CALLED" ) );
   // lcmdbusclient_ClientSpmonSystemStateError: user specific code start
   // lcmdbusclient_ClientSpmonSystemStateError: user specific code end
}

void lcmdbusclient_tclClientSpm::onSystemStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SystemStateStatus>& status){

   (tVoid)proxy;
   ETG_TRACE_FATAL( ( "lcmdbusclient_tclClientSpm::onSystemStateStatus(): CALLED" ) );

   // lcmdbusclient_ClientSpmonSystemStateStart: user specific code start
   if(!status)
	{
		return;
	}
	uint8 eSPM_e32_SYSTEM_STATES = status->getSystemState();
	ETG_TRACE_FATAL(( "lcmdbusclient_tclClientSpm():onSystemStateStatus...%d", (uint8)eSPM_e32_SYSTEM_STATES));
    if(NULL != plcmdbusclient_tclNanomsgClienthandler)
    {
		ETG_TRACE_FATAL(( "lcmdbusclient_tclClientSpm()::onSystemStateStatus  vHandleSystemStates Calling"));
        plcmdbusclient_tclNanomsgClienthandler->vHandleSystemStates(eSPM_e32_SYSTEM_STATES);            
    }
   // lcmdbusclient_ClientSpmonSystemStateStart: user specific code end
}

void lcmdbusclient_tclClientSpm::onSubStatesError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SubStatesError>& error){
   (tVoid)proxy;
   (tVoid)error;
   //ETG_TRACE_USR1( ( "lcmdbusclient_tclClientSpm::onSubStatesError(): CALLED" ) );
   // lcmdbusclient_ClientSpmonSubStatesError: user specific code start
   // lcmdbusclient_ClientSpmonSubStatesError: user specific code end
}

void lcmdbusclient_tclClientSpm::onSubStatesStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SubStatesStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   // ::spm_core_fi_types::T_SPM_e32_SubStateType subStateType;
   //ETG_TRACE_USR1( ( "lcmdbusclient_tclClientSpm::onSubStatesStatus(): CALLED" ) );
    //subStateType = status->getSubStateType();
	//if( subStateType == SPM_U32_DEMAND_AUDIO_MUTE )
   // lcmdbusclient_ClientSpmonSubStatesStart: user specific code start
   // lcmdbusclient_ClientSpmonSubStatesStart: user specific code end
}


tVoid lcmdbusclient_tclClientSpm::vHandleMessage(lcmdbusclient_tclBaseIf::TMsg* pMsg) {
   // lcmdbusclient_ClientSpmvHandleMessage: user specific code start
   // lcmdbusclient_ClientSpmvHandleMessage: user specific code end
}

tVoid lcmdbusclient_tclClientSpm::vGetReferences() {
   // lcmdbusclient_ClientSpmvGetReferences: user specific code start
    plcmdbusclient_tclNanomsgClienthandler = dynamic_cast <INanomsgClienthandler *>(_cpoMain->getHandler("NanoMsgLCMInterface"));
	LCMDBUSCLIENT_NULL_POINTER_CHECK(plcmdbusclient_tclNanomsgClienthandler);
   // lcmdbusclient_ClientSpmvGetReferences: user specific code end
}

tVoid lcmdbusclient_tclClientSpm::vStartCommunication() {
   // lcmdbusclient_ClientSpmvStartCommunication: user specific code start
   // lcmdbusclient_ClientSpmvStartCommunication: user specific code end
}

tVoid lcmdbusclient_tclClientSpm::vTraceInfo() {
   // lcmdbusclient_ClientSpmvTraceInfo: user specific code start
   // lcmdbusclient_ClientSpmvTraceInfo: user specific code end
}

tVoid lcmdbusclient_tclClientSpm::sendSystemStateGet() {
    if (_SpmProxy) _SpmProxy->sendSystemStateGet(* this);
}
tVoid lcmdbusclient_tclClientSpm::sendSubStatesSet(::spm_core_fi_types::T_SPM_e32_SubStateType subStateType, tBool subStateData) {
    if (_SpmProxy) _SpmProxy->sendSubStatesSet(* this, subStateType, subStateData);
}
tVoid lcmdbusclient_tclClientSpm::sendSubStatesGet() {
    if (_SpmProxy) _SpmProxy->sendSubStatesGet(* this);
}
tVoid lcmdbusclient_tclClientSpm::sendSysPwrModeGet() {
    if (_SpmProxy) _SpmProxy->sendSysPwrModeGet(* this);
}

// lcmdbusclient_ClientSpmDefinitioPart: user specific code start
// lcmdbusclient_ClientSpmDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {
