/*!
  * \file  spm_SystemStateManagerBase_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2019 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclSystemStateManagerBase_include_ext: user specific code start
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

// my class header
#include "spm_SystemStateManager.h"
#include "spm_SubStateHandler.h"
// spm_tclSystemStateManagerBase_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_SystemStateManagerBase_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclSystemStateManagerBase_include_spm: user specific code start
// spm_tclSystemStateManagerBase_include_spm: user specific code end


tVoid spm_tclSystemStateManagerBase::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_GETSTANDBYTIME:
      {
         // Returns the standby time in ms.

         // GetStandbyTime: user specific code start
         ETG_TRACE_FATAL( ( "Standby time: %d sec", u32GetStateTime(spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY) / 1000 ) );
         // GetStandbyTime: user specific code end
      }
      break;

      case SPM_GETSTANDBYPERSTIME:
      {
         // Returns the persistent stored StandbyTime [in ms].

         // GetStandbyPersTime: user specific code start
         dp_tclSpmDpConfigDevStandbyTime oStandbyTime;
         tU32                            u32Param;
         oStandbyTime >> u32Param;
         ETG_TRACE_FATAL( ( "Persitent stored standby time: %d sec", u32Param ) );
         // GetStandbyPersTime: user specific code end
      }
      break;

      case SPM_GETSUSPENDTIME:
      {
         // n.a.

         // GetSuspendTime: user specific code start
         // GetSuspendTime: user specific code end
      }
      break;

      case SPM_GETDOOROPENTIME:
      {

         // GetDoorOpenTime: user specific code start
         // GetDoorOpenTime: user specific code end
      }
      break;

      case SPM_GETCLOCKDISPLAYTIME:
      {

         // GetClockDisplayTime: user specific code start
         // GetClockDisplayTime: user specific code end
      }
      break;

      case SPM_GETCURRENTSYSTEMSTATE:
      {

         // GetCurrentSystemState: user specific code start
         ETG_TRACE_FATAL( ( "SystemStateInfo: current systemstate %u", ETG_ENUM(SPM_SYSTEM_STATES, u32GetSystemState() ) ) );
         // GetCurrentSystemState: user specific code end
      }
      break;

      case SPM_SETSTANDBYTIME:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SetStandbyTime' was called: param1 = 0x%x", param1 ) );

         // SetStandbyTime: user specific code start
         vSetStateTime(spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY, param1 * 1000);
         // SetStandbyTime: user specific code end
      }
      break;

      case SPM_SETSTANDBYPERSTIME:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SetStandbyPersTime' was called: param1 = 0x%x", param1 ) );

         // SetStandbyPersTime: user specific code start
         vSetStateTime(spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY, param1 * 1000);
         dp_tclSpmDpConfigDevStandbyTime oStandbyTime;
         oStandbyTime << param1;
         // oStandbyTime.vSetData(param1);
         // SetStandbyPersTime: user specific code end
      }
      break;

      case SPM_SETSUSPENDTIME:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SetSuspendTime' was called: param1 = 0x%x", param1 ) );

         // SetSuspendTime: user specific code start
            ETG_TRACE_FATAL( ( "SystemStateInfo: Suspend mode is not supported -> %d", param1 ) );
         // SetSuspendTime: user specific code end
      }
      break;

      case SPM_SETDOOROPENTIME:
      {
         // DoorOpen time is set in min.
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SetDoorOpenTime' was called: param1 = 0x%x", param1 ) );

         // SetDoorOpenTime: user specific code start
         dp_tclSpmDpConfigDoorOpenTime oDoorTime;
         oDoorTime.vSetData(param1 * 60);
         // SetDoorOpenTime: user specific code end
      }
      break;

      case SPM_SETCLOCKDISPLAYTIME:
      {
         // ClockDisplay time is set in min.
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SetClockDisplayTime' was called: param1 = 0x%x", param1 ) );

         // SetClockDisplayTime: user specific code start
         dp_tclSpmDpConfigClockDisplayTime oClckDisplay;
         oClckDisplay.vSetData(param1 * 60);
         // SetClockDisplayTime: user specific code end
      }
      break;

      case SPM_SPMSYSSTATEHISTORY:
      {
         // Trace a list of the last system state changes.

         // SpmSysStateHistory: user specific code start
         TSysStateHistoryList::iterator pos;
         for (pos = _oHistoryList.begin(); pos != _oHistoryList.end(); ++pos){
            tU32 u32Duration = 0;
            if (pos->u32TimeStampReached > pos->u32TimeStampStart){
               u32Duration = pos->u32TimeStampReached - pos->u32TimeStampStart;
            }
            ETG_TRACE_FATAL( ( "SysStateHistory: Triggered at %d:%02d:%02d (TS: %d), Duration %d ms, Transition ID: %d",
                               ( pos->u32TimeStampStart / 1000 / 60 / 60 ),
                               ( pos->u32TimeStampStart / 1000 / 60 ) % 60,
                               ( pos->u32TimeStampStart / 1000 ) % 60,
                               pos->u32TimeStampStart,
                               u32Duration,
                               pos->u32TransitionId ) );
            spm_tclSubStateHandler::vTraceTrigger(SSM_vHistoryTrigger, &pos->tTrigger, TR_LEVEL_FATAL);
         }

         // SpmSysStateHistory: user specific code end
      }
      break;

      case SPM_SPMSETSYSTEMSTATEMACHINE:
      {
         // Sets the instance of SystemStateMachine to be started on next start-ups.
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSetSystemStateMachine' was called: param1 = 0x%x", param1 ) );

         // SpmSetSystemStateMachine: user specific code start
            ETG_TRACE_FATAL( ( "statemachine: %d is started on all comming start-ups\n", ETG_ENUM(SPM_SYSTEMSTATE_MACHINES, param1) ) );
         dp_tclSpmDpConfigSystemStateMachine oSystemStateMachine;
         oSystemStateMachine.vSetData(param1);
         // SpmSetSystemStateMachine: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclSystemStateManagerBaseFunction: user specific code start
     // spm_tclSystemStateManagerBaseFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclSystemStateManagerBaseFile: user specific code start
// spm_tclSystemStateManagerBaseFile: user specific code end

