/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISystemStateManager.h
  * @brief        This is header file contains interface functions for System State Manager.
  * @copyright    (C) 2015 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_IWorkerClient.h"
#include "spm_SubStateDefines.h"

/*!
  *  \class ISpmSystemStateManager
  *  \brief This abstract class provides interfaces to spm statemachine.
          This class also delivers interfaces to get system state, get new system state, system state before reset.
     class also supplies interfaces to get stand by time , door open time and remaining stand by time as well as set stand by time,
        door open time and state time.
  */
class ISpmSystemStateManager : public ISpmWorkerClient
{
public:
ISpmSystemStateManager( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){}
virtual ~ISpmSystemStateManager( ){}

virtual tVoid vStartCommunication( )                        = 0;

virtual tVoid vNewSystemStateReached( )                     = 0;

virtual tU32  u32GetNewSystemState( )                       = 0;

virtual tU32  u32GetSystemState( )                          = 0;

virtual tU32  u32GetSystemStateBeforeReset( )               = 0;

virtual tBool bActStateReached( tU32 u32SystemState ) const = 0;

virtual tVoid vNewSubState( TTriggerMsg *tNewTrigger )      = 0;

virtual tVoid vStartStateTimeoutTimer( tU32 u32Time ) const = 0;

virtual tVoid vSetStateTime( tU32 u32State,
                             tU32 u32Time )                 = 0;

virtual tU32  u32GetStateTime( tU32 u32State ) const        = 0;

virtual tU32  u32GetRemainingStateTimeoutTime( )            = 0;

virtual tBool bPointOfNoReturnReached( )                    = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmSystemStateManager" ); }
virtual tU8 u8GetFsmId() const { return( 0 ); }
};

