/*!
  * \file spm_SystemStateManagerInf4cv.cpp
  *  \brief
  *    Generic project specific parts of the spm statemachine
  *    generated file
  *    generated in  : 2017
  *    generated with: spm_SystemStateManager.cpp.tpl
  *
  *  \note
  *   PROJECT: Gen3
  *   SW-COMPONENT: LCM Life Cycle Management (FC SPM)
  * @copyright   (C) 2012 - 2017 Robert Bosch GmbH.
  *              The reproduction, distribution and utilization of this file as
  *              well as the communication of its contents to others without express
  *              authorization is prohibited. Offenders will be held liable for the
  *              payment of damages. All rights reserved in the event of the grant
  *              of a patent, utility model or design.
  *
  ******
  */
  
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"
#include "dp_spm_if.h"
#include "dp_generic_if.h"

#include "spm_Config.h"
#include "spm_GlobDefs.h"
#include "spm_FITypes.h"
#include "spm_SystemStateManagerInf4cv.h"
#include "spm_SystemPowerManagerConfig.h"
#include "spm_SuperVisionManager.h"
#include "spm_OsalProxyConfig.h"
#include "spm_SubStateHandlerConfig.h"
#include "spm_CriticalSection.h"
#include "spm_IFactory.h"
#include "spm_ApplicationDatabase.h"
#include "spm_OsLinux.h"
#include "spm_IGlobalApplicationManager.h"
#include "spm_ITimerHandler.h"

// spm_tclSystemStateManagerInf4cvInclude: user specific code start
// spm_tclSystemStateManagerInf4cvInclude: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_SSM_PRJ
#include "trcGenProj/Header/spm_SystemStateManagerInf4cv.cpp.trc.h"
#endif

#define IMX_STATEMACHINE_TRIGGER_SWCD_VERSION     "4.14"

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/
// #define SPM_TRACE_FILE_ID   SPM_FILE_SYSTEMSTATEMANAGERCONFIG

spm_tclSystemStateManagerInf4cv*spm_tclSystemStateManagerInf4cv::_poMyRef = NULL;

spm_tclSystemStateManagerInf4cv::spm_tclSystemStateManagerInf4cv(const ISpmFactory& factory)
   : spm_tclSystemStateManager(factory){
   _poMyRef = this;
   tU8 u8DooOpenTimeRange = 0;
   tU8 u8StandbyTimeout[2] = {0};
   tU16 u16BufLen= 2;
   
   const tChar* strVersion = SPM_SYSTEM_STATE_VERSION;
   ETG_TRACE_USR4 (("IMX_STATEMACHINE_TRIGGER_SWCD_VERSION: %s", IMX_STATEMACHINE_TRIGGER_SWCD_VERSION));

   vSetStateEntries(_arStateTable);
   spm_tclSystemStateManager::vSetTransitionEntries(_aSysStateTransitionTable, spm_tclSystemStateManagerInf4cv::u32GetNumberOfTransitionTableEntries() );

   // set default value for standbytime
   tU32 u32StandbySec = SPM_STDBY_TIME_SEC;

   // ***************************************************************************
   // Set timer values
   // ***************************************************************************

   dp_tclSpmDpConfigStandbyTime    oStandby;
   dp_tclSpmDpConfigDevStandbyTime oDeveloperStandby;

   oStandby >> u32StandbySec;

   // and now check if standby time is changed by developer
   // tU32 u32DeveloperStandbyTime = oDeveloperStandby.u32StandbyTime;
   tU32 u32DeveloperStandbyTime;
   oDeveloperStandby >> u32DeveloperStandbyTime;
   if (u32StandbySec != u32DeveloperStandbyTime){
      // standby time in sec
      // TRACE_SPM_INFO_STRING("Set stored developer standby time!");
      u32StandbySec = u32DeveloperStandbyTime;
   }
   // set state timeouts
   //spm_tclSystemStateManager::vSetStateTime(SPM_SYSTEM_STANDBY, u32StandbySec * 1000);

   // spm_tclSystemStateManagerInf4cv_SetTimer: user specific code start
   dp_tclSpmDpConfigStateProfileStatus oStateProfileStatus;
   if (TRUE == oStateProfileStatus.tGetData())
   {
	   dp_tclSpmDpConfigStateProfileTime oStateProfileTime;
	   spm_tclSystemStateManager::vSetStateTime(SPM_SYSTEM_STATE_PROFILE, (oStateProfileTime.tGetData() * 60000)); //Converting minutes to miliseconds
	   ETG_TRACE_USR4( ( "spm_tclSystemStateManagerInf4cv::spm_tclSystemStateManagerInf4cv oStateProfileTime=%d",oStateProfileTime.tGetData() * 60000 ) ); 
   }


   //Reading the KDS value for StandbyTimeRange
   dp_tclKdsAIVIVariantCoding oStanbytime;
   oStanbytime.u8GetStandbyTimeout((tU8 *)&u8StandbyTimeout,u16BufLen);
   ETG_TRACE_USR4(("Kds value for StandbyTimeout is:u8StandbyTimeout[0]= %d u8StandbyTimeout[1] =%d", u8StandbyTimeout[0],u8StandbyTimeout[1]));
   spm_tclSystemStateManager::vSetStateTime(SPM_SYSTEM_STANDBY, ((u8StandbyTimeout[1]) * 1000));  //Converting seconds to miliseconds

   //Reading the KDS value for DoorOpenTimeRange
   dp_tclKdsCIS_Configuration oDoorOpentime;
   oDoorOpentime.u8GetDoorUnlockTime(u8DooOpenTimeRange);
   ETG_TRACE_USR4(("spm_tclSystemStateManagerInf4cv::spm_tclSystemStateManagerInf4cv Kds value for DoorOpenTimeRange is: %d", u8DooOpenTimeRange));
   spm_tclSystemStateManager::vSetStateTime(SPM_SYSTEM_DOOR_OPEN, (u8DooOpenTimeRange * 60000));  //Converting minutes to miliseconds
	   //dp_tclSpmDpConfigStateProfileTime
   // spm_tclSystemStateManagerInf4cv_SetTimer: user specific code end

   // ***************************************************************************
   // Set transition to new system state
   // ***************************************************************************

   dp_tclSpmDpInternDataSystemState oNewSystemState;
   oNewSystemState.vSetData(_u32NewSystemState);

   if (_u32NewSystemState >= spm_tclSystemStateManagerInf4cv::u32GetNumberOfStateEntries() ){
      // set new system state, if recovered state i sout of range --> _u32NewSystemState = SPM_SYSTEM_BACKGROUND;
      // spm_tclSystemStateManagerInf4cv_SetNewState: user specific code start
      // spm_tclSystemStateManagerInf4cv_SetNewState: user specific code end

      ETG_TRACE_ERR( ( "SPM: !!!!!! Error detected !!!!!!" ) );
   }

   // set init system state --> _u32InitialSystemState = SPM_SYSTEM_ON;
   // spm_tclSystemStateManagerInf4cv_SetInitState: user specific code start
   // spm_tclSystemStateManagerInf4cv_SetInitState: user specific code end
   
}

spm_tclSystemStateManagerInf4cv::~spm_tclSystemStateManagerInf4cv(){
   // spm_tclSystemStateManagerInf4cv_Destruct: user specific code start
   // spm_tclSystemStateManagerInf4cv_Destruct: user specific code end
}

tVoid spm_tclSystemStateManagerInf4cv::vGetReferences(){
   spm_tclSystemStateManager::vGetReferences();
   // spm_tclSystemStateManagerInf4cv_vGetReferences: user specific code start
   // spm_tclSystemStateManagerInf4cv_vGetReferences: user specific code end

}

tVoid spm_tclSystemStateManagerInf4cv::vStartCommunication(){
   spm_tclSystemStateManager::vStartCommunication();
   // spm_tclSystemStateManagerInf4cv_SetInitState: user specific code start
   SPM_NULL_POINTER_CHECK(_poclSubStateHandler);
   dp_tclSpmDpConfigStateProfileStatus oStateProfileStatus;
   if (TRUE == oStateProfileStatus.tGetData())
   {
	   _poclSubStateHandler->vSetSubStateType(SPM_U32_MULTIMEDIA_ON, TRUE);
   }
   // spm_tclSystemStateManagerInf4cv_SetInitState: user specific code end
}

tVoid spm_tclSystemStateManagerInf4cv::vStartLateCommunication(){
   // spm_tclSystemStateManagerInf4cv_vStartLateCommunication: user specific code start
   // spm_tclSystemStateManagerInf4cv_vStartLateCommunication: user specific code end
}

tBool spm_tclSystemStateManagerInf4cv::bActStateReached(tU32 u32SystemState) const {
   if (!spm_tclSystemStateManager::bActStateReached(u32SystemState) ){
      // System state SPM_SYSTEM_SHUTDOWN is reached --> call method directly
      vStateReachedShutdown();
   }
   // spm_tclSystemStateManagerInf4cv_bActStateReached: user specific code start
   // spm_tclSystemStateManagerInf4cv_bActStateReached: user specific code end

   return( TRUE );
}

tVoid spm_tclSystemStateManagerInf4cv::vCheckNewStateTransition() {
//   spm_tclSystemStateManager::vCheckNewStateTransition();
   // spm_tclSystemStateManagerInf4cv_vCheckNewStateTransition: user specific code start
tU32 u32NewSysState;
   SPM_NULL_POINTER_CHECK(_poclSubStateHandler);
   // point of no return reached
   if (_u32NewSystemState != SPM_SYSTEM_SHUTDOWN){

      spm_vEnterCritical(_hStateChangeAccess);
      _u32IntermediateSystemState = _u32NewSystemState;
      u32NewSysState              = u32CalcNewSystemState(_u32NewSystemState);

      if (SPM_SYSTEM_INVALID != u32NewSysState){
         _u32NewSystemState = u32NewSysState;
         spm_bReleaseCritical(_hStateChangeAccess);

         if (SPM_SYSTEM_SHUTDOWN == _u32NewSystemState){
            SPM_NULL_POINTER_CHECK(_poclSupervisionManager);

            dp_tclSpmDpInternDataShutdownConfirmed oShutdownConfirmedSet;
            oShutdownConfirmedSet.vSetData(TRUE);

            tU32                                   u32SysTime = OSAL_ClockGetElapsedTime() / 1000;
            dp_tclSpmDpPowOnLastSystemRunTime      oSysOnTime;
            oSysOnTime << u32SysTime;

            if (_poSpmOsLinux){
               _poSpmOsLinux->bSyncFilesystem(5000);
            }
            if (!_poclOsalProxy->bPrepareForShutdown() ){
               ETG_TRACE_ERR( ( "SPM: !!!!!! Error detected !!!!!!" ) );
            }
            ETG_TRACE_USR1( ( "vCheckNewStateTransition, Point of no return reached." ) );
            _bPointOfNoReturnReached = TRUE;

            _poclSupervisionManager->vEnableRetriggerHwWdt(FALSE);

            // now we can already terminate the WDT threads
            _poclSupervisionManager->vTerminate();

            vStateEntryShutdown();
            // store datapool now
            dp_tclSrvIf dp;
            dp.s32StoreNow();

         }

         // remember new system state
         dp_tclSpmDpInternDataSystemState oNewSystemState;
         oNewSystemState.vSetData(_u32NewSystemState);

         // inform immediatley via direct interface
         if (FALSE == _poclGlobalApplicationManager->bProcessSystemState(_u32NewSystemState) ){
         }

         _poclSubStateHandler->vProcessSystemState(_u32NewSystemState);

         // check if we have to debounce --> display should be off while debouncing
         if (_u32StateChangeCounter > SPM_U32_DEBOUNCE_STATE_CHANGE_COUNTER){
            if (_u32NewSystemState != SPM_SYSTEM_ON){
               _poclSubStateHandler->vSetSubStateType(SPM_U32_STATE_DEBOUNCE, TRUE);
               _u32StateChangeCounter = 0;
            }
         }

         // set again --> just to make sure that it was not changed meanwhile
         oNewSystemState.vSetData(_u32NewSystemState);


      } else {
         spm_bReleaseCritical(_hStateChangeAccess);

         _poclSubStateHandler->vProcessSystemState(SPM_SYSTEM_INVALID);
      }
   }
   // spm_tclSystemStateManagerInf4cv_vCheckNewStateTransition: user specific code end

}

tVoid spm_tclSystemStateManagerInf4cv::vHandleMessage(tU32 u32Message, tU32 u32Param){
   (tVoid)u32Param;
   SPM_NULL_POINTER_CHECK(_poclSubStateHandler);

   switch (u32Message){
      case SPM_U32_SYSTEM_STATE_ACTIVATE_AUTOMATIC:
         //_poclSubStateHandler->vSetSubStateType(SPM_U32_AUTOMATIC, TRUE);
         break;
      // spm_tclSystemStateManagerInf4cv_vHandleMessage: user specific code start
	case SPM_U32_WORKER_SSM_MULTIMEDIA_ON_REQ:
	{
		dp_tclSpmDpConfigStateProfileStatus oStateProfileStatus;
   		if (TRUE == oStateProfileStatus.tGetData())
   		{
	   		dp_tclSpmDpConfigStateProfileTime oStateProfileTime;
			ETG_TRACE_USR4( ( "spm_tclSystemStateManagerInf4cv::vHandleMessage:Set on tipper trigger oStateProfileTime=%d",oStateProfileTime.tGetData() * 60000 ) );  
			_poMyRef->_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_KEY_PRESENT,TRUE);
			SPM_GET_IF_REFERENCE_NEW_VAR(poTimerHdl, ISpmTimerHandler);
			poTimerHdl->vStartTimer("spm_tclSystemStateManagerInf4cv", "AutoAcc2OnReqOff", oStateProfileTime.tGetData() * 60000, 0, SPM_U32_WORKER_SSM_MULTIMEDIA_NO_REQ); //Converting minutes to miliseconds
			
		}
	}
	break;
	case SPM_U32_WORKER_SSM_MULTIMEDIA_NO_REQ:
	{
		if(_poMyRef->_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_KEY_PRESENT))
		{
			ETG_TRACE_USR4( ( "spm_tclSystemStateManagerInf4cv::vHandleMessage:Clear on tipper trigger" ) );  
			_poMyRef->_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_KEY_PRESENT,FALSE);
		}
	}
	break;	
      // spm_tclSystemStateManagerInf4cv_vHandleMessage: user specific code end
      default:
         spm_tclSystemStateManager::vHandleMessage(u32Message, u32Param);
         break;
   }
}

tVoid spm_tclSystemStateManagerInf4cv::vStateNoTransition(tVoid){
   // spm_tclSystemStateManagerInf4cv_vStateNoTransition: user specific code start
   // spm_tclSystemStateManagerInf4cv_vStateNoTransition: user specific code end
}


