/*!
  * \file spm_SystemStateFsmTabConfig.cpp
  *  \brief
  *    Generic project specific parts of the spm statemachine
  *    generated file
  *    generated at  : 2022
  *    generated with: spm_SystemStateFsmTabConfig.cpp.tpl
  *
  *  \note
  *   PROJECT: Gen3
  *   SW-COMPONENT: LCM Life Cycle Management (FC SPM)
  * @copyright   (C) 2012 - 2022 Robert Bosch GmbH.
  *              The reproduction, distribution and utilization of this file as
  *              well as the communication of its contents to others without express
  *              authorization is prohibited. Offenders will be held liable for the
  *              payment of damages. All rights reserved in the event of the grant
  *              of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

// SPM  configuration
#include "spm_Config.h"

#include "spm_GlobDefs.h"
#include "spm_FITypes.h"
#include "spm_SystemStateManagerInf4cv.h"


spm_tclSystemStateManagerInf4cv::TStateTransitionElement spm_tclSystemStateManagerInf4cv::_aSysStateTransitionTable[] =
{


// **********************************************************
// ***  CurrentSystemState: NOT_RELEVANT
// **********************************************************

   {  //If FastShutdown is set, go to PREPARE_SHUTDOWN. Generic feature
      1,
      SPM_SYSTEM_NOT_RELEVANT,
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      SPM_U32_MSG_INVALID
   },

   {  //If DIAGNOSIS is active, go to state DIAGNOSIS. Diagnosis feature. Don't enetr into Diagnosis state when SW Update Stage 1 is active
      2,
      SPM_SYSTEM_NOT_RELEVANT,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      SPM_SYSTEM_DIAGNOSIS,
      SPM_U32_MSG_INVALID
   },

   {  //If DOWNLAOD is active, Go to DOWNLAOD state. Download feature
      3,
      SPM_SYSTEM_NOT_RELEVANT,
      {
         SPM_BC0_DOWNLOAD,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_DOWNLOAD,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      SPM_SYSTEM_DOWNLOAD,
      SPM_U32_MSG_INVALID
   },

   {  //If TriggerForceOn is active, go to ON. Diagnosis feature
      4,
      SPM_SYSTEM_NOT_RELEVANT,
      {
         SPM_BC0_TRIGGER_FORCE_ON,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_TRIGGER_FORCE_ON,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If DiagActivity is inactive, go to DIAGNOSIS. Diagnosis feature
      5,
      SPM_SYSTEM_NOT_RELEVANT,
      {
         SPM_BC0_DIAG_ACTIVITY,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_DIAG_ACTIVITY|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_DIAGNOSIS,
      SPM_U32_MSG_INVALID
   },

   {  //If DOWNLOAD_PERMISSION is active, Go to MMI_ON_SWDL state. Software Stage 1 feature
      6,
      SPM_SYSTEM_NOT_RELEVANT,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      SPM_SYSTEM_MMI_ON_SWDL,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: BACKGROUND
// **********************************************************

   {  //When OnOff key pressed(Wakeup through OnOff), go to Animation State
      100,
      SPM_SYSTEM_BACKGROUND,
      {
         SPM_BC0_ON_TIPPER,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_ON_TIPPER,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_CRITICAL_LOW_VOLTAGE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-C) is available and Last User Context is not useroff, go to Animation State
      101,
      SPM_SYSTEM_BACKGROUND,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_AUTOMATIC,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-A) is available, WAKE_IN is present, Last User Context is not useroff, go to Animation State
      102,
      SPM_SYSTEM_BACKGROUND,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-A) is available, WAKE_IN is present, Last User Context is not useroff, go to Animation State
      112,
      SPM_SYSTEM_BACKGROUND,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-C) is available and Last User Context is user off, go to user off state
      103,
      SPM_SYSTEM_BACKGROUND,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_AUTOMATIC,
         0,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-A) is available WAKE_IN is present, Last User Context is user off, go to user off
      104,
      SPM_SYSTEM_BACKGROUND,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_AUTOMATIC,
         0,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-A) is available WAKE_IN is present, Last User Context is user off, go to user off
      113,
      SPM_SYSTEM_BACKGROUND,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_AUTOMATIC,
         0,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //When MIC1 is pressed, go to STATE_PROFILE State
      105,
      SPM_SYSTEM_BACKGROUND,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_FAST_SHUTDOWN|SPM_BC0_IGNITION,
         0,
         SPM_BC2_CRITICAL_LOW_VOLTAGE,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is removed, timeout already happened, go to PREPARE_SHUTDOWN
      108,
      SPM_SYSTEM_BACKGROUND,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      SPM_U32_MSG_INVALID
   },

   {  //If no CAN activity, timeout already happened, go to PREPARE_SHUTDOWN
      109,
      SPM_SYSTEM_BACKGROUND,
      {
         SPM_BC0_NETWORK_ACTIVITY,
         0,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_NETWORK_ACTIVITY,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      SPM_U32_MSG_INVALID
   },

   {  //On Timeout, go to PREPARE_SHUTDOWN
      110,
      SPM_SYSTEM_BACKGROUND,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      SPM_U32_MSG_INVALID
   },

   {  //On DOORLOCK(Door unlock from CM-A), go to DOOR_OPEN
      111,
      SPM_SYSTEM_BACKGROUND,
      {
         SPM_BC0_DOORLOCK,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_DOORLOCK,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      SPM_SYSTEM_DOOR_OPEN,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: ON
// **********************************************************

   {  //If OnOff key pressed, go to user off state
      200,
      SPM_SYSTEM_ON,
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-C) is removed, go to STANDBY state
      201,
      SPM_SYSTEM_ON,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-A) is removed, go to STANDBY state
      202,
      SPM_SYSTEM_ON,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Ethernet error is received, go to cockpit mode
      203,
      SPM_SYSTEM_ON,
      {
         0,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage/Thermal event (critical) is received from CM-A, go to MMI_STANDBY_PWR_SAVE_1 state
      205,
      SPM_SYSTEM_ON,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage event UNDER_WARNING is received from CM-A, go to MMI_STANDBY_PWR_SAVE_1 state
      206,
      SPM_SYSTEM_ON,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If battery is low(PNMGRP10), go to cockpit mode
      207,
      SPM_SYSTEM_ON,
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is removed, go to STANDBY state
      208,
      SPM_SYSTEM_ON,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-C) is removed and MIC1 is active, go to Hour logic state
      209,
      SPM_SYSTEM_ON,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-A) is removed and MIC1 is active, go to Hour logic state
      210,
      SPM_SYSTEM_ON,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-C) is removed and BT phone call is active, go to Hour logic state
      211,
      SPM_SYSTEM_ON,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_PHONE,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-A) is removed and BT phone call is active, go to Hour logic state
      212,
      SPM_SYSTEM_ON,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_PHONE,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-C) is removed and Intercom call is active, go to Hour logic state
      213,
      SPM_SYSTEM_ON,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-A) is removed and Intercom call is active, go to Hour logic state
      214,
      SPM_SYSTEM_ON,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-C) is removed and MIC2/3 is active, go to Hour logic state
      215,
      SPM_SYSTEM_ON,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_USER_ON_REQ|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-A) is removed and MIC2/3 is active, go to Hour logic state
      216,
      SPM_SYSTEM_ON,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_USER_ON_REQ|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If CAN ACTIVITY is not present, Ignition(CM-C) and WAKE_IN is not present go to Standby state
      217,
      SPM_SYSTEM_ON,
      {
         SPM_BC0_NETWORK_ACTIVITY,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_NETWORK_ACTIVITY|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: IGNITION
// **********************************************************

   {  //When OnOff key pressed,animation is played,ethernet and PNMGRP10 error is not present and voltage state at CM-A is normal, go to ON state
      300,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When OnOff key pressed, animation is played,ethernet error is present,and voltage state at CM-A is normal, go to MMI_ON (Cockpit) state
      301,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         SPM_BC2_HKEY_PRESSED,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When OnOff key pressed, animation is played,PNMGRP10 (low battery condition) error is present,and voltage state at CM-A is normal, go to MMI_ON (Cockpit) state
      317,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN|SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When OnOff key pressed,Animation is not completed and voltage state at CM-A is normal, go to Animation state
      302,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_FIRST_PIC_DRAWN,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-C) is removed, go to STANDBY state
      303,
      SPM_SYSTEM_IGNITION,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is removed, go to STANDBY state
      304,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC1 is active, ethernet error and PNMGRP10 error is not present and voltage state at CM-A is normal, go to ON state
      305,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC1 is active, ethernet error is present and voltage state at CM-A is normal, go to MMI_ON (Cockpit) state
      306,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC1 is active, PNMGRP10 is present and voltage state at CM-A is normal, go to MMI_ON (Cockpit) state
      319,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC2/3 is active, voltage state at CM-A is normal, go to MMI_ON_TEL state
      307,
      SPM_SYSTEM_IGNITION,
      {
         0,
         SPM_BC1_USER_ON_REQ,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_USER_ON_REQ,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON_TEL,
      SPM_U32_MSG_INVALID
   },

   {  //If Phone call is active, voltage state at CM-A is normal, go to MMI_ON_TEL state
      308,
      SPM_SYSTEM_IGNITION,
      {
         SPM_BC0_PHONE,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_PHONE,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON_TEL,
      SPM_U32_MSG_INVALID
   },

   {  //If RVC is active, voltage state at CM-A is normal, go to MMI_ON_TEL state
      309,
      SPM_SYSTEM_IGNITION,
      {
         SPM_BC0_RCV_CONNECTED,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_RCV_CONNECTED,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON_TEL,
      SPM_U32_MSG_INVALID
   },

   {  //When Intercom call is active, voltage state at CM-A is normal, go to MMI_ON_TEL state
      310,
      SPM_SYSTEM_IGNITION,
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON_TEL,
      SPM_U32_MSG_INVALID
   },

   {  //If Low battery (PNM_GRP10) condition is present, voltage state at CM-A is normal, go to MMI_ON (Cockpit) state
      311,
      SPM_SYSTEM_IGNITION,
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When volatage event from CM-A becomes normal and ethernet error is not present, go to ON state
      312,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When volatage event from CM-A becomes normal and ethernet error is present, go to MMI_ON (Cockpit) state
      316,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When volatage event from CM-A becomes normal and PNMGRP10 error is present, go to MMI_ON (Cockpit) state
      320,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage/Thermal event (critical) is received from CM-A, and system is in user off state not because of low voltage level, go to popup state 
      313,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DEMAND_AUDIO_MUTE,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage/Thermal event (critical) is received from CM-A,and system is in user off state because of low voltage level, go to SAFE state
      318,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_SAFE,
         SPM_BC3_DEMAND_AUDIO_MUTE,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_SAFE,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is removed, Ignition(CM-C) is not present, go to STANDBY state
      314,
      SPM_SYSTEM_IGNITION,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If network activity is not present, Ignition(CM-C) and WAKE_IN is not present, go to STANDBY state
      315,
      SPM_SYSTEM_IGNITION,
      {
         SPM_BC0_NETWORK_ACTIVITY,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_NETWORK_ACTIVITY|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: STATE_PROFILE
// **********************************************************

   {  //When OnOff key pressed, go to standby state
      400,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(CM-C) is available, ethernet error is not present and PNMGRP10 signal is ON,go to ON state
      401,
      SPM_SYSTEM_STATE_PROFILE,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(CM-C) is available, ethernet error is present,go to MMI_ON (Cockpit) state
      402,
      SPM_SYSTEM_STATE_PROFILE,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(CM-C) is available, PNMGRP10 signal is OFF,go to MMI_ON (Cockpit) state
      415,
      SPM_SYSTEM_STATE_PROFILE,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(CM-A) is available,WAKE_IN is present, ethernet error is not present and PNMGRP10 signal is ON, go to ON state
      403,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(CM-A) is available,WAKE_IN is present, ethernet error is not present and PNMGRP10 signal is ON, go to ON state
      413,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(CM-A) is available,WAKE_IN is present, ethernet error is present, go to MMI_ON (Cockpit) state
      404,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(CM-A) is available,WAKE_IN is present, PNMGRP10 signal is OFF, go to MMI_ON (Cockpit) state
      416,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(CM-A) is available,WAKE_IN is present, ethernet error is present, go to MMI_ON (Cockpit) state
      414,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(CM-A) is available,WAKE_IN is present,PNMGRP10 signal is OFF, go to MMI_ON (Cockpit) state
      417,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC1 is inactive, Ignition(CM-C/CM-A) is not present, RVC,PHONE,Intercom and MIC2/3 is not active,ON tipper wakeup is not set,go to STANDBY state 
      405,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_KEY_PRESENT|SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If PHONE is inactive, Ignition(CM-C/CM-A) is not present, RVC, MIC1,Intercom and MIC2/3 is not active,ON tipper wakeup is not set,go to STANDBY state 
      406,
      SPM_SYSTEM_STATE_PROFILE,
      {
         SPM_BC0_PHONE,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_KEY_PRESENT|SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC2/3 is inactive, Ignition(CM-C/CM-A) is not present, RVC, MIC1, Intercom and PHONE is not active,ON tipper wakeup is not set, go to STANDBY state 
      407,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         SPM_BC1_USER_ON_REQ,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_KEY_PRESENT|SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Intercom call inactive, Ignition(CM-C/CM-A) is not present, RVC, MIC1, MIC2/3 and PHONE is not active,ON tipper wakeup is not set, go to Standby state
      408,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_KEY_PRESENT|SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If RVC inactive, Ignition(CM-C/CM-A) is not present, RVC, MIC1, MIC2/3 and PHONE is not active,ON tipper wakeup is not set,go to Standby state
      422,
      SPM_SYSTEM_STATE_PROFILE,
      {
         SPM_BC0_RCV_CONNECTED,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_KEY_PRESENT|SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If ON_TIPPER wakeup is cleared, Ignition(CM-C/CM-A) is not present, RVC, MIC1, MIC2/3 and PHONE is not active,go to Standby state
      423,
      SPM_SYSTEM_STATE_PROFILE,
      {
         SPM_BC0_KEY_PRESENT,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_KEY_PRESENT|SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Low Voltage is received from CM-A, go to MMI_STANDBY_PWR_SAVE_1 (Pop-up) state
      410,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage/thermal event (critical) is received from CM-A, go to MMI_STANDBY_PWR_SAVE_1 (Pop-up) state
      411,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //On timeout, go to MMI_STANDBY_PWR_SAVE_1 (Pop-up) state
      412,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC1 is active,restart the hourlogic timer and stay in STATE_PROFILE (Hour logic)
      418,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If PHONE is active,restart the hourlogic timer and stay in STATE_PROFILE (Hour logic)
      419,
      SPM_SYSTEM_STATE_PROFILE,
      {
         SPM_BC0_PHONE,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_PHONE,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Intercom is active,restart the hourlogic timer and stay in STATE_PROFILE (Hour logic)
      420,
      SPM_SYSTEM_STATE_PROFILE,
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If RVC is active,restart the hourlogic timer and stay in STATE_PROFILE (Hour logic)
      421,
      SPM_SYSTEM_STATE_PROFILE,
      {
         SPM_BC0_RCV_CONNECTED,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_RCV_CONNECTED,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: MMI_ON
// **********************************************************

   {  //When OnOff key pressed,RVC,MIC1,MIC2_3,Intercom and PHONE is not active, go to user off state
      500,
      SPM_SYSTEM_MMI_ON,
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-C) is removed, RVC and PHONE is not active, go to STANDBY state
      501,
      SPM_SYSTEM_MMI_ON,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is removed, RVC and PHONE is not active, go to STANDBY state
      502,
      SPM_SYSTEM_MMI_ON,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-C) is removed, Hourlogic is enabled in KDS, RVC is active, go to STATE_PROFILE (Hour logic) state
      509,
      SPM_SYSTEM_MMI_ON,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_RCV_CONNECTED,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-C) is removed, Hourlogic is enabled in KDS, PHONE is active, go to STATE_PROFILE (Hour logic) state
      510,
      SPM_SYSTEM_MMI_ON,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_PHONE,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-A) is removed, Hourlogic is enabled in KDS, RVC is active, go to STATE_PROFILE (Hour logic) state
      511,
      SPM_SYSTEM_MMI_ON,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_RCV_CONNECTED,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-A) is removed, Hourlogic is enabled in KDS, PHONE is active, go to STATE_PROFILE (Hour logic) state
      512,
      SPM_SYSTEM_MMI_ON,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_PHONE,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If ETH_ERR is inactive, go to ON state
      503,
      SPM_SYSTEM_MMI_ON,
      {
         0,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage event (critical) is received from CM-A, go to MMI_STANDBY_PWR_SAVE_1 state
      504,
      SPM_SYSTEM_MMI_ON,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If PNM_GRP10 signal is Indicating battery normal, go to ON state
      505,
      SPM_SYSTEM_MMI_ON,
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is removed, go to STANDBY state
      506,
      SPM_SYSTEM_MMI_ON,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Low Voltage event (14V-17V) is received from CM-A, go to MMI_STANDBY_PWR_SAVE_1 state
      507,
      SPM_SYSTEM_MMI_ON,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If CAN ACTIVITY is not present, Ignition(CM-C) and WAKE_IN is not present go to Standby state
      508,
      SPM_SYSTEM_MMI_ON,
      {
         SPM_BC0_NETWORK_ACTIVITY,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_NETWORK_ACTIVITY|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: MMI_STANDBY
// **********************************************************

   {  //When Ignition(from CM-C) is removed, go to STANDBY state
      600,
      SPM_SYSTEM_MMI_STANDBY,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_RCV_CONNECTED|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is removed, go to STANDBY state
      601,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_RCV_CONNECTED|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         SPM_BC4_PHONE_MUTE,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage Low volatage is received from CM-A, Ignition (CM-C) is present, go to MMI_STANDBY_PWR_SAVE_1 (Pop-up) state
      606,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage Low volatage is received from CM-A, Ignition (CM-A) is present, go to MMI_STANDBY_PWR_SAVE_1 (Pop-up) state
      607,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage Low volatage is received from CM-A and Ignition (CM-C/CM-A) is not present, go to STANDBY state
      608,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage/temperature event (critical) is received from CM-A and Ignition (CM-C) is present, go to MMI_STANDBY_PWR_SAVE_1(popup) state
      609,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage/temperature event (critical) is received from CM-A and Ignition (CM-A) is present, go to MMI_STANDBY_PWR_SAVE_1(popup) state
      610,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_SAFE,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage/temperature event (critical) is received from CM-A and Ignition (CM-C/CM-A) is not present, go to STANDBY state
      611,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //Animation timeout happened, Ignition (CM-C) is present, Ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      612,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Animation timeout happened, Ignition (CM-A) is present, Ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      613,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Animation timeout happened, Ignition (CM-C) is present, and Ethernet error is present, go to MMI_ON state
      614,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_STATE_TO,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Animation timeout happened, Ignition (CM-A) is present, and Ethernet error is present, go to MMI_ON state
      615,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Animation timeout happened, Ignition (CM-C) is present, and low battery (PNM_GRP10) condition is present, go to MMI_ON state
      616,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_STATE_TO|SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Animation timeout happened, Ignition (CM-A) is present, and low battery (PNM_GRP10) condition is present, go to MMI_ON state
      617,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO|SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Animation timeout happened, Ignition (CM-C/CM-A) is not present, Hourlogic is enabled in KDS, go to STATE_PROFILE (Hour logic) state
      618,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_WORKER_SSM_MULTIMEDIA_ON_REQ
   },

   {  //If WAKE_IN is removed,Ignition (CM-C) is not present, go to STANDBY state
      620,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Animation is played, Ignition (CM-C) is present,ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      622,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Animation is played, Ignition (CM-A) is present,ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      623,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Animation is played, Ignition (CM-C) is present, and ethernet error is present, go to MMI_ON state
      624,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Animation is played, Ignition (CM-A) is present,and ethernet error is present, go to MMI_ON state
      625,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Animation is played, Ignition (CM-C) is present,and low battery (PNM_GRP10) condition is present, go to MMI_ON state
      626,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_FIRST_PIC_DRAWN|SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Animation is played, Ignition (CM-A) is present,and low battery (PNM_GRP10) condition is present, go to MMI_ON state
      627,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN|SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Animation is played, Ignition (CM-C/CM-A) is not present, Hourlogic is enabled in KDS, go to STATE_PROFILE (Hour logic) state
      628,
      SPM_SYSTEM_MMI_STANDBY,
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_WORKER_SSM_MULTIMEDIA_ON_REQ
   },


// **********************************************************
// ***  CurrentSystemState: MMI_ON_TEL
// **********************************************************

   {  //If Ignition(from CM-C) is removed and PHONE/MIC2/3/INTERCOM is inactive, go to STANDBY state
      700,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-C) is removed and PHONE/MIC2/3/INTERCOM is inactive, go to STANDBY state
      701,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_PHONE|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-C) is removed , Hourlogic is enabled, INTERCOM is active , go to STATE_PROFILE (Hourlogic) state
      702,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-C) is removed,Hourlogic is enabled and PHONE is active, go to STATE_PROFILE (Hourlogic) state
      703,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_PHONE,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-C) is removed, Hourlogic is enabled and MIC2/3 is active, go to STATE_PROFILE (Hourlogic) state
      704,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_USER_ON_REQ|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-A) is removed, Hourlogic is enabled and INTERCOM is active, go to STATE_PROFILE (Hourlogic) state
      705,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-A) is removed, Hourlogic is enabled and PHONE is active, go to STATE_PROFILE (Hourlogic) state
      706,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_PHONE,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-A) is removed, Hourlogic is enabled and MIC2/3 is active, go to STATE_PROFILE (Hourlogic) state
      707,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_USER_ON_REQ|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-C) is removed,Phone call,MIC2/3,Intercom call should not be active, go to STANDBY state
      718,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_PHONE|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(from CM-A) is removed, Phone call,MIC2/3,Intercom call should not be active, go to STANDBY state
      719,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_PHONE|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC2/3 is inactive, RVC, PHONE and INTERCOM is inactive, go to user off state
      708,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         SPM_BC1_USER_ON_REQ,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //If PHONE is inactive, RVC, MIC2/3 and INTERCOM is inactive, go to user off state
      709,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         SPM_BC0_PHONE,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //If RVC is inactive, PHONE, MIC2/3 and INTERCOM is inactive, go to user off state
      710,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         SPM_BC0_RCV_CONNECTED,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //If Intercom is inactive, PHONE, MIC2/3 and RVC is inactive, go to user off state
      711,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_RCV_CONNECTED|SPM_BC0_PHONE|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_USER_ON_REQ|SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //If ethernet error is present, go to MMI_ON state
      712,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When Low battery (PNM_GRP10) condition is present, go to MMI_ON state
      713,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Low voltage is received from CM-A, go to MMI_STANDBY_PWR_SAVE_1 (Pop-up) state
      714,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Voltage/Thermal event (critical) is received from CM-A, go to MMI_STANDBY_PWR_SAVE_1 (popup) state
      715,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is inactive, go to STANDBY state
      716,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Network activity is not present, Ignition(CM-C) and WAKE_IN is not present, go to STANDBY state
      717,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         SPM_BC0_NETWORK_ACTIVITY,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_NETWORK_ACTIVITY|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC1 is active, when Low battery (PNM_GRP10) condition is not present, go to ON state
      720,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC1 is active, when Low battery (PNM_GRP10) condition is present, go to MMI_ON state
      721,
      SPM_SYSTEM_MMI_ON_TEL,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: SAFE
// **********************************************************

   {  //When ignition(from CM-C) is removed, go to Standby state
      800,
      SPM_SYSTEM_SAFE,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When ignition(from CM-A) is removed, go to Standby state
      801,
      SPM_SYSTEM_SAFE,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When voltage and Thermal event from CM-A is normal,ethernet error is not present and PNMGRP10 signal is ON and Animation is played before, go to ON state
		
      802,
      SPM_SYSTEM_SAFE,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_SAFE|SPM_BC2_Q_CRITICAL,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When voltage and Thermal event from CM-A is normal,ethernet error is not present and PNMGRP10 signal is ON and animation is not played before, go to MMI_STANDBY state
		
      808,
      SPM_SYSTEM_SAFE,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_FIRST_PIC_DRAWN,
         SPM_BC2_SAFE|SPM_BC2_Q_CRITICAL,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When voltage and Thermal event from CM-A is normal,PNMGRP10 signal is OFF and Animation is played before, go to MMI_ON state
      806,
      SPM_SYSTEM_SAFE,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_SAFE|SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When voltage and Thermal event from CM-A is normal,ethernet error is present and Animation is played before, go to MMI_ON state
      807,
      SPM_SYSTEM_SAFE,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_SAFE|SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When Low voltage from CM-A is received, go to IGNITION (User off) state
      803,
      SPM_SYSTEM_SAFE,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //When WAKE_IN is removed, Ignition(CM-C), go to standby state
      804,
      SPM_SYSTEM_SAFE,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Network activity is removed, Ignition(CM-C) and WAKE_IN is not present, go to standby state
      805,
      SPM_SYSTEM_SAFE,
      {
         SPM_BC0_NETWORK_ACTIVITY,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_NETWORK_ACTIVITY|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: STANDBY
// **********************************************************

   {  //When OnOff key is pressed and Hourlogic is enabled in KDS,PNMGRP10 signal is ON and Animation is played before, and voltage and thermal state is normal, go to Hourlogic 			state
      900,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         0,
         SPM_BC1_MULTIMEDIA_ON|SPM_BC1_FIRST_PIC_DRAWN,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_WORKER_SSM_MULTIMEDIA_ON_REQ
   },

   {  //When OnOff key is pressed and Hourlogic is enabled in KDS,PNMGRP10 signal is ON and Animation is not played before, and voltage and thermal state is normal, go to 		MMI_STANDBY state
      921,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         0,
         SPM_BC1_MULTIMEDIA_ON,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_FIRST_PIC_DRAWN,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-C) is available, Last User Context is not user off, ethernet error is not present and PNMGRP10 signal is ON and voltage and thermal state is normal,and 			animation is played before, go to ON state
      901,
      SPM_SYSTEM_STANDBY,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_AUTOMATIC|SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-C) is available, Last User Context is not user off, voltage and thermal state is normal,and animation is not played before, go to MMI_STANDBY state
		
      922,
      SPM_SYSTEM_STANDBY,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_AUTOMATIC,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_FIRST_PIC_DRAWN,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-C) is available, Last User Context is user off, ethernet error and Low battery (PNMGRP10) is not preesent and voltage and thermal state is normal, go to 			IGNITION (User off) state
      902,
      SPM_SYSTEM_STANDBY,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_AUTOMATIC,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-C) is available, ethernet error is present,and voltage and thermal level at CM-A is normal and animation is played before, go to MMI_ON (Cockpit) state
		
      903,
      SPM_SYSTEM_STANDBY,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-C) is available, PNMGRP10 signal is ON,voltage and thermal level at CM-A is normal and animation is played before, go to MMI_ON (Cockpit) state
		
      904,
      SPM_SYSTEM_STANDBY,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_FIRST_PIC_DRAWN,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is available, Last User Context is not user off, WAKE_IN is present, ethernet error is not present and PNMGRP10 signal is ON and voltage and thermal 			state is normal at CM-A,and animation is not played before, go to MMI_STANDBY state
      923,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_FIRST_PIC_DRAWN,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is available, Last User Context is not user off, WAKE_IN is present, ethernet error is not present and PNMGRP10 signal is ON and voltage and thermal 			state is normal at CM-A,and animation is played before, go to ON state
      905,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC|SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is available, Last User Context is not user off, WAKE_IN is present, ethernet error is not present and PNMGRP10 signal is ON and voltage and thermal 			state is normal at CM-A,and animation is played before, go to ON state
      917,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC|SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is available, Last User Context is user off, WAKE_IN is present, ethernet error is not preesent and PNMGRP10 signal is ON and voltage and thermal 			state is normal at CM-A, go to IGNITION (User off) state
      906,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_AUTOMATIC,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is available, Last User Context is user off, WAKE_IN is present, ethernet error is not preesent and PNMGRP10 signal is ON and voltage and thermal 			state is normal at CM-A, go to IGNITION (User off) state
      918,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_AUTOMATIC,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is available, WAKE_IN is present and ethernet error is present,and voltage and thermal  level at CM-A is normal and animation is played before, go to 			MMI_ON (Cockpit) state
      907,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is available, WAKE_IN is present and ethernet error is present,and voltage and thermal  level at CM-A is normal and animation is played before, go to 			MMI_ON (Cockpit) state
      919,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is available, WAKE_IN is present and PNMGRP10 signal is ON and voltage and thermal  level at CM-A is normal and animation is played before, go to 			MMI_ON (Cockpit) state
      908,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(from CM-A) is available, WAKE_IN is present and PNMGRP10 signal is ON and voltage and thermal  level at CM-A is normal and animation is played before, go to 			MMI_ON (Cockpit) state
      920,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //When MIC1 is active and Hourlogic is enabled in KDS,low battery (PNMGRP10) condition is not present and voltage and thermal state is normal at CM-A, go to STATE_PROFILE 			(Hour logic) state
      909,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         0,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If state timeout happened,WAKE_IN, go to MMI_STANDBY_PWR_SAVE_2 state
      910,
      SPM_SYSTEM_STANDBY,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is inactive, state timeout happened, go to MMI_STANDBY_PWR_SAVE_2 state
      911,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is active, Last User Context is not user off, Ignition(CM-A) is present, ethernet error is not present and PNMGRP10 signal is ON and voltage and thermal 			level at CM-A is normal and animation is played before, go to ON state
      912,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC|SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is active, Last User Context is not user off, Ignition(CM-A) is present, ethernet error is not present and PNMGRP10 signal is ON and voltage and thermal 			level at CM-A is normal and animation is not played before, go to MMI_STANDBY state
      924,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC,
         0,
         SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_FIRST_PIC_DRAWN,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is active, Last User Context is user off, Ignition(CM-A) is present, ethernet error is not present and PNMGRP10 signal is ON and voltage and thermal state is 			normal at CM-A, go to IGNITION (User off) state
      913,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_AUTOMATIC,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is active, Last User Context is user off, Ignition(from CM-A) is present, ethernet error is present and voltage and thermal state at CM-A is normal and 		animation is played before, go to MMI_ON (Cockpit) state
      914,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DISPLAY_REQUEST|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is active, Last User Context is user off, Ignition(from CM-A) is present,PNMGRP10 signal is ON and voltage and thermal state at CM-A is normal, and animation 			is played before go to MMI_ON (Cockpit) state
      915,
      SPM_SYSTEM_STANDBY,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_FIRST_PIC_DRAWN,
         0,
         SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If CAN activity is not present, WAKE_IN is not present and state timeout happened, go to MMI_STANDBY_PWR_SAVE_2 state
      916,
      SPM_SYSTEM_STANDBY,
      {
         SPM_BC0_NETWORK_ACTIVITY,
         0,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_NETWORK_ACTIVITY,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: DIAGNOSIS
// **********************************************************

   {  //If DiagActivity is active, go to ON state. Diagnosis feature.
      1000,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAG_ACTIVITY,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_DIAG_ACTIVITY,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive, Ignition(CM-C) is present and ethernet error and low battery (PNM_GRP10) is not present, and voltage and thermal state is normal at CM-A,go to ON state. Diagnosis feature.
      1001,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive, ignition(CM-A) is present and ethernet error and low battery (PNM_GRP10) is not present, and voltage and thermal state is normal at CM-A,go to ON state. Diagnosis feature.
      1002,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive, ignition(CM-C) is present, ethernet error is present and voltage and thermal state is normal at CM-A, go to MMI_ON (Cockpit) state. Diagnosis feature.
      1003,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive, ignition(CM-A) is present, ethernet error is present and voltage and thermal state is normal at CM-A, go to MMI_ON (Cockpit) state. Diagnosis feature.
      1004,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive, ignition(CM-C) is present low battery (PNM_GRP10) condition is present, and voltage and thermal state is normal at CM-A, go to MMI_ON (Cockpit) state. Diagnosis feature.
      1005,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive, ignition(CM-A) is present low battery (PNM_GRP10) condition is present, and voltage and thermal state is normal at CM-A, go to MMI_ON (Cockpit) state. Diagnosis feature.
      1006,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive, ignition(CM-C) is present and voltage/thermal (critical) state is received from CM-A ,go to MMI_STANDBY_PWR_SAVE_1 (popup) state. Diagnosis feature.
      1007,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive, ignition(CM-A) is present and voltage/thermal (critical) state is received from CM-A ,go to MMI_STANDBY_PWR_SAVE_1 (popup) state. Diagnosis feature.
      1008,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_SAFE,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive, ignition(CM-C) is present and Low volatge is received from CM-A ,go to MMI_STANDBY_PWR_SAVE_1 (Pop-up) state. Diagnosis feature.
      1009,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive, ignition(CM-A) is present and Low volatge is received from CM-A ,go to MMI_STANDBY_PWR_SAVE_1 (Pop-up) state. Diagnosis feature.
      1010,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive,Ignition(CM-C/CM-A) is not present, WAKE_IN and network activity is not present, go to STANDBY state. Diagnosis feature.
      1011,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_IGNITION|SPM_BC0_NETWORK_ACTIVITY|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Diagnosis is inactive,Ignition(CM-C/CM-A) is not present, go to STANDBY state. Diagnosis feature.
      1012,
      SPM_SYSTEM_DIAGNOSIS,
      {
         SPM_BC0_DIAGNOSIS,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_DIAGNOSIS|SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: MMI_ON_SWDL
// **********************************************************

   {  //If SW Update Stage1 is completed, Ignition(CM-C) is present and ethernet error and low battery (PNM_GRP10) is not present, and voltage and thermal state is normal at CM-A,go to ON state. Diagnosis feature.
      3001,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION|SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed, ignition(CM-A) is present and ethernet error and low battery (PNM_GRP10) is not present, and voltage and thermal state is normal at CM-A,go to ON state. Diagnosis feature.
      3002,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION|SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed, ignition(CM-C) is present, ethernet error is present and voltage and thermal state is normal at CM-A, go to MMI_ON (Cockpit) state. Diagnosis feature.
      3003,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed, ignition(CM-A) is present, ethernet error is present and voltage and thermal state is normal at CM-A, go to MMI_ON (Cockpit) state. Diagnosis feature.
      3004,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed, ignition(CM-C) is present low battery (PNM_GRP10) condition is present, and voltage and thermal state is normal at CM-A, go to MMI_ON (Cockpit) state. Diagnosis feature.
      3005,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed, ignition(CM-A) is present low battery (PNM_GRP10) condition is present, and voltage and thermal state is normal at CM-A, go to MMI_ON (Cockpit) state. Diagnosis feature.
      3006,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed, ignition(CM-C) is present and voltage/thermal (critical) state is received from CM-A ,go to MMI_STANDBY_PWR_SAVE_1 (popup) state. Diagnosis feature.
      3007,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed, ignition(CM-A) is present and voltage/thermal (critical) state is received from CM-A ,go to MMI_STANDBY_PWR_SAVE_1 (popup) state. Diagnosis feature.
      3008,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_SAFE,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed, ignition(CM-C) is present and Low volatge is received from CM-A ,go to MMI_STANDBY_PWR_SAVE_1 (Pop-up) state. Diagnosis feature.
      3009,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed, ignition(CM-A) is present and Low volatge is received from CM-A ,go to MMI_STANDBY_PWR_SAVE_1 (Pop-up) state. Diagnosis feature.
      3010,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed,Ignition(CM-C/CM-A) is not present, WAKE_IN and network activity is not present, go to STANDBY state. Diagnosis feature.
      3011,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_NETWORK_ACTIVITY|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If SW Update Stage1 is completed,Ignition(CM-C/CM-A) is not present, go to STANDBY state. Diagnosis feature.
      3012,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_DOWNLOAD_PERMISSION,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Timeout happened,enter into standby. Faile safe handling, If DOWNLOAD_PERMISSION is not cleared in 1 hour (Timeout)
      3013,
      SPM_SYSTEM_MMI_ON_SWDL,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: PREPARE_SHUTDOWN
// **********************************************************

   {  //Generated transition --> sync FS is ready --> shuting system down
      99999,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         SPM_BC1_SYNC_SHUTDOWN_ACK,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      SPM_SYSTEM_SHUTDOWN,
      SPM_U32_MSG_INVALID
   },

   {  //If onoff button is pressed, Hourlogic is enabled in KDS, low battery (PNM_GRP10) condition is not present, and voltage/thermal state at CM-A is normal, go to STATE_PROFILE (Hour logic) state 
      1100,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         0,
         SPM_BC1_MULTIMEDIA_ON,
         SPM_BC2_HKEY_PRESSED,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_WORKER_SSM_MULTIMEDIA_ON_REQ
   },

   {  //Ignition(CM-C) is present, Last User Context is not user off, ethernet error and low battery (PNM_GRP10) condition is not present, voltage/thermal state at CM-A is normal, go to ON state
      1101,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_AUTOMATIC,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-C) is present, Last User Context is user off, ethernet error and low battery (PNM_GRP10) condition is not present, voltage/thermal state at CM-A is normal, go to IGNITION (User off) state
      1102,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_AUTOMATIC,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-C) is present, ethernet error  is present, voltage/thermal state at CM-A is normal, go to MMI_ON (Cockpit) state
      1103,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-C) is present, low battery (PNM_GRP10) condition is present, voltage/thermal state at CM-A is normal, go to MMI_ON (Cockpit) state
      1104,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-A) is present, Last User Context is not user off, WAKE_IN should be present,ethernet error and low battery (PNM_GRP10) condition is not present, voltage/thermal state at CM-A is normal, go to ON state
      1105,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-A) is present, Last User Context is not user off, WAKE_IN should be present,ethernet error and low battery (PNM_GRP10) condition is not present, voltage/thermal state at CM-A is normal, go to ON state
      1113,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-A) is present, Last User Context is user off, WAKE_IN should be present, ethernet error and low battery (PNM_GRP10) condition is not present, voltage/thermal state at CM-A is normal, go to IGNITION (User off) state
      1106,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_AUTOMATIC,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-A) is present, Last User Context is user off, WAKE_IN should be present, ethernet error and low battery (PNM_GRP10) condition is not present, voltage/thermal state at CM-A is normal, go to IGNITION (User off) state
      1114,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING|SPM_BC1_AUTOMATIC,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-A) is present,WAKE_IN should be present, ethernet error is present, voltage/thermal state at CM-A is normal, go to MMI_ON (Cockpit) state
      1107,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-A) is present,WAKE_IN should be present, ethernet error is present, voltage/thermal state at CM-A is normal, go to MMI_ON (Cockpit) state
      1115,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-A) is present,WAKE_IN should be present, low battery (PNM_GRP10) condition is present, voltage/thermal state at CM-A is normal, go to MMI_ON (Cockpit) state
      1108,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //Ignition(CM-A) is present,WAKE_IN should be present, low battery (PNM_GRP10) condition is present, voltage/thermal state at CM-A is normal, go to MMI_ON (Cockpit) state
      1116,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If MIC1 is active, Hourlogic is enabled in KDS, low battery (PNM_GRP10) condition is not present, voltage/thermal state at CM-A is normal, go to STATE_PROFILE (Hour logic) state
      1109,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         0,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //Timeout happened,go to Shutdown state
      1110,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      SPM_SYSTEM_SHUTDOWN,
      SPM_U32_MSG_INVALID
   },

   {  //WAKE_IN is present,go to STANDBY state
      1111,
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: DOOR_OPEN
// **********************************************************

   {  //When MIC1 is pressed, Hourlogic is enabled in KDS, voltage/thermal state at CM-A is normal, go to STATE_PROFILE State
      1200,
      SPM_SYSTEM_DOOR_OPEN,
      {
         0,
         0,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         0,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         SPM_BC4_PHONE_MUTE,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE|SPM_BC2_CRITICAL_LOW_VOLTAGE,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //When Phone call is active, Hourlogic is enabled in KDS, voltage/thermal state at CM-A is normal, go to STATE_PROFILE State
      1201,
      SPM_SYSTEM_DOOR_OPEN,
      {
         SPM_BC0_PHONE,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_PHONE,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE|SPM_BC2_CRITICAL_LOW_VOLTAGE,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //When RVC is active, Hourlogic is enabled in KDS, voltage/thermal state at CM-A is normal, go to STATE_PROFILE State
      1203,
      SPM_SYSTEM_DOOR_OPEN,
      {
         SPM_BC0_RCV_CONNECTED,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_RCV_CONNECTED,
         SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE|SPM_BC2_CRITICAL_LOW_VOLTAGE,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //When Intercom call is active, Hourlogic is enabled in KDS, voltage/thermal state at CM-A is normal, go to STATE_PROFILE State
      1204,
      SPM_SYSTEM_DOOR_OPEN,
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_TELEMATIC_ACTIVE|SPM_BC1_MULTIMEDIA_ON,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE|SPM_BC2_CRITICAL_LOW_VOLTAGE,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STATE_PROFILE,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is removed, go to STANDBY
      1205,
      SPM_SYSTEM_DOOR_OPEN,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //On Timeout, go to STANDBY
      1206,
      SPM_SYSTEM_DOOR_OPEN,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When OnOff key pressed(Wakeup through OnOff), voltage/thermal state at CM-A is normal, go to Animation State
      1207,
      SPM_SYSTEM_DOOR_OPEN,
      {
         SPM_BC0_ON_TIPPER,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_ON_TIPPER,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE|SPM_BC2_CRITICAL_LOW_VOLTAGE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-A) is available, WAKE_IN is present, Last User Context is not useroff, voltage/thermal state at CM-A is normal, go to Animation State
      1208,
      SPM_SYSTEM_DOOR_OPEN,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-A) is available, WAKE_IN is present, Last User Context is not useroff, voltage/thermal state at CM-A is normal, go to Animation State
      1210,
      SPM_SYSTEM_DOOR_OPEN,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_AUTOMATIC,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-A) is available, WAKE_IN is present, Last User Context is user off, voltage/thermal state at CM-A is normal, go to user off
      1209,
      SPM_SYSTEM_DOOR_OPEN,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_AUTOMATIC,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //When Ignition(from CM-A) is available, WAKE_IN is present, Last User Context is user off, voltage/thermal state at CM-A is normal, go to user off
      1211,
      SPM_SYSTEM_DOOR_OPEN,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_AUTOMATIC,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: MMI_STANDBY_PWR_SAVE_1
// **********************************************************

   {  //If Ignition(CM-C) is present, voltage and thermal state is normal at CM-A and ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      2100,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(CM-C) is present, voltage and thermal state is normal at CM-A and ethernet error is present, go to MMI_ON (Cockpit) state
      2101,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(CM-C) is present, voltage and thermal state is normal at CM-A and low battery (PNM_GRP10) condition is present, go to MMI_ON (Cockpit) state
      2102,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(CM-A) is present, WAKE_IN is present, voltage and thermal state is normal at CM-A and ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      2103,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(CM-A) is present, WAKE_IN is present, voltage and thermal state is normal at CM-A and ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      2130,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(CM-A) is present, WAKE_IN is present, voltage and thermal state is normal at CM-A and ethernet error is present, go to MMI_ON (Cockpit) state
      2104,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(CM-A) is present, WAKE_IN is present, voltage and thermal state is normal at CM-A and ethernet error is present, go to MMI_ON (Cockpit) state
      2131,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(CM-A) is present, WAKE_IN is present, voltage and thermal state is normal at CM-A and ethernet error is present, go to MMI_ON (Cockpit) state
      2105,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(CM-A) is present, WAKE_IN is present, voltage and thermal state is normal at CM-A and ethernet error is present, go to MMI_ON (Cockpit) state
      2132,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(CM-C) is not present, go to STANDBY state
      2106,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Ignition(CM-A) is not present, go to STANDBY state
      2107,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If Low voltage at CM-A is not present, Ignition(CM-C) is present, voltage and thermal state is normal at CM-A and ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      2108,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Low voltage at CM-A is not present, Ignition(CM-A) is present, voltage and thermal state is normal at CM-A and ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      2109,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Low voltage at CM-A is not present, Ignition(CM-C) is present, voltage and thermal state is normal at CM-A and ethernet error is present, go to MMI_ON (Cockpit) state
      2110,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Low voltage at CM-A is inactive, Ignition(CM-A) is present, voltage and thermal state is normal at CM-A and ethernet error is present, go to MMI_ON (Cockpit) state
      2111,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Low voltage at CM-A is not present, Ignition(CM-C) is present, voltage and thermal state is normal at CM-A and low battery (PNM_GRP10) condition is present, go to MMI_ON (Cockpit) state
      2112,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If Low voltage at CM-A is not present, Ignition(CM-C) is present, voltage and thermal state is normal at CM-A and low battery (PNM_GRP10) condition is present, go to MMI_ON (Cockpit) state
      2113,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If voltage/thermal (critical) state at CM-A is not present, Ignition(CM-C) is present, voltage and thermal state is normal at CM-A and ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      2114,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If voltage/thermal (critical) state at CM-A is not present, Ignition(CM-A) is present, voltage and thermal state is normal at CM-A and ethernet error and low battery (PNM_GRP10) condition is not present, go to ON state
      2115,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      SPM_SYSTEM_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If voltage/thermal (critical) state at CM-A is not present, Ignition(CM-C) is present, voltage and thermal state is normal at CM-A and ethernet error is present, go to MMI_ON (Cockpit) state
      2116,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         0,
         0,
         SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If voltage/thermal (critical) state at CM-A is not present, Ignition(CM-A) is present, voltage and thermal state is normal at CM-A and ethernet error is present, go to MMI_ON (Cockpit) state
      2117,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST|SPM_BC3_DARK_SCREEN_REQ,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If voltage/thermal (critical) state at CM-A is not present, Ignition(CM-C) is present, voltage and thermal state is normal at CM-A and low battery (PNM_GRP10) condition is present, go to MMI_ON (Cockpit) state
      2118,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If voltage/thermal (critical) state at CM-A is not present, Ignition(CM-A) is present, voltage and thermal state is normal at CM-A and low battery (PNM_GRP10) condition is present, go to MMI_ON (Cockpit) state
      2119,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         0,
         SPM_BC1_SHUTDOWN_BATTERY_SAVING,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_Q_CRITICAL|SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_MMI_ON,
      SPM_U32_MSG_INVALID
   },

   {  //If popup state timeout happened, Ignition(CM-C) is present and low voltage at CM-A is present, go to IGNITION (User off) state
      2120,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_STATE_TO,
         SPM_BC2_Q_CRITICAL,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //If popup state timeout happened, Ignition(CM-A) is present and low voltage at CM-A is present, go to IGNITION (User off) state
      2121,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         SPM_BC2_Q_CRITICAL,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         SPM_BC2_SAFE,
         0,
         0,
      },
      SPM_SYSTEM_IGNITION,
      SPM_U32_MSG_INVALID
   },

   {  //If popup state timeout happened, Ignition(CM-C) is present and voltage/thermal (critical) state at CM-A is present, go to SAFE (Protected off) state
      2122,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION,
         SPM_BC1_STATE_TO,
         SPM_BC2_SAFE,
         0,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_SAFE,
      SPM_U32_MSG_INVALID
   },

   {  //If popup state timeout happened, Ignition(CM-A) is present and voltage/thermal state at CM-A is critical, go to SAFE (Protected off) state
      2123,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         SPM_BC2_SAFE,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      {
         SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         0,
         0,
      },
      SPM_SYSTEM_SAFE,
      SPM_U32_MSG_INVALID
   },

   {  //If popup state timeout happened, Ignition(CM-C/CM-A) is not present, go to STANDBY state
      2124,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_DISPLAY_REQUEST,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },

   {  //If WAKE_IN is inactive, Ignition(CM-C), go to STANDBY state
      2125,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      {
         0,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      {
         SPM_BC0_IGNITION|SPM_BC0_FAST_SHUTDOWN,
         0,
         0,
         SPM_BC3_EXTERNAL_GPIO,
         0,
      },
      SPM_SYSTEM_STANDBY,
      SPM_U32_MSG_INVALID
   },


// **********************************************************
// ***  CurrentSystemState: MMI_STANDBY_PWR_SAVE_2
// **********************************************************

   {  //If state timeout happened, go to PREPARE_SHUTDOWN state
      2200,
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2,
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         0,
         SPM_BC1_STATE_TO,
         0,
         0,
         0,
      },
      {
         NO_TRIGGER_TO_CHECK,
      },
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      SPM_U32_MSG_INVALID
   },
};


tU32 spm_tclSystemStateManagerInf4cv::u32GetNumberOfTransitionTableEntries() const {
   return( sizeof( _aSysStateTransitionTable ) / sizeof( _aSysStateTransitionTable[0] ) );
}

