/*******************************************************************************
 *
 * FILE:          spm_rootdaemon.h
 *
 * SW-COMPONENT:  Life Cycle Management
 *
 * PROJECT:       ADIT Gen3 Platform
 *
 * DESCRIPTION:   TBD
 *
 * AUTHOR:        CM-AI/ECO3-Kalms
 *
 * COPYRIGHT:     (C) 2015 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#pragma once

/*
  ****************************************************************************

   INCLUDES

  ****************************************************************************
  */

#include "RootDaemonTypes.h"

/*
  ****************************************************************************

   DEFINES

  ****************************************************************************
  */

typedef enum
{
   TRIGGER_TIME_TRACKER,
   GET_RUNNING_THREADS,
   GET_THREAD_INFO,
   GET_PROCESS_INFO_BY_NAME,
   GET_PROCESS_INFO_BY_ID,
   SEND_SIGNAL_TO_PROCESS_VIA_SYSTEMD,
   SEND_SIGNAL_TO_PROCESS,
   SEND_SIGNAL_TO_ALL_PROCESSES,
   GET_PROCESS_HIGH_WATER_MARKS,
   UNMOUNT_PARTITIONS,
   GET_CURRENT_PROCESSES,
   GET_OOM_INFO,
   KILL_PROCESS,
   SYSTEMCTL_START_UNIT,
   SYSTEMCTL_STOP_UNIT,
   START_PROCESS_VIA_GDB,
   NUMBER_OF_LCM_ROOT_COMMANDS // Last entry
} tenRootDaemonCommands;

extern "C"
{

/*
  ****************************************************************************

   FUNCTION DECLARATIONS

  ****************************************************************************
  */

CmdData SPM_ROOTDAEMON_CALLER_rPerformRootOp(const char                 *clientName,
                                             const tenRootDaemonCommands cmdNum,
                                             const char                 *args);

/******************************************************************************/

} // extern "C"

