/*****************************************************************************
  | FILE:         ProcBase.cpp
  | PROJECT:      NISSAN LCN2.5
  | SW-COMPONENT: Process
  | -----------------------------------------------------------------------------
  | DESCRIPTION:  Process Base Entry
  |
  | -----------------------------------------------------------------------------
  | COPYRIGHT:    (c) 2005 Robert Bosch Car Multimedia GmbH
  | HISTORY:
  | Date      | Modification               | Author
  | 18.08.11  |                            | Kollai
  | --.--.--  | ----------------           | -------, -----
  |
  |*****************************************************************************/

/************************************************************************
    |defines and macros (scope: module-local)
  |-----------------------------------------------------------------------*/

/************************************************************************
  | includes of component-internal interfaces
  | (scope: component-local)
  |-----------------------------------------------------------------------*/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_DATAPOOL
   #define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"
#endif
// SPM  configuration
#include "spm_Config.h"

#include "spm_factory_config.h"

#include "buildversion_if.h"

#include "ProcBaseEnv.h"

#define TR_CLASS_PROC_STARTUP          0x8200

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROC_STARTUP
#include "trcGenProj/Header/ProcBase.cpp.trc.h"
#endif

/************************************************************************
 * defines and macros
 ************************************************************************/

OSAL_tEventHandle hEvShutdown = 0;
OSAL_tEventMask   hEvRequest  = 0x00000001;

tS32 s32RunEnv(void){
   tS32          bRetVal = OSAL_OK;
   reg_tclRegKey oReg;

   #ifndef VARIANT_S_FTR_DISABLE_USE_ADIT_TRACE
   // Start Trace
   vInitPlatformEtg();
   #endif

   // create entry node for registry
   oReg.bCreate( "/dev/registry/LOCAL_MACHINE");

   #ifdef VARIANT_S_FTR_ENABLE_DISPLAY_VERSION
      BuildVersion_vDisplayStartupMessage("PROCBASEEARLY");
   #endif

   // shutdown event has to be created before creating SPM instance otherwise it is possible that
   // during fast shutdown of spm the event is not yet created. So do it now!
   if (OSAL_s32EventCreate(SPM_EV_SHUTDOWN_NAME, &hEvShutdown) == OSAL_ERROR){
      //ETG_TRACE_USR1(("Creation of SPM shutdown event failed"));
      ETG_TRACE_FATAL( ( "ProcBase: Error on startup" ) );
   }

   DP_vCreateDatapool();

   // create system power manager
   spm_tclFactoryConfig oSpmFactory;
   oSpmFactory.bCreate();
   oSpmFactory.vStart();


   oSpmFactory.vRunEnv();

   {
      // Wait for Shutdown-Signal
      OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &hEvRequest);

      // Shutdown everything else
      OSAL_s32EventClose(hEvShutdown);
      OSAL_s32EventDelete(SPM_EV_SHUTDOWN_NAME);

   }

   return( bRetVal );
} // s32RunEnv

/************************************************************************
    |end of file ProcBase.cpp
  |-----------------------------------------------------------------------*/

