/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         LcmAsfComponent.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#ifndef __LCM_lcmAsfComponent_H
#define __LCM_lcmAsfComponent_H

#include <iostream>

#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"

#include "asf/stream/MemoryStream.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcm_AppMain.h"

namespace org {
namespace genivi {

using namespace ::asf::core;
using namespace ::asf::stream;
using namespace ::org::genivi;

void vProxyStarter(lcm_tclAppMain *poServer);

class CcaSrvProxy;

class LcmAsfComponent : public BaseComponent
{
private:
lcm_tclAppMain *_poCcaServer;
CcaSrvProxy    *_poCcaSrvProxy;

DECLARE_CLASS_LOGGER();

public:
LcmAsfComponent();
virtual ~LcmAsfComponent();
};

}
} // namespace org { namespace genivi {

#endif // ifndef __LCM_lcmAsfComponent_H

