/*****************************************************************************
* FILE:         lcm_ServiceLcmDbus.h
* PROJECT:      G3G project
* SW-COMPONENT: lcm
* Template:     ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __lcm_ServiceLcmDbus_H_
#define __lcm_ServiceLcmDbus_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_lcm_ServiceLcmDbus.h"
#include "lcm_AppMain.h"

// lcm_tclServiceLcmDbus_Include: user specific code start
// lcm_tclServiceLcmDbus_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class lcm_tclServiceLcmDbusCallbackIF;

class lcm_tclServiceLcmDbus : public Ilcm_tclServiceLcmDbus
{
protected:
   class tclMethodResultManager {
   public:

      // Constructors and destructors
      tclMethodResultManager(){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };
      ~tclMethodResultManager(){};

      tVoid vInit(tVoid){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };

      tVoid vMemorize(tBool bPending, tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID) {
         _bPending = bPending;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      tBool bIsPending(tVoid) const {return _bPending;};    
      tVoid vSetPending(tVoid) {_bPending = TRUE;};
      tVoid vSetPendingValue(tBool _bPendingValue){_bPending = _bPendingValue;};
      tVoid vClearPending(tVoid){_bPending = FALSE;};
      tBool bGetPending(tVoid) const {return _bPending;};    

      tU16 u16GetSourceAppID(tVoid) const {return _u16SourceAppID;};    
      tU16 u16GetRegisterID(tVoid) const {return _u16RegisterID;};    
      tU16 u16GetCMDCounter(tVoid) const {return _u16CmdCounter;};    
      tU16 u16GetFctID(tVoid) const {return _u16FctID;};    

   private:                    
      tBool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:

   lcm_tclServiceLcmDbus(tVoid); 
   lcm_tclServiceLcmDbus(lcm_tclAppMain* poMainAppl);
   virtual ~lcm_tclServiceLcmDbus();

   virtual tVoid vSetCallbackIf(lcm_tclServiceLcmDbusCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // lcm_tclServiceLcmDbusDeclarations: user specific code start
   // lcm_tclServiceLcmDbusDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'lcm_tclServiceLcmDbus' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   lcm_tclServiceLcmDbus& operator = (const lcm_tclServiceLcmDbus &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
public:
   virtual const tChar* getName() const { return "lcm_tclServiceLcmDbus"; };
   
   virtual tVoid vHandleMessage(lcm_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
private:
   lcm_tclServiceLcmDbusCallbackIF* _poCallbackIf;

public:



    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendAppStartRequestStatus(lcm_fi_tclString strSwBlockName, lcm_fi_tclString strServiceName, tU32 u32AppId);
   virtual tVoid sendAppInitializedStatus(tU32 u32AppId);
   virtual tVoid sendAppStateChangeStatus(tU32 u32AppId, tU32 u32State);
   virtual tVoid sendAppEndStatus(tU32 u32AppId);
   virtual tVoid sendNewServiceLoadedStatus(lcm_fi_tclString strServiceName, lcm_fi_tclString strBlockName, tU32 u32AppId);
   virtual tVoid sendFailedServicesListStatus(lcm_fi_tcl_SPM_ServiceList tServices);
   virtual tVoid sendNewProcessIdStatus(lcm_fi_tclString strBlockName, lcm_fi_tclString strServiceName, tU32 u32ProcessId);
   virtual tVoid sendStartupFailureIndicationStatus(lcm_fi_tcl_StartupFailureInfo tStartupFailureInd);
   virtual tVoid sendSupervisionStateChangeStatus(tBool bSupervisionActive);

   virtual tBool onAppStateChangeSet(tU32 u32AppId, tU32 u32State, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onAppEndSet(tU32 u32AppId, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onSupervisionStateChangeSet(tBool bSupervisionActive, tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid onStartProcessMStart(lcm_fi_tclString strLocation, tU32 u32Prio, tU32 u32Affinity, tU32 u32AffinityEnd, tU32 u32NiceLevel, tU32 u32NiceLevelEnd, lcm_fi_tcl_e32_LCM_START_PROC_TYPE u32Type, tU32 u32Info);
   virtual tVoid vHandleStartProcessOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onStopProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId);
   virtual tVoid vHandleStopProcessOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onStartupFinishedMStart(lcm_fi_tcl_e32_LCM_STARTUP_TYPE eStartUpParam);
   virtual tVoid vHandleStartupFinishedOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onGetProcessIdMStart(lcm_fi_tclString strServiceName);
   virtual tVoid vHandleGetProcessIdOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onTriggerGetUnitListMStart();
   virtual tVoid vHandleTriggerGetUnitListOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onRestartProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId);
   virtual tVoid vHandleRestartProcessOpMStart(amt_tclServiceData* poMessage);

   virtual tVoid sendStartProcessMResult(tS32 s32ReturnVal, lcm_fi_tclString strLocation, tU32 u32ProcId, tU32 u32SpawnDuration);
   virtual tVoid sendStopProcessMResult(tS32 s32ReturnVal);
   virtual tVoid sendStartupFinishedMResult(tS32 s32ReturnVal);
   virtual tVoid sendGetProcessIdMResult();
   virtual tVoid sendTriggerGetUnitListMResult();
   virtual tVoid sendRestartProcessMResult(tS32 s32ReturnVal);

   virtual void vGetAppStartRequestMsg(lcm_dbusctrlfi_tclMsgAppStartRequestStatus& oStatus) {
      oStatus.strSwBlockName = _tAppStartRequest_strSwBlockName;
      oStatus.strServiceName = _tAppStartRequest_strServiceName;
      oStatus.u32AppId = _tAppStartRequest_u32AppId;
   }
   virtual void vGetAppInitializedMsg(lcm_dbusctrlfi_tclMsgAppInitializedStatus& oStatus) {
      oStatus.u32AppId = _tAppInitialized_u32AppId;
   }
   virtual void vGetAppStateChangeMsg(lcm_dbusctrlfi_tclMsgAppStateChangeStatus& oStatus) {
      oStatus.u32AppId = _tAppStateChange_u32AppId;
      oStatus.u32State = _tAppStateChange_u32State;
   }
   virtual void vGetAppEndMsg(lcm_dbusctrlfi_tclMsgAppEndStatus& oStatus) {
      oStatus.u32AppId = _tAppEnd_u32AppId;
   }
   virtual void vGetNewServiceLoadedMsg(lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& oStatus) {
      oStatus.strServiceName = _tNewServiceLoaded_strServiceName;
      oStatus.strBlockName = _tNewServiceLoaded_strBlockName;
      oStatus.u32AppId = _tNewServiceLoaded_u32AppId;
   }
   virtual void vGetFailedServicesListMsg(lcm_dbusctrlfi_tclMsgFailedServicesListStatus& oStatus) {
      oStatus.tServices = _tFailedServicesList_tServices;
   }
   virtual void vGetNewProcessIdMsg(lcm_dbusctrlfi_tclMsgNewProcessIdStatus& oStatus) {
      oStatus.strBlockName = _tNewProcessId_strBlockName;
      oStatus.strServiceName = _tNewProcessId_strServiceName;
      oStatus.u32ProcessId = _tNewProcessId_u32ProcessId;
   }
   virtual void vGetStartupFailureIndicationMsg(lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& oStatus) {
      oStatus.tStartupFailureInd = _tStartupFailureIndication_tStartupFailureInd;
   }
   virtual void vGetSupervisionStateChangeMsg(lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& oStatus) {
      oStatus.bSupervisionActive = _tSupervisionStateChange_bSupervisionActive;
   }
   virtual void vGetStartProcessMsg(lcm_dbusctrlfi_tclMsgStartProcessMethodStart& oMethodStart) {
      oMethodStart.strLocation = _tStartProcess_strLocation;
      oMethodStart.u32Prio = _tStartProcess_u32Prio;
      oMethodStart.u32Affinity = _tStartProcess_u32Affinity;
      oMethodStart.u32AffinityEnd = _tStartProcess_u32AffinityEnd;
      oMethodStart.u32NiceLevel = _tStartProcess_u32NiceLevel;
      oMethodStart.u32NiceLevelEnd = _tStartProcess_u32NiceLevelEnd;
      oMethodStart.u32Type = _tStartProcess_u32Type;
      oMethodStart.u32Info = _tStartProcess_u32Info;
   }
   virtual void vGetStopProcessMsg(lcm_dbusctrlfi_tclMsgStopProcessMethodStart& oMethodStart) {
      oMethodStart.strLocation = _tStopProcess_strLocation;
      oMethodStart.u32ProcId = _tStopProcess_u32ProcId;
   }
   virtual void vGetStartupFinishedMsg(lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart& oMethodStart) {
      oMethodStart.eStartUpParam = _tStartupFinished_eStartUpParam;
   }
   virtual void vGetGetProcessIdMsg(lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart& oMethodStart) {
      oMethodStart.strServiceName = _tGetProcessId_strServiceName;
   }
   virtual void vGetTriggerGetUnitListMsg(lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }
   virtual void vGetRestartProcessMsg(lcm_dbusctrlfi_tclMsgRestartProcessMethodStart& oMethodStart) {
      oMethodStart.strLocation = _tRestartProcess_strLocation;
      oMethodStart.u32ProcId = _tRestartProcess_u32ProcId;
   }

private:
   // Add status information properties.
   lcm_fi_tclString _tAppStartRequest_strSwBlockName;

   lcm_fi_tclString _tAppStartRequest_strServiceName;

   tU32 _tAppStartRequest_u32AppId;

   tU32 _tAppInitialized_u32AppId;

   tU32 _tAppStateChange_u32AppId;

   tU32 _tAppStateChange_u32State;

   tU32 _tAppEnd_u32AppId;

   lcm_fi_tclString _tNewServiceLoaded_strServiceName;

   lcm_fi_tclString _tNewServiceLoaded_strBlockName;

   tU32 _tNewServiceLoaded_u32AppId;

   lcm_fi_tcl_SPM_ServiceList _tFailedServicesList_tServices;

   lcm_fi_tclString _tNewProcessId_strBlockName;

   lcm_fi_tclString _tNewProcessId_strServiceName;

   tU32 _tNewProcessId_u32ProcessId;

   lcm_fi_tcl_StartupFailureInfo _tStartupFailureIndication_tStartupFailureInd;

   tBool _tSupervisionStateChange_bSupervisionActive;

   lcm_fi_tclString _tStartProcess_strLocation;
   tU32 _tStartProcess_u32Prio;
   tU32 _tStartProcess_u32Affinity;
   tU32 _tStartProcess_u32AffinityEnd;
   tU32 _tStartProcess_u32NiceLevel;
   tU32 _tStartProcess_u32NiceLevelEnd;
   lcm_fi_tcl_e32_LCM_START_PROC_TYPE _tStartProcess_u32Type;
   tU32 _tStartProcess_u32Info;
   lcm_fi_tclString _tStopProcess_strLocation;
   tU32 _tStopProcess_u32ProcId;
   lcm_fi_tcl_e32_LCM_STARTUP_TYPE _tStartupFinished_eStartUpParam;
   lcm_fi_tclString _tGetProcessId_strServiceName;
   lcm_fi_tclString _tRestartProcess_strLocation;
   tU32 _tRestartProcess_u32ProcId;
   tclMethodResultManager _oMemStartProcess;
   tclMethodResultManager _oMemStopProcess;
   tclMethodResultManager _oMemStartupFinished;
   tclMethodResultManager _oMemGetProcessId;
   tclMethodResultManager _oMemTriggerGetUnitList;
   tclMethodResultManager _oMemRestartProcess;
   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(lcm_tclServiceLcmDbus) 

// lcm_tclServiceLcmDbusDeclarationsPart2: user specific code start
// lcm_tclServiceLcmDbusDeclarationsPart2: user specific code end

};

#endif // __lcm_ServiceLcmDbus_H_


