/*****************************************************************************
* FILE:         I_lcm_ServiceLcmDbus.h
* PROJECT:      G3G project
* SW-COMPONENT: lcm
* Template:     I_ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef _I_lcm_ServiceLcmDbus_H_
#define _I_lcm_ServiceLcmDbus_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
//Include FI interface of used service
#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_STDVISITORS
#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_FUNCTIONIDS
#include "lcm_fi_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

//include base class
#include "lcm_AppMain.h"

// Ilcm_tclServiceLcmDbus_Include: user specific code start
// Ilcm_tclServiceLcmDbus_Include: user specific code end

class lcm_tclServiceLcmDbusCallbackIF;

class Ilcm_tclServiceLcmDbus : public ahl_tclBaseOneThreadService, public lcm_tclBaseIf
{
public:
   Ilcm_tclServiceLcmDbus(lcm_tclAppMain* poMainAppl, tU16 u16ServiceID, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion):
      ahl_tclBaseOneThreadService(poMainAppl, u16ServiceID, u16ServiceMajorVersion, u16ServiceMinorVersion),
      lcm_tclBaseIf(poMainAppl) {;}
   virtual ~Ilcm_tclServiceLcmDbus() {;}
   virtual const tChar* getIfName() const { return "Ilcm_tclServiceLcmDbus"; };

   virtual tVoid vSetCallbackIf(lcm_tclServiceLcmDbusCallbackIF* poCallback) = 0;


   virtual tBool onAppStateChangeSet(tU32 u32AppId, tU32 u32State, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onAppEndSet(tU32 u32AppId, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onSupervisionStateChangeSet(tBool bSupervisionActive, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;

   virtual tVoid sendAppStartRequestStatus(lcm_fi_tclString strSwBlockName, lcm_fi_tclString strServiceName, tU32 u32AppId) = 0;
   virtual tVoid sendAppInitializedStatus(tU32 u32AppId) = 0;
   virtual tVoid sendAppStateChangeStatus(tU32 u32AppId, tU32 u32State) = 0;
   virtual tVoid sendAppEndStatus(tU32 u32AppId) = 0;
   virtual tVoid sendNewServiceLoadedStatus(lcm_fi_tclString strServiceName, lcm_fi_tclString strBlockName, tU32 u32AppId) = 0;
   virtual tVoid sendFailedServicesListStatus(lcm_fi_tcl_SPM_ServiceList tServices) = 0;
   virtual tVoid sendNewProcessIdStatus(lcm_fi_tclString strBlockName, lcm_fi_tclString strServiceName, tU32 u32ProcessId) = 0;
   virtual tVoid sendStartupFailureIndicationStatus(lcm_fi_tcl_StartupFailureInfo tStartupFailureInd) = 0;
   virtual tVoid sendSupervisionStateChangeStatus(tBool bSupervisionActive) = 0;

   virtual tVoid sendStartProcessMResult(tS32 s32ReturnVal, lcm_fi_tclString strLocation, tU32 u32ProcId, tU32 u32SpawnDuration) = 0;
   virtual tVoid sendStopProcessMResult(tS32 s32ReturnVal) = 0;
   virtual tVoid sendStartupFinishedMResult(tS32 s32ReturnVal) = 0;
   virtual tVoid sendGetProcessIdMResult() = 0;
   virtual tVoid sendTriggerGetUnitListMResult() = 0;
   virtual tVoid sendRestartProcessMResult(tS32 s32ReturnVal) = 0;

   virtual tVoid onStartProcessMStart(lcm_fi_tclString strLocation, tU32 u32Prio, tU32 u32Affinity, tU32 u32AffinityEnd, tU32 u32NiceLevel, tU32 u32NiceLevelEnd, lcm_fi_tcl_e32_LCM_START_PROC_TYPE u32Type, tU32 u32Info) = 0;
   virtual tVoid onStopProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId) = 0;
   virtual tVoid onStartupFinishedMStart(lcm_fi_tcl_e32_LCM_STARTUP_TYPE eStartUpParam) = 0;
   virtual tVoid onGetProcessIdMStart(lcm_fi_tclString strServiceName) = 0;
   virtual tVoid onTriggerGetUnitListMStart() = 0;
   virtual tVoid onRestartProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId) = 0;

   virtual void vGetAppStartRequestMsg(lcm_dbusctrlfi_tclMsgAppStartRequestStatus& oStatus) = 0;
   virtual void vGetAppInitializedMsg(lcm_dbusctrlfi_tclMsgAppInitializedStatus& oStatus) = 0;
   virtual void vGetAppStateChangeMsg(lcm_dbusctrlfi_tclMsgAppStateChangeStatus& oStatus) = 0;
   virtual void vGetAppEndMsg(lcm_dbusctrlfi_tclMsgAppEndStatus& oStatus) = 0;
   virtual void vGetNewServiceLoadedMsg(lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& oStatus) = 0;
   virtual void vGetFailedServicesListMsg(lcm_dbusctrlfi_tclMsgFailedServicesListStatus& oStatus) = 0;
   virtual void vGetNewProcessIdMsg(lcm_dbusctrlfi_tclMsgNewProcessIdStatus& oStatus) = 0;
   virtual void vGetStartupFailureIndicationMsg(lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& oStatus) = 0;
   virtual void vGetSupervisionStateChangeMsg(lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& oStatus) = 0;
   virtual void vGetStartProcessMsg(lcm_dbusctrlfi_tclMsgStartProcessMethodStart& oMethodStart) = 0;
   virtual void vGetStopProcessMsg(lcm_dbusctrlfi_tclMsgStopProcessMethodStart& oMethodStart) = 0;
   virtual void vGetStartupFinishedMsg(lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart& oMethodStart) = 0;
   virtual void vGetGetProcessIdMsg(lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart& oMethodStart) = 0;
   virtual void vGetTriggerGetUnitListMsg(lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart& oMethodStart) = 0;
   virtual void vGetRestartProcessMsg(lcm_dbusctrlfi_tclMsgRestartProcessMethodStart& oMethodStart) = 0;


// Ilcm_tclServiceLcmDbusDeclarations: user specific code start
// Ilcm_tclServiceLcmDbusDeclarations: user specific code end
};

#endif // _I_lcm_ServiceLcmDbus_H_


