#ifndef _LCM_CLIENTSTARTUPCTRLCLIENT_H
#define _LCM_CLIENTSTARTUPCTRLCLIENT_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          lcm_ClientStartupCtrlClient.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcm
  * @Template:     FrancaProxy.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Franca interface file
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2019 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"

#include "org/bosch/cm/lcm/startupcontrollerProxy.h"

#include "asf/stream/MemoryStream.h"

#include "Ilcm_ClientStartupCtrlClient.h"

// lcm_ClientStartupCtrlClientInclude: user specific code start
//  boost::shared_ptr is used here cause by ASF interface.
// lcm_ClientStartupCtrlClientInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace lcm {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::org::bosch::cm::lcm::startupcontroller;
    using namespace::asf::core;
    using namespace::org::bosch::cm::lcm;

    // lcm_Server__SERVER_NAME__NameSpace: user specific code start
    // lcm_Server__SERVER_NAME__NameSpace: user specific code end

    class lcm_tclClientStartupCtrlClient : public Ilcm_tclClientStartupCtrlClient
        , public ServiceAvailableIF
        , private TimerCallbackIF
        , public FI_VersionCallbackIF
        , public StartupFailureIndicationCallbackIF
        , public StartupStatusCallbackIF
    {
    private:
        DECLARE_CLASS_LOGGER();

        tBool _bSrvAvailable;

    public:
        lcm_tclClientStartupCtrlClient(lcm_tclAppMain* baseRef);
        virtual ~lcm_tclClientStartupCtrlClient();

        // ServiceAvailableIF
        virtual void onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
        virtual void onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        // TimerCallbackIF
        virtual void onExpired(asf::core::Timer                          & timer,
                               boost::shared_ptr <asf::core::TimerPayload> payload);
        // FI_VersionCallbackIF
        virtual void onFI_VersionError(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const boost::shared_ptr< FI_VersionError >& error);
        virtual void onFI_VersionUpdate(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const boost::shared_ptr< FI_VersionUpdate >& update);

        // StartupFailureIndicationCallbackIF
        virtual void onStartupFailureIndicationError(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const boost::shared_ptr< StartupFailureIndicationError >& error);
        virtual void onStartupFailureIndicationUpdate(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const boost::shared_ptr< StartupFailureIndicationUpdate >& update);

        // StartupStatusCallbackIF
        virtual void onStartupStatusError(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const boost::shared_ptr< StartupStatusError >& error);
        virtual void onStartupStatusUpdate(const ::boost::shared_ptr< StartupcontrollerProxy >& proxy, const boost::shared_ptr< StartupStatusUpdate >& update);


    private:

        ::boost::shared_ptr <StartupcontrollerProxy> _StartupCtrlClientProxy;

    public:
        virtual const tChar* getName() const { return "lcm_tclClientStartupCtrlClient"; }

        virtual tVoid vHandleMessage(lcm_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* /*puchData*/) {}
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        virtual tVoid sendFI_VersionGetValue(tVoid) {
            if (_StartupCtrlClientProxy) _StartupCtrlClientProxy->sendFI_VersionGet(* this);
        }
        virtual tVoid sendStartupFailureIndicationGetValue(tVoid) {
            if (_StartupCtrlClientProxy) _StartupCtrlClientProxy->sendStartupFailureIndicationGet(* this);
        }
        virtual tVoid sendStartupFailureIndicationSetValue(const StartupFailureInfo& StartupFailureIndication) {
            if (_StartupCtrlClientProxy) _StartupCtrlClientProxy->sendStartupFailureIndicationSet(StartupFailureIndication);
        }
        virtual tVoid sendStartupStatusGetValue(tVoid) {
            if (_StartupCtrlClientProxy) _StartupCtrlClientProxy->sendStartupStatusGet(* this);
        }
        virtual tVoid sendStartupStatusSetValue(const StartupState& StartupStatus) {
            if (_StartupCtrlClientProxy) _StartupCtrlClientProxy->sendStartupStatusSet(StartupStatus);
        }


        // lcm_ClientStartupCtrlClientDeclarationsPart: user specific code start
        // lcm_ClientStartupCtrlClientDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // ifndef _LCM_CLIENTSTARTUPCTRLCLIENT_H

