/*****************************************************************************
 * @file:         lcm_ClientSpm.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: lcm
 * @Template:     CcaProxy.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          CCA client
 *
 *          Do manual changes only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end 
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2019 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"


// lcm_ClientSpmIncludePart: user specific code start
//  boost::shared_ptr is used here cause by ASF interface.
// lcm_ClientSpmIncludePart: user specific code end

#include "lcm_ClientSpm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCM_CLIENT_SPM
#include "trcGenProj/Header/lcm_ClientSpm.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace lcm {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::SPM_CORE_FI;

// lcm_ClientSpmIncludePart2: user specific code start
// lcm_ClientSpmIncludePart2: user specific code end

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/Lcm/lcm_tclClientSpm", lcm_tclClientSpm, Info);


lcm_tclClientSpm::lcm_tclClientSpm(lcm_tclAppMain* baseRef)
   : Ilcm_tclClientSpm(baseRef)
   , _bSrvAvailable(FALSE)
   , _SpmProxy(SPM_CORE_FIProxy::createProxy("spmFiPort", * this) )
{
   LOG_INFO("Constructor for lcm_tclClientSpm called");
   ETG_TRACE_USR1( ( "Constructor for lcm_tclClientSpm called" ) );
   
   // lcm_ClientSpmlcm_tclClientSpm: user specific code start
   // lcm_ClientSpmlcm_tclClientSpm: user specific code end
}

lcm_tclClientSpm::~lcm_tclClientSpm(){
   LOG_INFO("~lcm_tclClientSpm called");
   ETG_TRACE_USR1( ( "~lcm_tclClientSpm called" ) );
   
   // lcm_ClientSpmlcm_tclClientSpmDest: user specific code start
   // lcm_ClientSpmlcm_tclClientSpmDest: user specific code end
}

void lcm_tclClientSpm::onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;

   ETG_TRACE_USR1( ( "lcm_tclClientSpm::onAvailable(): CALLED" ) );
   if (_SpmProxy == proxy){
      ETG_TRACE_USR1( ( "lcm_tclClientSpm : onAvailable _SpmProxy " ) );
      _SpmProxy->sendSysPwrModeUpReg(* this);

      // !!! Any UpReg's with parameter will not be generated --> parameter value are specific !!!

      // lcm_ClientSpmonAvailableUpregParam: user specific code start
      // lcm_ClientSpmonAvailableUpregParam: user specific code end

      _bSrvAvailable = TRUE;
   }
   // lcm_ClientSpmonAvailable: user specific code start
   // lcm_ClientSpmonAvailable: user specific code end
}

void lcm_tclClientSpm::onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;
   ETG_TRACE_USR1( ( "lcm_tclClientSpm::onUnavailable(): CALLED" ) );
   if (_SpmProxy == proxy){
      _bSrvAvailable = FALSE;
      ETG_TRACE_USR1( ( "lcm_tclClientSpm : onUnavailable _SpmProxy " ) );
   }
   // lcm_ClientSpmonUnavailable: user specific code start
   // lcm_ClientSpmonUnavailable: user specific code end

}

void lcm_tclClientSpm::onSysPwrModeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SysPwrModeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcm_tclClientSpm::onSysPwrModeError(): CALLED" ) );
   // lcm_ClientSpmonSysPwrModeError: user specific code start
   // lcm_ClientSpmonSysPwrModeError: user specific code end
}

void lcm_tclClientSpm::onSysPwrModeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SysPwrModeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcm_tclClientSpm::onSysPwrModeStatus(): CALLED" ) );

   // lcm_ClientSpmonSysPwrModeStart: user specific code start
   // lcm_ClientSpmonSysPwrModeStart: user specific code end
}


tVoid lcm_tclClientSpm::vHandleMessage(lcm_tclBaseIf::TMsg* pMsg) {
   // lcm_ClientSpmvHandleMessage: user specific code start
   (void)pMsg;
   // lcm_ClientSpmvHandleMessage: user specific code end
}

tVoid lcm_tclClientSpm::vGetReferences() {
   // lcm_ClientSpmvGetReferences: user specific code start
   // lcm_ClientSpmvGetReferences: user specific code end
}

tVoid lcm_tclClientSpm::vStartCommunication() {
   // lcm_ClientSpmvStartCommunication: user specific code start
   // lcm_ClientSpmvStartCommunication: user specific code end
}

tVoid lcm_tclClientSpm::vTraceInfo() {
   // lcm_ClientSpmvTraceInfo: user specific code start
   // lcm_ClientSpmvTraceInfo: user specific code end
}

tVoid lcm_tclClientSpm::sendSysPwrModeGet() {
    // lcm_tclClientSpm::sendSysPwrModeGet: user specific code start
    // lcm_tclClientSpm::sendSysPwrModeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSysPwrModeGet(* this);

    // lcm_tclClientSpm::sendSysPwrModeGetEnd: user specific code start
    // lcm_tclClientSpm::sendSysPwrModeGetEnd: user specific code end
}

// lcm_ClientSpmDefinitioPart: user specific code start
// lcm_ClientSpmDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace lcm {
