/****************************************************************************
  * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
  * This software is property of Robert Bosch GmbH. Unauthorized
  * duplication and disclosure to third parties is prohibited.
  ***************************************************************************/

/*!
  * \file     LifeCycleControlStub.cpp
  * \brief    Implementation of the LifeCycleControl
  *
  * \author   klaus-peter.kollai@de.bosch.com CM-AI/PJ-CB32
  * \todo implement the ASF callbacks "correctly" to also print content of parameter to remove LINT
  *
  * \par Copyright:
  * (c) 2013-2015 Robert Bosch Car Multimedia GmbH
  ***************************************************************************/
// include for etg support lib
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCM_SERVER_LCMDBUS
#include "trcGenProj/Header/LifeCycleControlStub.cpp.trc.h"
#endif

#include "IDbusProxy.h"

#include "LifeCycleControlStub.h"
//  boost::shared_ptr is used here cause by ASF interface.

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

using namespace ::asf::core;
using namespace ::org::genivi::NodeStateManager::LifecycleControl;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/lcm/LifeCycleControlStub", LifeCycleControlStub, Info);

/**
  *  \brief constructor of the class DBusProxy
  *
  *  \param [in] factory reference to the LCM-factory to get the references to other LCM classes
  *  \return class is created
  *
  *  \details constructs all stubs and permanent proxies. it checks if DBUS adress is defined
  */
LifeCycleControlStub::LifeCycleControlStub(lcm_tclAppMain *poMainAppl)
   : ILifeCycleControlStub(poMainAppl),
   LifecycleControlStub("LifecycleControlPort"){
   ETG_TRACE_USR1( ( "LifeCycleControlStub called" ) );
}

/**
  *  \brief Destructor of class
  *
  *  \return none
  *
  *  \details remove all dynamically created clients
  */
LifeCycleControlStub::~LifeCycleControlStub(){
   ETG_TRACE_USR1( ( "~LifeCycleControlStub called" ) );
}

/**
  *  \brief start working
  *
  *  \return
  *
  *  \details currenlty empty
  */
void LifeCycleControlStub::vStartCommunication(){
   _poIDbusProxy = dynamic_cast < IDbusProxy* >( _cpoMain->getHandler("IDbusProxy") );
   LCM_NULL_POINTER_CHECK(_poIDbusProxy);
}           // vStartCommunication

// ######################################
// LifecycleControlStub implementations
// ######################################
#if 1       // allow editor to collapse this section
   void LifeCycleControlStub::onRequestNodeRestartRequest(const ::boost::shared_ptr < RequestNodeRestartRequest >& request){
      ETG_TRACE_USR1( ( "Received onRequestNodeRestart" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LifeCycleControlStub::onSetApplicationModeRequest(const ::boost::shared_ptr < SetApplicationModeRequest >& request){
      ETG_TRACE_USR1( ( "Received onSetApplicationMode" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LifeCycleControlStub::onSetNodeStateRequest(const ::boost::shared_ptr < SetNodeStateRequest >& request){
      ETG_TRACE_USR1( ( "Received onSetNodeState" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LifeCycleControlStub::onSetBootModeRequest(const ::boost::shared_ptr < SetBootModeRequest >& request){
      ETG_TRACE_USR1( ( "Received onSetBootModeRequest" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LifeCycleControlStub::onSetAppHealthStatusRequest(const ::boost::shared_ptr < SetAppHealthStatusRequest >& request){
      ETG_TRACE_USR1( ( "Received onSetAppHealthStatus" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LifeCycleControlStub::onCheckLucRequiredRequest(const ::boost::shared_ptr < CheckLucRequiredRequest >& request){
      ETG_TRACE_USR1( ( "Received onCheckLucRequired" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

#endif // #if 1 // allow editor to collapse this section
}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

