/****************************************************************************
  * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
  * This software is property of Robert Bosch GmbH. Unauthorized
  * duplication and disclosure to third parties is prohibited.
  ***************************************************************************/

/*!
  * \file     LcmRecoveryClientStub.h
  *           Implementation of the stub part of recoveryClient
  *           this is used to reset the system if a unit reports
  *           failed state.
  *
  * \author   klaus-peter.kollai@de.bosch.com CM-AI/PJ-CB32
  *
  * \par Copyright:
  * (c) 2013-2013 Robert Bosch Car Multimedia GmbH
  ***************************************************************************/
#ifndef __RECOVERYCLIENTSTUB_H
#define __RECOVERYCLIENTSTUB_H

#include <iostream>

#include "asf/core/Logger.h"

#include "org/bosch/cm/lcm/Generic_RecoveryClientStub.h"

#include "lcm_AppMain.h"
#include "ILcmRecoveryClientStub.h"
#include "lcm_Config.h"
//  boost::shared_ptr is used here cause by ASF interface.

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class IDbusProxy;

class LcmRecoveryClientStub : public ILcmRecoveryClientStub
   , private ::org::bosch::cm::lcm::Generic_RecoveryClient::Generic_RecoveryClientStub
{
private:
/*! \var this set contains all units stopped. They should be ignored when RecoveryClient reports
  *  failed status. Stopping units with an OnFailure tag will lead to that.
   !*/
std::set < std::string > RecoveryClientIgnoreSet;

bool                     _bSupervisionActive;

DECLARE_CLASS_LOGGER();

public:
LcmRecoveryClientStub(lcm_tclAppMain *poMainAppl);
virtual ~LcmRecoveryClientStub();

// ISpmBase methods
virtual tVoid vHandleMessage(lcm_tclBaseIf::TMsg */*pMsg*/){}

virtual tVoid vGetReferences(){}
virtual tVoid vStartCommunication();

virtual tVoid vTraceInfo(){}

virtual tVoid vHandleTraceMessage(const tUChar */*puchData*/){}
virtual const tChar*getName() const { return( "DbusProxy" ); }

virtual void vUnitStopped(const std::string& UnitName);

virtual void vSupervisionStateChange(tBool SupervisionActive);

// ######################################
// Generic_RecoveryClientStub implementation
// ######################################
virtual void onSetFailedServiceNameRequest(const ::boost::shared_ptr < ::org::bosch::cm::lcm::Generic_RecoveryClient::SetFailedServiceNameRequest >& request);

virtual void onSetFailedServiceStatusRequest(const ::boost::shared_ptr < ::org::bosch::cm::lcm::Generic_RecoveryClient::SetFailedServiceStatusRequest >& request);

virtual void onSetCallStackRequestCounterRequest(const ::boost::shared_ptr < ::org::bosch::cm::lcm::Generic_RecoveryClient::SetCallStackRequestCounterRequest >& request);

virtual void onCheckResetConditionRequest (const ::boost::shared_ptr < ::org::bosch::cm::lcm::Generic_RecoveryClient::CheckResetConditionRequest >& request);

};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // ifndef __RECOVERYCLIENTSTUB_H

