/****************************************************************************
  * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
  * This software is property of Robert Bosch GmbH. Unauthorized
  * duplication and disclosure to third parties is prohibited.
  ***************************************************************************/

/*!
  * \file     LcmConsumerStub.h
  * \brief    Implementation of the LcmConsumerStub component
               needed to handle delayed StateChange request responses
  *
  * \author   klaus-peter.kollai@de.bosch.com CM-AI/PJ-CB32
  *
  * \par Copyright:
  * (c) 2013-2013 Robert Bosch Car Multimedia GmbH
  ***************************************************************************/
#ifndef __LCMCONSUMER_STUB_H
#define __LCMCONSUMER_STUB_H

#include "asf/core/Logger.h"

#include "org/genivi/NodeStateManager/ConsumerStub.h"

#include "lcm_AppMain.h"
#include "ILcmConsumerStub.h"

#include "ApplicationConfiguration.h"
//  boost::shared_ptr is used here cause by ASF interface.

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class IDbusProxy;

class LcmConsumerStub : public ILcmConsumerStub
   , private ::org::genivi::NodeStateManager::Consumer::ConsumerStub
{
private:
SpmApplicationConfiguration _oAppCfg;

DECLARE_CLASS_LOGGER();

public:
LcmConsumerStub(lcm_tclAppMain *poMainAppl);
virtual ~LcmConsumerStub();

// ISpmBase methods
virtual tVoid vHandleMessage(lcm_tclBaseIf::TMsg */*pMsg*/){}

virtual tVoid vGetReferences(){}
virtual tVoid vStartCommunication();

virtual tVoid vTraceInfo(){}

virtual tVoid vHandleTraceMessage(const tUChar */*puchData*/){}
virtual const tChar*getName() const { return( "LcmConsumerStub" ); }

virtual void vRegisterShutdownClient(const std::string strBusName,
                                     const std::string strObjName);

   virtual tU32 u32GetAppIdByName(const std::string& strName){ return( _oAppCfg.u32GetAppIdByName(strName) ); }

// ######################################
// ConsumerStub implementations
// ######################################
virtual void onGetNodeStateRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::GetNodeStateRequest >& request);

virtual void onSetSessionStateRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::SetSessionStateRequest >& request);

virtual void onGetSessionStateRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::GetSessionStateRequest >& request);

virtual void onGetApplicationModeRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::GetApplicationModeRequest >& request);

virtual void onRegisterShutdownClientRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::RegisterShutdownClientRequest >& request);

virtual void onUnRegisterShutdownClientRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::UnRegisterShutdownClientRequest >& request);

virtual void onRegisterSessionRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::RegisterSessionRequest >& request);

virtual void onUnRegisterSessionRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::UnRegisterSessionRequest >& request);

virtual void onGetAppHealthCountRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::GetAppHealthCountRequest >& request);

virtual void onGetInterfaceVersionRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::GetInterfaceVersionRequest >& request);

virtual void onLifecycleRequestCompleteRequest(const ::boost::shared_ptr < ::org::genivi::NodeStateManager::Consumer::LifecycleRequestCompleteRequest >& request);

private:
};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // ifndef __LCMCONSUMER_STUB_H

