/****************************************************************************
  * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
  * This software is property of Robert Bosch GmbH. Unauthorized
  * duplication and disclosure to third parties is prohibited.
  ***************************************************************************/

/*!
  * \file     LcmConsumerStub.cpp
  * \brief    Implementation of the LcmConsumerStub component
  *
  * \author   klaus-peter.kollai@de.bosch.com CM-AI/PJ-CB32
  * \todo implement the ASF callbacks "correctly" to also print content of parameter to remove LINT
  *
  * \par Copyright:
  * (c) 2013-2015 Robert Bosch Car Multimedia GmbH
  ***************************************************************************/
// include for etg support lib
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCM_SERVER_LCMDBUS
#include "trcGenProj/Header/LcmConsumerStub.cpp.trc.h"
#endif

#include "IDbusProxy.h"
#include "IDbusUnitProxy.h"
#include "IDbusServiceProxy.h"
#include "ILcmConsumerStub.h"
#include "ILifeCycleConsumerProxy.h"
#include "I_lcm_ServiceLcmDbusIf.h"

// include type definitions of Genivi
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"

#include "LcmConsumerStub.h"
//  boost::shared_ptr is used here cause by ASF interface.

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

using namespace ::asf::core;
using namespace ::org::genivi::NodeStateManager::Consumer;
using namespace ::org::genivi::NodeStateManager::LcmErrorTypes;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/lcm/LcmConsumerStub", LcmConsumerStub, Info);

/**
  *  \brief constructor of the class LcmConsumerStub
  *
  *  \param [in] factory reference to the LCM-factory to get the references to other LCM classes
  *  \return class is created
  *
  *  \details constructs all stubs and permanent proxies. it checks if DBUS adress is defined
  */
LcmConsumerStub::LcmConsumerStub(lcm_tclAppMain *poMainAppl)
   : ILcmConsumerStub(poMainAppl)
   , ConsumerStub("ConsumerPort"){
   ETG_TRACE_USR1( ( "LcmConsumerStub called" ) );
}

/**
  *  \brief Destructor of class
  *
  *  \return none
  *
  *  \details remove all dynamically created clients
  */
LcmConsumerStub::~LcmConsumerStub(){
   ETG_TRACE_USR1( ( "~LcmConsumerStub called" ) );
}

/**
  *  \brief start working
  *
  *  \return
  *
  *  \details currenlty empty
  */
void LcmConsumerStub::vStartCommunication(){
   _poIDbusProxy = dynamic_cast < IDbusProxy* >( _cpoMain->getHandler("IDbusProxy") );
   LCM_NULL_POINTER_CHECK(_poIDbusProxy);
}           // vStartCommunication

/**
  *  \brief add the LifeCycleConsumerProxy
  *
  *  \param [in] strBusName DBus busname - given by registration
  *  \param [in] strObjName DBus Object path - given by registration
  *  \return none
  *
  *  \details when an application sends the register message a LifeCycleConsumerProxy must be created tp handle the
  *           application state messages. The required busname and objectpath are arguments of the register message
  */
void LcmConsumerStub::vRegisterShutdownClient(const std::string strBusName,
                                              const std::string strObjName){
   ETG_TRACE_USR1( ( "RegisterShutdownClient\n  BusName=%40s\n  ObjName=%60s", strBusName.c_str(), strObjName.c_str() ) );

   LCM_NULL_POINTER_CHECK(_poIDbusProxy);
   std::string               strSwBlockName            = _poIDbusProxy->ExtractApplicationName(strObjName);
   std::string               strServiceName               = _oAppCfg.strGetServiceNameByName(strSwBlockName);
   std::string               strEscapedUnitName           = _poIDbusProxy->unitNameEscape(strServiceName);
   std::string               strObjectPath                = "/org/freedesktop/systemd1/unit/" + strEscapedUnitName;

   ILifeCycleConsumerProxy  *poILifeCycleConsumerProxy = dynamic_cast < ILifeCycleConsumerProxy* >( _cpoMain->getHandler("ILifeCycleConsumerProxy") );
   LCM_NULL_POINTER_CHECK(poILifeCycleConsumerProxy);
   poILifeCycleConsumerProxy->AddLifeCycleConsumerProxy(strBusName, strObjName);
   // add Unit and Service Proxies if unit was started indirectly
   IDbusUnitProxy           *poIDbusUnitProxy          = dynamic_cast < IDbusUnitProxy* >( _cpoMain->getHandler("IDbusUnitProxy") );
   LCM_NULL_POINTER_CHECK(poIDbusUnitProxy);
   poIDbusUnitProxy->vAddUnitProxy(strServiceName, strObjectPath);

   IDbusServiceProxy        *poIDbusServiceProxy       = dynamic_cast < IDbusServiceProxy* >( _cpoMain->getHandler("IDbusServiceProxy") );
   LCM_NULL_POINTER_CHECK(poIDbusServiceProxy);
   poIDbusServiceProxy->vAddServiceProxy(strServiceName, strObjectPath);

   // add new app to database
   Ilcm_tclServiceLcmDbusIf *poServerRef               = dynamic_cast < Ilcm_tclServiceLcmDbusIf* >( _cpoMain->getHandler("Ilcm_tclServiceLcmDbusIf") );
   LCM_NULL_POINTER_CHECK(poServerRef);
   ILcmConsumerStub         *poILcmConsumerStub        = dynamic_cast < ILcmConsumerStub* >( _cpoMain->getHandler("ILcmConsumerStub") );
   LCM_NULL_POINTER_CHECK(poILcmConsumerStub);
   poServerRef->sendAppStartRequestStatus(strSwBlockName.c_str(), strServiceName.c_str(), poILcmConsumerStub->u32GetAppIdByName(strSwBlockName) );
   poIDbusServiceProxy->vTriggerGetMainPid(strServiceName);
}           // vRegisterShutdownClient

// ######################################
// ConsumerStub implementations
// ######################################
#if 1       // allow editor to collapse this section
   void LcmConsumerStub::onGetNodeStateRequest(const ::boost::shared_ptr < GetNodeStateRequest >& request){
      ETG_TRACE_USR1( ( "Received onGetNodeState" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LcmConsumerStub::onSetSessionStateRequest(const ::boost::shared_ptr < SetSessionStateRequest >& request){
      ETG_TRACE_USR1( ( "Received onSetSessionState" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LcmConsumerStub::onGetSessionStateRequest(const ::boost::shared_ptr < GetSessionStateRequest >& request){
      ETG_TRACE_USR1( ( "Received onGetSessionState" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LcmConsumerStub::onGetApplicationModeRequest(const ::boost::shared_ptr < GetApplicationModeRequest >& request){
      ETG_TRACE_USR1( ( "Received onGetApplicationMode" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LcmConsumerStub::onRegisterShutdownClientRequest(const ::boost::shared_ptr < RegisterShutdownClientRequest >& request){
      ETG_TRACE_USR1( ( "Received onRegisterShutdownClient " ) );
      if(request->hasBusName() ){
         std::string BusName = request->getBusName();
         if(request->hasObjName() ){
            std::string ObjName = request->getObjName();
            vRegisterShutdownClient(BusName, ObjName);
         } else {
            ETG_TRACE_ERRMEM( ( "No ObjName found" ) );
         }
      } else {
            ETG_TRACE_ERRMEM( ( "No Busname found" ) );
      }
            sendRegisterShutdownClientResponse(_NsmErrorStatus_e__NsmErrorStatus_Ok, request->getAct() );
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LcmConsumerStub::onUnRegisterShutdownClientRequest(const ::boost::shared_ptr < UnRegisterShutdownClientRequest >& request){
      ETG_TRACE_USR1( ( "Received onUnRegisterShutdownClient" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LcmConsumerStub::onRegisterSessionRequest(const ::boost::shared_ptr < RegisterSessionRequest >& request){
      ETG_TRACE_USR1( ( "Received onRegisterSession" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LcmConsumerStub::onUnRegisterSessionRequest(const ::boost::shared_ptr < UnRegisterSessionRequest >& request){
      ETG_TRACE_USR1( ( "Received onUnRegisterSession" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LcmConsumerStub::onGetAppHealthCountRequest(const ::boost::shared_ptr < GetAppHealthCountRequest >& request){
      ETG_TRACE_USR1( ( "Received onGetAppHealthCount" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LcmConsumerStub::onGetInterfaceVersionRequest(const ::boost::shared_ptr < GetInterfaceVersionRequest >& request){
      ETG_TRACE_USR1( ( "Received onGetInterfaceVersion" ) );
      (tVoid)request;
   }        //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   void LcmConsumerStub::onLifecycleRequestCompleteRequest(const ::boost::shared_ptr < LifecycleRequestCompleteRequest >& request){
      uint32                   u32AppId                   = request->getRequestId();

      ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e eStatus = request->getStatus();

      ETG_TRACE_USR1( ( "Received onLifecycleRequestComplete for RequestId 0x%08x, %u", u32AppId, ETG_ENUM(SPM_APPSTATE_DEF, eStatus) ) );
      ILifeCycleConsumerProxy *_poILifeCycleConsumerProxy = dynamic_cast < ILifeCycleConsumerProxy* >( _cpoMain->getHandler("ILifeCycleConsumerProxy") );
      LCM_NULL_POINTER_CHECK(_poILifeCycleConsumerProxy);
      if (_poILifeCycleConsumerProxy->bHandleLifeCycleRequestResponses(u32AppId, eStatus) == TRUE){
         sendLifecycleRequestCompleteResponse(_NsmErrorStatus_e__NsmErrorStatus_Ok,    request->getAct() );
      } else {
         sendLifecycleRequestCompleteResponse(_NsmErrorStatus_e__NsmErrorStatus_Error, request->getAct() );
      }

   }        // onLifecycleRequestCompleteRequest

#endif      // #if 1 // allow editor to collapse this section
}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

